/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class PanningSelectionTool
extends SelectionTool {
    private boolean isSpaceBarDown = false;
    private Point viewLocation;
    protected static final int PAN = 128;
    protected static final int PAN_IN_PROGRESS = 256;
    protected static final int MAX_STATE = 256;

    protected boolean acceptSpaceBar(KeyEvent e) {
        return e.character == ' ' && (e.stateMask & 0x40000) == 0;
    }

    protected String getDebugName() {
        return "Panning Tool";
    }

    protected String getDebugNameForState(int state) {
        if (state == 128) {
            return "Pan Initial";
        }
        if (state == 256) {
            return "Pan In Progress";
        }
        return super.getDebugNameForState(state);
    }

    protected Cursor getDefaultCursor() {
        if (this.isInState(384)) {
            return SharedCursors.HAND;
        }
        return super.getDefaultCursor();
    }

    protected boolean handleButtonDown(int which) {
        if (which == 1 && this.getCurrentViewer().getControl() instanceof FigureCanvas && this.stateTransition(128, 256)) {
            this.viewLocation = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport().getViewLocation();
            return true;
        }
        return super.handleButtonDown(which);
    }

    protected boolean handleButtonUp(int which) {
        if (which == 1 && this.isSpaceBarDown && this.stateTransition(256, 128)) {
            return true;
        }
        if (which == 1 && this.stateTransition(256, 1)) {
            this.refreshCursor();
            return true;
        }
        return super.handleButtonUp(which);
    }

    protected boolean handleDrag() {
        if (this.isInState(256) && this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)this.getCurrentViewer().getControl();
            canvas.scrollTo(this.viewLocation.x - this.getDragMoveDelta().width, this.viewLocation.y - this.getDragMoveDelta().height);
            return true;
        }
        return super.handleDragInProgress();
    }

    protected boolean handleFocusLost() {
        if (this.isInState(384)) {
            this.setState(1);
            this.refreshCursor();
            return true;
        }
        return super.handleFocusLost();
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (this.acceptSpaceBar(e)) {
            this.isSpaceBarDown = true;
            if (this.stateTransition(1, 128)) {
                this.refreshCursor();
            }
            return true;
        }
        if (this.stateTransition(128, 1)) {
            this.refreshCursor();
            this.isSpaceBarDown = false;
            return true;
        }
        if (this.isInState(256)) {
            this.isSpaceBarDown = false;
        }
        return super.handleKeyDown(e);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (this.acceptSpaceBar(e)) {
            this.isSpaceBarDown = false;
            if (this.stateTransition(128, 1)) {
                this.refreshCursor();
            }
            return true;
        }
        return super.handleKeyUp(e);
    }
}

