/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import java.util.Collection;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.internal.graph.CollapsedEdges;
import org.eclipse.draw2d.internal.graph.HorizontalPlacement;

class NodeCluster
extends NodeList {
    int hashCode = new Object().hashCode();
    boolean isSetMember;
    boolean isDirty;
    boolean leftDirty;
    boolean rightDirty;
    int leftFreedom;
    int rightFreedom;
    int leftNonzero;
    int rightNonzero;
    int leftCount = 0;
    int rightCount = 0;
    CollapsedEdges[] leftLinks = new CollapsedEdges[20];
    CollapsedEdges[] rightLinks = new CollapsedEdges[20];
    NodeCluster[] leftNeighbors = new NodeCluster[20];
    NodeCluster[] rightNeighbors = new NodeCluster[20];
    int effectivePull;
    int weightedTotal;
    int weightedDivisor;
    int unweightedTotal;
    int unweightedDivisor;

    NodeCluster() {
    }

    void addLeftNeighbor(NodeCluster neighbor, CollapsedEdges link) {
        this.leftNeighbors[this.leftCount] = neighbor;
        this.leftLinks[this.leftCount++] = link;
    }

    void addRightNeighbor(NodeCluster neighbor, CollapsedEdges link) {
        this.rightNeighbors[this.rightCount] = neighbor;
        this.rightLinks[this.rightCount++] = link;
    }

    public void adjustRank(int delta, Collection affected) {
        CollapsedEdges edges;
        NodeCluster neighbor;
        int i;
        this.adjustRank(delta);
        if (HorizontalPlacement.debugCount != -1) {
            i = 0;
            while (i < this.size()) {
                HorizontalPlacement.lastAdjusted.add(((Node)this.get((int)i)).data);
                ++i;
            }
        }
        i = 0;
        while (i < this.leftCount) {
            neighbor = this.leftNeighbors[i];
            if (!neighbor.isSetMember) {
                edges = this.leftLinks[i];
                neighbor.weightedTotal += delta * edges.collapsedWeight;
                neighbor.unweightedTotal += delta * edges.collapsedCount;
                this.weightedTotal -= delta * edges.collapsedWeight;
                this.unweightedTotal -= delta * edges.collapsedCount;
                this.leftDirty = true;
                neighbor.rightDirty = true;
                if (!neighbor.isDirty) {
                    neighbor.isDirty = true;
                    affected.add(neighbor);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.rightCount) {
            neighbor = this.rightNeighbors[i];
            if (!neighbor.isSetMember) {
                edges = this.rightLinks[i];
                neighbor.weightedTotal += delta * edges.collapsedWeight;
                neighbor.unweightedTotal += delta * edges.collapsedCount;
                this.weightedTotal -= delta * edges.collapsedWeight;
                this.unweightedTotal -= delta * edges.collapsedCount;
                this.rightDirty = true;
                neighbor.leftDirty = true;
                if (!neighbor.isDirty) {
                    neighbor.isDirty = true;
                    affected.add(neighbor);
                }
            }
            ++i;
        }
        this.isDirty = true;
        affected.add(this);
    }

    public boolean equals(Object o) {
        return o == this;
    }

    CollapsedEdges getLeftNeighbor(NodeCluster neighbor) {
        int i = 0;
        while (i < this.leftCount) {
            if (this.leftNeighbors[i] == neighbor) {
                return this.leftLinks[i];
            }
            ++i;
        }
        return null;
    }

    int getPull() {
        return this.effectivePull;
    }

    CollapsedEdges getRightNeighbor(NodeCluster neighbor) {
        int i = 0;
        while (i < this.rightCount) {
            if (this.rightNeighbors[i] == neighbor) {
                return this.rightLinks[i];
            }
            ++i;
        }
        return null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    void initValues() {
        int slack;
        CollapsedEdges edges;
        this.weightedTotal = 0;
        this.weightedDivisor = 0;
        this.unweightedTotal = 0;
        this.rightFreedom = Integer.MAX_VALUE;
        this.leftFreedom = Integer.MAX_VALUE;
        this.rightNonzero = Integer.MAX_VALUE;
        this.leftNonzero = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.leftCount) {
            edges = this.leftLinks[i];
            this.weightedTotal -= edges.getWeightedPull();
            this.unweightedTotal -= edges.tightestEdge.getSlack();
            this.unweightedDivisor += edges.collapsedCount;
            this.weightedDivisor += edges.collapsedWeight;
            slack = edges.tightestEdge.getSlack();
            this.leftFreedom = Math.min(slack, this.leftFreedom);
            if (slack > 0) {
                this.leftNonzero = Math.min(slack, this.leftNonzero);
            }
            ++i;
        }
        i = 0;
        while (i < this.rightCount) {
            edges = this.rightLinks[i];
            this.weightedTotal += edges.getWeightedPull();
            this.unweightedDivisor += edges.collapsedCount;
            this.unweightedTotal += edges.tightestEdge.getSlack();
            this.weightedDivisor += edges.collapsedWeight;
            slack = edges.tightestEdge.getSlack();
            this.rightFreedom = Math.min(slack, this.rightFreedom);
            if (slack > 0) {
                this.rightNonzero = Math.min(slack, this.rightNonzero);
            }
            ++i;
        }
        this.updateEffectivePull();
    }

    void refreshValues() {
        int slack;
        CollapsedEdges edges;
        int i;
        this.isDirty = false;
        if (this.leftDirty) {
            this.leftDirty = false;
            this.leftFreedom = Integer.MAX_VALUE;
            this.leftNonzero = Integer.MAX_VALUE;
            i = 0;
            while (i < this.leftCount) {
                edges = this.leftLinks[i];
                slack = edges.tightestEdge.getSlack();
                this.leftFreedom = Math.min(slack, this.leftFreedom);
                if (slack > 0) {
                    this.leftNonzero = Math.min(slack, this.leftNonzero);
                }
                ++i;
            }
        }
        if (this.rightDirty) {
            this.rightDirty = false;
            this.rightFreedom = Integer.MAX_VALUE;
            this.rightNonzero = Integer.MAX_VALUE;
            i = 0;
            while (i < this.rightCount) {
                edges = this.rightLinks[i];
                slack = edges.tightestEdge.getSlack();
                this.rightFreedom = Math.min(slack, this.rightFreedom);
                if (slack > 0) {
                    this.rightNonzero = Math.min(slack, this.rightNonzero);
                }
                ++i;
            }
        }
        this.updateEffectivePull();
    }

    private void updateEffectivePull() {
        this.effectivePull = this.weightedDivisor != 0 ? this.weightedTotal / this.weightedDivisor : (this.unweightedDivisor != 0 ? this.unweightedTotal / this.unweightedDivisor : 0);
    }
}

