/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.TextLayout;

public class TextFlow
extends InlineFlow {
    static final String ELLIPSIS = "...";
    static final int SELECT_ALL = 1;
    static final int SELECT_PARTIAL = 2;
    private int selectBegin = -1;
    private int selectEnd = -1;
    private String text;

    public TextFlow() {
        this(new String());
    }

    public TextFlow(String s) {
        this.text = s;
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new ParagraphTextLayout(this);
    }

    public int getNextOffset(Point p, boolean down) {
        if (down) {
            return this.findNextLineOffset(p);
        }
        return this.findPreviousLineOffset(p);
    }

    private int findNextLineOffset(Point p) {
        int n;
        if (this.getBounds().bottom() < p.y) {
            return -1;
        }
        TextFragmentBox box = null;
        int i = 0;
        while (i < this.fragments.size()) {
            box = (TextFragmentBox)this.fragments.get(i);
            if (box.getBaseline() > p.y) break;
            box = null;
            ++i;
        }
        if (box == null) {
            return -1;
        }
        TextLayout layout = new TextLayout(null);
        try {
            layout.setText(this.text.substring(box.offset, box.offset + box.length));
            int[] trailing = new int[1];
            n = box.offset + layout.getOffset(p.x - box.x, p.y - box.y, trailing) + trailing[0];
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            layout.dispose();
            throw throwable;
        }
        layout.dispose();
        return n;
    }

    private int findPreviousLineOffset(Point p) {
        int n;
        if (this.getBounds().y > p.y) {
            return -1;
        }
        TextFragmentBox box = null;
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            box = (TextFragmentBox)this.fragments.get(i);
            if (box.getBaseline() < p.y) break;
            --i;
        }
        if (box == null) {
            return -1;
        }
        TextLayout layout = new TextLayout(null);
        try {
            layout.setText(this.text.substring(box.offset, box.offset + box.length));
            int[] trailing = new int[1];
            n = box.offset + layout.getOffset(p.x - box.x, p.y - box.y, trailing) + trailing[0];
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            layout.dispose();
            throw throwable;
        }
        layout.dispose();
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rectangle getCaretPlacement(int offset) {
        Point where;
        TextFragmentBox box;
        if (offset < 0 || offset > this.text.length()) {
            throw new IllegalArgumentException("Offset: " + offset + " is invalid");
        }
        int i = this.fragments.size();
        do {
            box = (TextFragmentBox)this.fragments.get(--i);
        } while (offset < box.offset && i > 0);
        offset -= box.offset;
        offset = Math.min(box.length, offset);
        TextLayout layout = new TextLayout(null);
        try {
            layout.setFont(this.getFont());
            String substring = this.text.substring(box.offset, box.offset + box.length);
            layout.setText(substring);
            where = new Point(layout.getLocation(offset, false));
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            layout.dispose();
            layout = null;
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        layout.dispose();
        layout = null;
        FontMetrics fm = FigureUtilities.getFontMetrics(this.getFont());
        return new Rectangle(where.x + box.x, where.y + box.y, 1, fm.getAscent() + fm.getLeading() + fm.getDescent());
    }

    public int getFirstOffsetForLine(int y) {
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (y >= box.y && y < box.y + box.getHeight()) {
                return box.offset;
            }
            ++i;
        }
        return -1;
    }

    public int getLastOffsetForLine(int y) {
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (y >= box.y && y < box.y + box.getHeight()) {
                return box.offset + box.length;
            }
            --i;
        }
        return -1;
    }

    public int getOffset(Point p) {
        if (!this.getBounds().contains(p)) {
            return -1;
        }
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (box.containsPoint(p.x, p.y)) {
                int n;
                String substring = this.text.substring(box.offset, box.offset + box.length);
                TextLayout layout = new TextLayout(null);
                try {
                    layout.setFont(this.getFont());
                    layout.setText(substring);
                    int[] trailing = new int[1];
                    int result = layout.getOffset(p.x - box.x, p.y - box.y, trailing);
                    n = result + trailing[0] + box.offset;
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    layout.dispose();
                    layout = null;
                    throw throwable;
                }
                layout.dispose();
                layout = null;
                return n;
            }
            --i;
        }
        return -1;
    }

    public String getText() {
        return this.text;
    }

    public boolean isTextTruncated() {
        int i = 0;
        while (i < this.fragments.size()) {
            if (((TextFragmentBox)this.fragments.get((int)i)).truncated) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintFigure(Graphics g) {
        g.getClip(Rectangle.SINGLETON);
        int yStart = Rectangle.SINGLETON.y;
        int yEnd = Rectangle.SINGLETON.bottom();
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox frag = (TextFragmentBox)this.fragments.get(i);
            if (yStart <= frag.y + frag.getHeight() + 1) {
                if (yEnd < frag.y) {
                    return;
                }
                int selectType = this.selectBegin == -1 ? 0 : (this.selectEnd < frag.offset ? 0 : (this.selectBegin > frag.offset + frag.length ? 0 : (this.selectBegin <= frag.offset && this.selectEnd >= frag.offset + frag.length ? 1 : 2)));
                String draw = frag.truncated ? String.valueOf(this.text.substring(frag.offset, frag.offset + frag.length)) + ELLIPSIS : this.text.substring(frag.offset, frag.offset + frag.length);
                if (!this.isEnabled()) {
                    g.setForegroundColor(ColorConstants.buttonLightest);
                    g.drawString(draw, frag.x + 1, frag.y + 1);
                    g.setForegroundColor(ColorConstants.buttonDarker);
                    g.drawString(draw, frag.x, frag.y);
                    g.restoreState();
                } else if (selectType == 0) {
                    g.drawString(draw, frag.x, frag.y);
                } else if (selectType == 1) {
                    Color fg = g.getForegroundColor();
                    Color bg = g.getBackgroundColor();
                    g.setForegroundColor(ColorConstants.menuForegroundSelected);
                    g.setBackgroundColor(ColorConstants.menuBackgroundSelected);
                    g.fillString(draw, frag.x, frag.y);
                    g.setForegroundColor(fg);
                    g.setBackgroundColor(bg);
                } else {
                    Object var9_9;
                    TextLayout layout = new TextLayout(null);
                    layout.setFont(this.getFont());
                    try {
                        layout.setText(this.text.substring(frag.offset, frag.offset + frag.length));
                        g.drawTextLayout(layout, frag.x, frag.y, this.selectBegin - frag.offset, this.selectEnd - frag.offset, null, null);
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        layout.dispose();
                        layout = null;
                        throw throwable;
                    }
                    {
                        var9_9 = null;
                    }
                    layout.dispose();
                    layout = null;
                }
            }
            ++i;
        }
        return;
    }

    public void setSelection(int begin, int end) {
        boolean repaint = false;
        --end;
        if (this.selectBegin == begin) {
            if (this.selectEnd == end) {
                return;
            }
            repaint = true;
        } else {
            repaint = this.selectBegin != this.selectEnd || begin != end;
        }
        this.selectBegin = begin;
        this.selectEnd = end;
        if (repaint) {
            this.repaint();
        }
    }

    public void setText(String s) {
        this.text = s;
        this.revalidate();
        this.repaint();
    }
}

