/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDisposer;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.BeaninfosDoc;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfosDocEntry;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.ui.BPBeaninfoListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPSearchListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfosWorkbookPage;
import org.eclipse.jem.internal.beaninfo.ui.BuildSearchBasePage;
import org.eclipse.jem.internal.beaninfo.ui.PackagesWorkbookPage;
import org.eclipse.jem.internal.beaninfo.ui.SearchPathListLabelProvider;
import org.eclipse.jem.internal.beaninfo.ui.SearchpathOrderingWorkbookPage;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public class BeaninfoPathsBlock {
    private IWorkspaceRoot fWorkspaceRoot;
    private CheckedListDialogField fSearchOrder;
    private SelectionButtonDialogField fEnableBeaninfoDialogField;
    private StatusInfo fSearchStatus;
    private IJavaProject fCurrJProject;
    private IStatusChangeListener fContext;
    private PackagesWorkbookPage fPackagesPage;
    private BeaninfosWorkbookPage fBeaninfosPage;
    private BuildSearchBasePage fCurrPage;
    private SearchPathListLabelProvider labelProvider;
    private boolean inUpdate;

    public BeaninfoPathsBlock(IWorkspaceRoot root, IStatusChangeListener context) {
        this.fWorkspaceRoot = root;
        this.fContext = context;
        this.fCurrPage = null;
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_up_button;
        stringArray[1] = BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_down_button;
        stringArray[3] = BeanInfoUIMessages.BeanInfoPathsBlock_ExportAll;
        stringArray[4] = BeanInfoUIMessages.BeanInfoPathsBlock_UnexportAll;
        String[] buttonLabels = stringArray;
        this.labelProvider = new SearchPathListLabelProvider();
        this.fSearchOrder = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)this.labelProvider);
        this.fSearchOrder.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fSearchOrder.setLabelText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_label);
        this.fSearchOrder.setUpButtonIndex(0);
        this.fSearchOrder.setDownButtonIndex(1);
        this.fSearchOrder.setCheckAllButtonIndex(3);
        this.fSearchOrder.setUncheckAllButtonIndex(4);
        this.fEnableBeaninfoDialogField = new SelectionButtonDialogField(32);
        this.fEnableBeaninfoDialogField.setLabelText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__enablebeaninfo);
        this.fSearchStatus = new StatusInfo();
        this.fCurrJProject = null;
    }

    public CheckedListDialogField getSearchOrder() {
        return this.fSearchOrder;
    }

    public void setSearchOrderElements(List newElements) {
        ArrayList<BPListElement> exportedEntries = new ArrayList<BPListElement>(newElements.size());
        Iterator iter = newElements.iterator();
        while (iter.hasNext()) {
            BPListElement element = (BPListElement)iter.next();
            if (!element.isExported()) continue;
            exportedEntries.add(element);
        }
        this.inUpdate = true;
        this.fSearchOrder.setElements((Collection)newElements);
        this.inUpdate = false;
        this.fSearchOrder.setCheckedElements(exportedEntries);
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeaninfoPathsBlock.this.tabChanged(e.item);
            }
        });
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        ArrayList interestedDialogFields = new ArrayList(3);
        this.fPackagesPage = new PackagesWorkbookPage(this.fWorkspaceRoot, this, interestedDialogFields);
        TabItem item = new TabItem(folder, 0);
        item.setText(BeanInfoUIMessages.BeanInfoPathsBlock_Page_Tab_Packages);
        item.setImage(imageRegistry.get("org.eclipse.jdt.ui.package_obj.gif"));
        item.setData((Object)this.fPackagesPage);
        item.setControl(this.fPackagesPage.getControl((Composite)folder));
        Image fBeanImage = null;
        URL imageURL = Platform.find((Bundle)JEMUIPlugin.getPlugin().getBundle(), (IPath)new Path("icons/javabean.gif"));
        fBeanImage = imageURL != null ? ImageDescriptor.createFromURL((URL)imageURL).createImage() : ImageDescriptor.getMissingImageDescriptor().createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(fBeanImage));
        this.fBeaninfosPage = new BeaninfosWorkbookPage(this.fWorkspaceRoot, this, interestedDialogFields);
        item = new TabItem(folder, 0);
        item.setText(BeanInfoUIMessages.BeanInfoPathsBlock_Page_Tab_Classes);
        item.setImage(fBeanImage);
        item.setData((Object)this.fBeaninfosPage);
        item.setControl(this.fBeaninfosPage.getControl((Composite)folder));
        Image cpoImage = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        SearchpathOrderingWorkbookPage ordpage = new SearchpathOrderingWorkbookPage((ListDialogField)this.fSearchOrder, interestedDialogFields);
        item = new TabItem(folder, 0);
        item.setText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__serachpath_tab_order);
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrJProject != null) {
            this.fPackagesPage.init(this.fCurrJProject);
            this.fBeaninfosPage.init(this.fCurrJProject);
        }
        this.fEnableBeaninfoDialogField.doFillIntoGrid(composite, 1);
        this.fEnableBeaninfoDialogField.attachDialogFields(interestedDialogFields.toArray(new DialogField[interestedDialogFields.size()]));
        folder.setSelection(2);
        this.fCurrPage = ordpage;
        this.fSearchOrder.selectFirstElement();
        return composite;
    }

    public void init(IJavaProject jproject) {
        block17: {
            this.fCurrJProject = jproject;
            this.labelProvider.setJavaProject(jproject);
            try {
                boolean haveConfigFile = jproject.getProject().getFile(".beaninfoConfig").exists();
                boolean haveNature = this.fCurrJProject.getProject().hasNature("org.eclipse.jem.beaninfo.BeanInfoNature");
                this.fEnableBeaninfoDialogField.setSelection(haveConfigFile || haveNature);
                if (haveNature || haveConfigFile) {
                    BeaninfosDoc doc = BeaninfoNature.getRuntime((IProject)this.fCurrJProject.getProject()).getSearchPath();
                    IClasspathEntry[] raw = this.fCurrJProject.getRawClasspath();
                    ArrayList<BPBeaninfoListElement> newSearchpath = new ArrayList<BPBeaninfoListElement>();
                    if (doc != null) {
                        IBeaninfosDocEntry[] sp = doc.getSearchpath();
                        int i = 0;
                        while (i < sp.length) {
                            IBeaninfosDocEntry curr = sp[i];
                            boolean isMissing = false;
                            BPListElement elem = null;
                            if (curr instanceof BeaninfoEntry) {
                                BeaninfoEntry be = (BeaninfoEntry)curr;
                                Object[] paths = be.getClasspath(this.fCurrJProject);
                                if (paths != null && paths.length > 0) {
                                    int j = 0;
                                    while (!isMissing && j < paths.length) {
                                        File f;
                                        Object path = paths[i];
                                        isMissing = path instanceof IProject ? !((IProject)path).exists() : (path instanceof String ? !(f = new File((String)path)).exists() : (path instanceof IPath ? true : true));
                                        ++j;
                                    }
                                } else {
                                    isMissing = true;
                                }
                                elem = new BPBeaninfoListElement(be, this.getInitialSearchpaths(be), isMissing);
                            } else {
                                boolean isExported = false;
                                boolean isPackageMissing = true;
                                isMissing = true;
                                SearchpathEntry ce = (SearchpathEntry)curr;
                                int kind = ce.getKind();
                                IPath path = ce.getPath();
                                int j = 0;
                                block5: while (j < raw.length) {
                                    if (raw[j].getEntryKind() == kind && raw[j].getPath().equals((Object)path)) {
                                        isMissing = false;
                                        isExported = raw[j].isExported() || raw[j].getEntryKind() == 3;
                                        String packageName = ce.getPackage();
                                        if (packageName != null) {
                                            IPackageFragmentRoot[] roots = this.fCurrJProject.findPackageFragmentRoots(raw[j]);
                                            int k = 0;
                                            while (k < roots.length) {
                                                IPackageFragmentRoot iroot = roots[k];
                                                if (iroot.getPackageFragment(packageName).exists()) {
                                                    isPackageMissing = false;
                                                    break block5;
                                                }
                                                ++k;
                                            }
                                            break;
                                        }
                                        isPackageMissing = false;
                                        break;
                                    }
                                    ++j;
                                }
                                elem = new BPSearchListElement(ce, isMissing, isPackageMissing, isExported);
                            }
                            newSearchpath.add((BPBeaninfoListElement)elem);
                            ++i;
                        }
                    }
                    this.setSearchOrderElements(newSearchpath);
                    if (this.fPackagesPage != null) {
                        this.fPackagesPage.init(this.fCurrJProject);
                        this.fBeaninfosPage.init(this.fCurrJProject);
                    }
                    break block17;
                }
                this.fEnableBeaninfoDialogField.setSelection(false);
            }
            catch (JavaModelException javaModelException) {
                this.fEnableBeaninfoDialogField.setSelection(false);
            }
            catch (CoreException coreException) {
                this.fEnableBeaninfoDialogField.setSelection(false);
            }
        }
        this.doStatusLineUpdate();
    }

    private BPSearchListElement[] getInitialSearchpaths(BeaninfoEntry infoEntry) {
        IClasspathEntry resolved;
        IResource res;
        IPackageFragmentRoot[] roots = null;
        if (infoEntry.getKind() != 100 && (res = this.fWorkspaceRoot.findMember((resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)infoEntry.getClasspathEntry())).getPath())) != null && res.exists()) {
            if (res instanceof IProject) {
                IJavaProject jp = (IJavaProject)JavaCore.create((IResource)res);
                try {
                    if (jp != null) {
                        roots = jp.getPackageFragmentRoots();
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else {
                IProject containingProject = res.getProject();
                IJavaProject jp = JavaCore.create((IProject)containingProject);
                if (jp != null) {
                    try {
                        IPackageFragmentRoot root = jp.findPackageFragmentRoot(resolved.getPath());
                        if (root != null) {
                            roots = new IPackageFragmentRoot[]{root};
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
        SearchpathEntry[] entries = infoEntry.getSearchPaths();
        BPSearchListElement[] packageElements = new BPSearchListElement[entries.length];
        int i = 0;
        while (i < entries.length) {
            boolean isPackageMissing = roots != null;
            SearchpathEntry ce = entries[i];
            if (roots != null) {
                String packageName = ce.getPackage();
                int k = 0;
                while (k < roots.length) {
                    IPackageFragmentRoot iroot = roots[k];
                    if (iroot.getPackageFragment(packageName).exists()) {
                        isPackageMissing = false;
                        break;
                    }
                    ++k;
                }
            }
            packageElements[i] = new BPSearchListElement(ce, false, isPackageMissing, false);
            ++i;
        }
        return packageElements;
    }

    public IJavaProject getJavaProject() {
        return this.fCurrJProject;
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fSearchOrder) {
            this.updateSearchPathStatus();
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        this.fContext.statusChanged((IStatus)this.fSearchStatus);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSearchPathStatus() {
        if (this.inUpdate) {
            return;
        }
        try {
            this.inUpdate = true;
            this.fSearchStatus.setOK();
            List elements = this.fSearchOrder.getElements();
            boolean entryMissing = false;
            ArrayList<BPListElement> exported = new ArrayList<BPListElement>();
            Iterator entries = elements.iterator();
            while (true) {
                block10: {
                    if (entries.hasNext()) break block10;
                    this.fSearchOrder.setCheckedElements(exported);
                    if (entryMissing) {
                        this.fSearchStatus.setWarning(BeanInfoUIMessages.BeaninfoPathsBlock_UI__warning_EntryMissing);
                    }
                    break;
                }
                BPListElement currElement = (BPListElement)entries.next();
                boolean isChecked = this.fSearchOrder.isChecked((Object)currElement);
                if (currElement.canExportBeChanged()) {
                    if (isChecked) {
                        exported.add(currElement);
                    }
                    currElement.setExported(isChecked);
                } else if (currElement.isExported()) {
                    exported.add(currElement);
                }
                entryMissing = entryMissing || currElement.isMissing();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.inUpdate = false;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.inUpdate = false;
            return;
        }
    }

    public IRunnableWithProgress getRunnable() {
        final boolean wantNature = this.fEnableBeaninfoDialogField.isSelected();
        final List searchPathEntries = wantNature ? this.fSearchOrder.getElements() : null;
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_operationdescription, 10);
                try {
                    try {
                        BeaninfoPathsBlock.this.setBeaninfoSearchpath(wantNature, searchPathEntries, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
    }

    private void setBeaninfoSearchpath(boolean wantNature, List searchPathEntries, IProgressMonitor monitor) throws CoreException {
        if (wantNature) {
            if (!this.fCurrJProject.getProject().hasNature("org.eclipse.jem.beaninfo.BeanInfoNature")) {
                this.addNatureIDToProject(this.fCurrJProject.getProject(), "org.eclipse.jem.beaninfo.BeanInfoNature", monitor);
            }
            BeaninfoNature nature = BeaninfoNature.getRuntime((IProject)this.fCurrJProject.getProject());
            if (searchPathEntries.size() > 0) {
                IBeaninfosDocEntry[] sparray = new IBeaninfosDocEntry[searchPathEntries.size()];
                Iterator itr = searchPathEntries.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    BPListElement elem = (BPListElement)itr.next();
                    sparray[i++] = elem.getEntry();
                }
                nature.setSearchPath(new BeaninfosDoc(sparray), monitor);
            } else {
                nature.setSearchPath(null, monitor);
            }
        } else {
            this.removeNatureIDFromProject(this.fCurrJProject.getProject(), "org.eclipse.jem.beaninfo.BeanInfoNature", monitor);
        }
    }

    private void addNatureIDToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private void removeNatureIDFromProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        int indx = -1;
        int i = 0;
        while (i < prevNatures.length) {
            if (prevNatures[i].equals(natureId)) {
                indx = i;
                break;
            }
            ++i;
        }
        if (indx == -1) {
            return;
        }
        String[] newNatures = new String[prevNatures.length - 1];
        if (newNatures.length != 0) {
            System.arraycopy(prevNatures, 0, newNatures, 0, indx);
            if (indx < newNatures.length) {
                System.arraycopy(prevNatures, indx + 1, newNatures, indx, newNatures.length - indx);
            }
        }
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            BuildSearchBasePage newPage = (BuildSearchBasePage)((TabItem)widget).getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection);
            }
            this.fCurrPage = newPage;
        }
    }

    private class BuildPathAdapter
    implements IDialogFieldListener {
        BuildPathAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            BeaninfoPathsBlock.this.buildPathDialogFieldChanged(field);
        }
    }
}

