/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.vm.remote;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.UnexpectedExceptionCommandException;
import org.eclipse.jem.internal.proxy.vm.remote.ConnectionHandler;
import org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread;

class CallbackHandler
extends ConnectionHandler
implements ICallbackHandler {
    private static final Object[] NULL_SENT = new Object[1];

    public CallbackHandler(Socket sc, RemoteVMServerThread svr) {
        super(sc, svr, null);
    }

    public void initiateCallbackStream(int callbackID, int msgID) throws CommandException {
        try {
            Commands.sendCallbackStreamCommand((DataOutputStream)this.out, (int)callbackID, (int)msgID);
            this.out.flush();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, (Throwable)e);
        }
        this.run();
    }

    public void writeBytes(byte[] bytes, int bytesToWrite) throws CommandException {
        try {
            if (bytesToWrite != -1) {
                Commands.writeBytes((DataOutputStream)this.out, (byte[])bytes, (int)bytesToWrite);
            } else {
                this.out.writeInt(-1);
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, (Throwable)e);
        }
    }

    public Object callbackAsConstants(int callbackID, int msgID, Object parm) throws CommandException {
        try {
            Commands.sendCallbackCommand((DataOutputStream)this.out, (int)callbackID, (int)msgID);
            Commands.ValueObject v = new Commands.ValueObject();
            this.sendObject(parm, -2, v, this.out, false);
            this.out.flush();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, (Throwable)e);
        }
        return this.run();
    }

    public Object callbackWithParms(int callbackID, int msgID, Object[] parms) throws CommandException {
        try {
            if (parms == null) {
                parms = NULL_SENT;
            }
            Commands.ValueObject v = new Commands.ValueObject();
            v.setArrayIDS((Commands.ValueRetrieve)new Retriever(parms), parms.length, 23);
            Commands.sendCallbackCommand((DataOutputStream)this.out, (int)callbackID, (int)msgID);
            Commands.writeValue((DataOutputStream)this.out, (Commands.ValueObject)v, (boolean)false);
            this.out.flush();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, (Throwable)e);
        }
        return this.run();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeHandler() {
        block16: {
            if (!this.isConnected()) return;
            try {
                try {
                    Commands.sendQuitCommand((DataOutputStream)this.out);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (Exception exception) {}
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (Exception exception) {}
                }
                this.close();
                this.in = null;
                this.out = null;
                this.socket = null;
                throw throwable;
            }
            {
                Object var1_3 = null;
                if (this.in == null) break block16;
            }
            try {}
            catch (Exception exception) {}
            this.in.close();
        }
        if (this.out != null) {
            try {}
            catch (Exception exception) {}
            this.out.close();
        }
        this.close();
        this.in = null;
        this.out = null;
        this.socket = null;
    }

    private class Retriever
    implements Commands.ValueRetrieve {
        int index = 0;
        Object[] array;
        Commands.ValueObject worker = new Commands.ValueObject();

        public Retriever(Object[] anArray) {
            this.array = anArray;
        }

        public Commands.ValueObject nextValue() {
            if (this.index < this.array.length) {
                Object parm;
                if ((parm = this.array[this.index++]) != null) {
                    if (parm instanceof ICallbackHandler.TransmitableArray) {
                        this.worker.setArrayIDS((Commands.ValueRetrieve)new Retriever(((ICallbackHandler.TransmitableArray)parm).getArray()), ((ICallbackHandler.TransmitableArray)parm).getArray().length, 23);
                    } else {
                        CallbackHandler.this.fillInValue(parm, -1, this.worker);
                    }
                } else {
                    this.worker.set();
                }
                return this.worker;
            }
            return null;
        }
    }
}

