/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.REMDoubleTypeBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMPrimitiveBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMDoubleTypeBeanTypeProxy
extends REMPrimitiveBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;

    REMDoubleTypeBeanTypeProxy(REMProxyFactoryRegistry aRegistry) {
        super(aRegistry, new Integer(9), Double.TYPE.getName());
        this.zeroProxy = new REMDoubleTypeBeanProxy(aRegistry, 0.0);
    }

    INumberBeanProxy createDoubleBeanProxy(double aDouble) {
        return aDouble != 0.0 ? new REMDoubleTypeBeanProxy(this.fRegistry, aDouble) : this.zeroProxy;
    }

    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createDoubleBeanProxy(value.aDouble);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBeanProxy newInstance(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        double aDouble;
        String trim = initializationString.trim();
        if (trim.length() == 0) {
            return super.newInstance(initializationString);
        }
        if (trim.startsWith("(double)")) {
            Number v = REMPrimitiveBeanTypeProxy.parseString(trim.substring("(double)".length()).trim());
            if (v == null) return super.newInstance(initializationString);
            aDouble = v.doubleValue();
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aDouble);
        }
        try {
            aDouble = Double.valueOf(initializationString);
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aDouble);
        }
        catch (NumberFormatException numberFormatException) {
            return super.newInstance(initializationString);
        }
    }
}

