/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.IExpressionConstants;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMExpressionConnection;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

public class REMExpression
extends Expression {
    protected IREMExpressionConnection connection;
    protected Commands.ValueObject workerValue = new Commands.ValueObject();
    protected static final String IO_EXCEPTION_MSG = ProxyRemoteMessages.getString("REMExpression.IOExceptionSeeLog_INFO_");
    protected static final String COMMAND_EXCEPTION_MSG = ProxyRemoteMessages.getString("REMExpression.CommandExceptionSeeLog_INFO_");

    public REMExpression(REMProxyFactoryRegistry registry) {
        super((ProxyFactoryRegistry)registry);
        this.connection = (IREMExpressionConnection)registry.getFreeConnection();
        try {
            this.connection.startExpressionProcessing(((Object)((Object)this)).hashCode());
        }
        catch (IOException e) {
            this.connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void throwIllegalStateException(String msg) throws IllegalStateException {
        throw new IllegalStateException(msg);
    }

    protected final REMProxyFactoryRegistry getREMRegistry() {
        return (REMProxyFactoryRegistry)this.registry;
    }

    protected final REMStandardBeanProxyFactory getREMBeanProxyFactory() {
        return (REMStandardBeanProxyFactory)this.beanProxyFactory;
    }

    protected void pushToProxy(IBeanProxy proxy) throws ThrowableProxy {
        block5: {
            try {
                this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)12);
                if (proxy == null) {
                    this.workerValue.set();
                } else {
                    ((IREMBeanProxy)proxy).renderBean(this.workerValue);
                }
                this.connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeProxy() {
        try {
            try {
                this.connection.stopExpressionProcessing(((Object)((Object)this)).hashCode());
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.INFO);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getREMRegistry().returnConnection(this.connection);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.getREMRegistry().returnConnection(this.connection);
            return;
        }
    }

    protected IBeanProxy pullProxyValue() throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        block7: {
            try {
                this.connection.pullValue(((Object)((Object)this)).hashCode(), this.workerValue);
                return this.getREMBeanProxyFactory().getBeanProxy(this.workerValue);
            }
            catch (CommandErrorException e) {
                if (e.getErrorCode() == 9) {
                    throw new IExpressionConstants.NoExpressionValueException((String)e.getErrorObject());
                }
                try {
                    this.getREMBeanProxyFactory().processErrorReturn(e);
                }
                catch (CommandException commandException) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                    if (!e.isRecoverable()) {
                        this.connection.close();
                        this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
                    }
                }
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                if (e.isRecoverable()) break block7;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
        return null;
    }

    protected void pushCastToProxy(Object type) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        block5: {
            try {
                this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)4);
                if (type instanceof String) {
                    this.workerValue.set((String)type);
                } else {
                    ((IREMBeanProxy)type).renderBean(this.workerValue);
                }
                this.connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushInstanceofToProxy(Object type) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        block5: {
            try {
                this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)8);
                if (type instanceof String) {
                    this.workerValue.set((String)type);
                } else {
                    ((IREMBeanProxy)type).renderBean(this.workerValue);
                }
                this.connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushInfixToProxy(int operator, int operandType) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)9);
            this.connection.pushByte((byte)operator);
            this.connection.pushByte((byte)operandType);
        }
        catch (IOException e) {
            this.connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushPrefixToProxy(int operator) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)11);
            this.connection.pushByte((byte)operator);
        }
        catch (IOException e) {
            this.connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushTypeLiteralToProxy(String type) throws ThrowableProxy {
        block3: {
            try {
                this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)13);
                this.workerValue.set(type);
                this.connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushArrayAccessToProxy(int indexCount) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)1);
            this.connection.pushInt(indexCount);
        }
        catch (IOException e) {
            this.connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushArrayCreationToProxy(Object type, int dimensionCount) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        block5: {
            try {
                this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)2);
                if (type instanceof String) {
                    this.workerValue.set((String)type);
                } else {
                    ((IREMBeanProxy)type).renderBean(this.workerValue);
                }
                this.connection.pushValueObject(this.workerValue);
                this.connection.pushInt(dimensionCount);
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushArrayInitializerToProxy(Object type, int expressionCount) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        block5: {
            try {
                this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)3);
                if (type instanceof String) {
                    this.workerValue.set((String)type);
                } else {
                    ((IREMBeanProxy)type).renderBean(this.workerValue);
                }
                this.connection.pushValueObject(this.workerValue);
                this.connection.pushInt(expressionCount);
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushClassInstanceCreationToProxy(Object type, int argumentCount) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        block5: {
            try {
                this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)6);
                if (type instanceof String) {
                    this.workerValue.set((String)type);
                } else {
                    ((IREMBeanProxy)type).renderBean(this.workerValue);
                }
                this.connection.pushValueObject(this.workerValue);
                this.connection.pushInt(argumentCount);
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushTypeReceiverToProxy(Object type) throws ThrowableProxy {
        block5: {
            try {
                this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)14);
                if (type instanceof String) {
                    this.workerValue.set((String)type);
                } else {
                    ((IREMBeanProxy)type).renderBean(this.workerValue);
                }
                this.connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushFieldAccessToProxy(String fieldName, boolean hasReceiver) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)7);
            this.connection.pushString(fieldName);
            this.connection.pushBoolean(hasReceiver);
        }
        catch (IOException e) {
            this.connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushMethodInvocationToProxy(String methodName, boolean hasReceiver, int argCount) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)10);
            this.connection.pushString(methodName);
            this.connection.pushBoolean(hasReceiver);
            this.connection.pushInt(argCount);
        }
        catch (IOException e) {
            this.connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushConditionalToProxy(int expressionType) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.connection.pushExpressionCommand(((Object)((Object)this)).hashCode(), (byte)5);
            this.connection.pushByte((byte)expressionType);
        }
        catch (IOException e) {
            this.connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushInvoke() throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        block7: {
            try {
                this.connection.sync(((Object)((Object)this)).hashCode(), this.workerValue);
                this.getREMBeanProxyFactory().getBeanProxy(this.workerValue);
            }
            catch (CommandErrorException e) {
                if (e.getErrorCode() == 9) {
                    throw new IExpressionConstants.NoExpressionValueException((String)e.getErrorObject());
                }
                try {
                    this.getREMBeanProxyFactory().processErrorReturn(e);
                }
                catch (CommandException commandException) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                    if (!e.isRecoverable()) {
                        this.connection.close();
                        this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
                    }
                }
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                if (e.isRecoverable()) break block7;
                this.connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }
}

