/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.REMLongTypeBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMPrimitiveBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMLongTypeBeanTypeProxy
extends REMPrimitiveBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;
    private final INumberBeanProxy oneProxy;
    private final INumberBeanProxy twoProxy;
    private final INumberBeanProxy threeProxy;

    REMLongTypeBeanTypeProxy(REMProxyFactoryRegistry aRegistry) {
        super(aRegistry, new Integer(15), Long.TYPE.getName());
        this.zeroProxy = new REMLongTypeBeanProxy(aRegistry, 0L);
        this.oneProxy = new REMLongTypeBeanProxy(aRegistry, 1L);
        this.twoProxy = new REMLongTypeBeanProxy(aRegistry, 2L);
        this.threeProxy = new REMLongTypeBeanProxy(aRegistry, 3L);
    }

    INumberBeanProxy createLongBeanProxy(long aLong) {
        if (aLong >= 0L && aLong < 4L) {
            switch ((int)aLong) {
                case 0: {
                    return this.zeroProxy;
                }
                case 1: {
                    return this.oneProxy;
                }
                case 2: {
                    return this.twoProxy;
                }
                case 3: {
                    return this.threeProxy;
                }
            }
        }
        return new REMLongTypeBeanProxy(this.fRegistry, aLong);
    }

    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createLongBeanProxy(value.aLong);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBeanProxy newInstance(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        long aLong;
        String trim = initializationString.trim();
        if (trim.length() == 0) {
            return super.newInstance(initializationString);
        }
        if (trim.startsWith("(long)")) {
            Number v = REMPrimitiveBeanTypeProxy.parseString(trim.substring("(long)".length()).trim());
            if (v == null) return super.newInstance(initializationString);
            aLong = v.longValue();
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aLong);
        }
        if (trim.charAt(trim.length() - 1) == 'L' || trim.charAt(trim.length() - 1) == 'l') {
            trim = trim.substring(0, trim.length() - 1);
        }
        try {
            aLong = Long.decode(trim);
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aLong);
        }
        catch (NumberFormatException numberFormatException) {
            return super.newInstance(initializationString);
        }
    }
}

