/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.workbench.utility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class JemProjectUtilities {
    public static JavaClass getJavaClass(IFile aFile) {
        if (aFile == null) {
            return null;
        }
        IProject project = aFile.getProject();
        List folders = JemProjectUtilities.getSourceContainers(project);
        folders.addAll(JemProjectUtilities.getLibraryContainers(project));
        IContainer folder = null;
        IPath filePath = aFile.getProjectRelativePath();
        if (folders != null) {
            int i = 0;
            while (i < folders.size()) {
                folder = (IContainer)folders.get(i);
                IPath folderPath = folder.getProjectRelativePath();
                int segments = filePath.matchingFirstSegments(folderPath);
                if (segments > 0) {
                    IPath javaPath = filePath.removeFirstSegments(segments);
                    javaPath = javaPath.removeFileExtension();
                    String qualifiedName = javaPath.toString().replace('/', '.');
                    return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(qualifiedName, WorkbenchResourceHelperBase.getResourceSet((IProject)project));
                }
                ++i;
            }
        }
        return null;
    }

    public static List getSourceContainers(IProject p) {
        try {
            ArrayList<Object> sourceContainers = new ArrayList<Object>();
            List sourcePaths = JemProjectUtilities.getSourcePaths(p);
            if (sourcePaths != null && !sourcePaths.isEmpty()) {
                int i = 0;
                while (i < sourcePaths.size()) {
                    IPath path = (IPath)sourcePaths.get(i);
                    if (path.isEmpty()) {
                        sourceContainers.add(p);
                    } else {
                        sourceContainers.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return sourceContainers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    protected static List getSourcePaths(IProject p) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError((Throwable)ex);
            return null;
        }
        ArrayList<IPath> sourcePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3) {
                sourcePaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return sourcePaths;
    }

    public static List getLibraryContainers(IProject p) {
        try {
            ArrayList<Object> libraryContainers = new ArrayList<Object>();
            List libraryPaths = JemProjectUtilities.getlibraryPaths(p);
            if (libraryPaths != null && !libraryPaths.isEmpty()) {
                int i = 0;
                while (i < libraryPaths.size()) {
                    IPath path = (IPath)libraryPaths.get(i);
                    if (path.isEmpty()) {
                        libraryContainers.add(p);
                    } else {
                        libraryContainers.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return libraryContainers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    protected static List getlibraryPaths(IProject p) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError((Throwable)ex);
            return null;
        }
        ArrayList<IPath> libraryPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 1) {
                libraryPaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return libraryPaths;
    }

    public static IJavaProject getJavaProject(IProject p) {
        try {
            return (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

