/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.internal.java.adapters.IJavaReflectionKeyExtension;
import org.eclipse.jem.internal.java.adapters.JavaReflectionKey;
import org.eclipse.jem.java.JavaClass;

public class BeaninfoJavaReflectionKeyExtension
implements IJavaReflectionKeyExtension {
    public static final String BEHAVIOR = "/operation/";
    public static final String EVENT = "/event/";
    public static final String FEATURE = "/";

    public Object getObject(String key, JavaReflectionKey reflectionKey) {
        if (key != null) {
            int ibehave = key.indexOf(BEHAVIOR);
            if (ibehave > -1) {
                JavaClass javaclass;
                String classname = key.substring(0, ibehave);
                int ibehaveName = ibehave + BEHAVIOR.length();
                if (ibehaveName < key.length() && (javaclass = this.getJavaClass(reflectionKey, classname)) != null) {
                    javaclass.getEOperations();
                    return reflectionKey.primGet(key);
                }
            } else {
                int ievent = key.indexOf(EVENT);
                if (ievent > -1) {
                    JavaClass javaclass;
                    String classname = key.substring(0, ievent);
                    int ieventName = ievent + EVENT.length();
                    if (ieventName < key.length() && (javaclass = this.getJavaClass(reflectionKey, classname)) != null) {
                        javaclass.getEvents();
                        return reflectionKey.primGet(key);
                    }
                } else {
                    int ifeature = key.indexOf(FEATURE);
                    if (ifeature > -1) {
                        String classname = key.substring(0, ifeature);
                        int ifeatureName = ifeature + FEATURE.length();
                        if (ifeatureName < key.length()) {
                            String feature = key.substring(ifeatureName);
                            JavaClass javaclass = this.getJavaClass(reflectionKey, classname);
                            if (javaclass != null) {
                                javaclass.getEStructuralFeatures();
                                Object result = reflectionKey.primGet(key);
                                if (result == null) {
                                    result = this.findFeature(feature, (List)javaclass.getEReferences());
                                    if (result == null) {
                                        result = this.findFeature(feature, (List)javaclass.getEAttributes());
                                    }
                                    if (result instanceof EStructuralFeature) {
                                        ((XMIResource)javaclass.eResource()).setID((EObject)result, key);
                                    }
                                }
                                return result;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private EStructuralFeature findFeature(String featureName, List featureList) {
        Iterator itr = featureList.iterator();
        while (itr.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)itr.next();
            if (!featureName.equals(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    protected JavaClass getJavaClass(JavaReflectionKey reflectionKey, String classname) {
        Object eclass = reflectionKey.primGet(classname);
        if (eclass == null) {
            eclass = reflectionKey.getJavaType(classname);
        }
        if (eclass instanceof JavaClass) {
            return (JavaClass)eclass;
        }
        return null;
    }
}

