/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangePackage;
import org.eclipse.emf.ecore.change.impl.EObjectToChangesMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoClassAdapter;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.logger.proxy.Logger;

public class BeanInfoCacheController {
    public static final BeanInfoCacheController INSTANCE = new BeanInfoCacheController();
    protected SaveParticipant saveParticipant;
    private static Index MAIN_INDEX;
    private static Map PROJECT_INDEXES;
    private static final String CLASS_CACHE_SUFFIX = ".xmi";
    private static final String OVERRIDE_CACHE_SUFFIX = ".override.xmi";
    public static final int REFLECTION_CACHE = 1;
    public static final int REFLECTION_OPERATIONS_CACHE = 2;
    public static final int OVERRIDES_CACHE = 3;
    protected static final ChangePackage CP;
    private static final String ROOT_PREFIX = "root";
    private static final String INDEXFILENAME = ".index";
    private static final String CACHEDIR = ".cache";
    private List cacheWriteQueue = null;
    static final Map SAVE_CACHE_OPTIONS;
    protected Job cacheWriteJob = null;
    protected Adapter projectReleaseAdapter = new AdapterImpl(){

        public boolean isAdapterForType(Object type) {
            return type == BeanInfoCacheController.this;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 14) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jem.internal.beaninfo.core.BeanInfoCacheController");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (msg.getFeatureID((Class)clazz) == 1000) {
                    BeanInfoCacheController.this.waitForCacheSaveJob();
                }
            }
        }
    };
    static /* synthetic */ Class class$0;

    static {
        PROJECT_INDEXES = new HashMap();
        CP = ChangePackage.eINSTANCE;
        SAVE_CACHE_OPTIONS = new HashMap(2);
        SAVE_CACHE_OPTIONS.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
    }

    private BeanInfoCacheController() {
        this.saveParticipant = new SaveParticipant();
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)BeaninfoPlugin.getPlugin(), (ISaveParticipant)this.saveParticipant);
        }
        catch (CoreException e) {
            BeaninfoPlugin.getPlugin().getLogger().log((Object)e.getStatus());
        }
    }

    public ClassEntry getClassEntry(JavaClass jclass) {
        IType type = (IType)jclass.getReflectionType();
        RootIndex rootIndex = this.getRootIndex(type);
        String className = jclass.getQualifiedNameForReflection();
        return this.getClassEntry(rootIndex, className, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassEntry newCache(JavaClass jclass, Object cache, int cacheType) {
        String type;
        if (BeaninfoPlugin.getPlugin().getLogger().isLoggingLevel(Level.FINER)) {
            Logger logger = BeaninfoPlugin.getPlugin().getLogger();
            String string = type = cacheType != 3 ? "Class" : "Overrides";
            if (cacheType == 3 && cache == null) {
                type = String.valueOf(type) + "  empty";
            }
            logger.log((Object)("Creating cache for class " + jclass.getQualifiedNameForReflection() + " cache type=" + type), Level.FINER);
        }
        ChangeDescription cd = null;
        if (cacheType != 3) {
            cd = (ChangeDescription)cache;
            Iterator iter = cd.getObjectChanges().iterator();
            while (iter.hasNext()) {
                EObjectToChangesMapEntryImpl fcEntry = (EObjectToChangesMapEntryImpl)iter.next();
                if (!((List)fcEntry.getValue()).isEmpty()) continue;
                iter.remove();
            }
        }
        type = (IType)jclass.getReflectionType();
        RootIndex rootIndex = this.getRootIndex((IType)type);
        String className = jclass.getQualifiedNameForReflection();
        ClassEntry ce = this.getClassEntry(rootIndex, className, true);
        ResourceSet cacheRset = null;
        ClassEntry classEntry = ce;
        synchronized (classEntry) {
            if (cacheType != 3) {
                Resource cres = ce.getPendingResource();
                if (cres != null) {
                    cres.getContents().clear();
                } else {
                    cres = jclass.eResource().getResourceSet().createResource(URI.createFileURI((String)rootIndex.getCachePath().append(String.valueOf(className) + CLASS_CACHE_SUFFIX).toString()));
                }
                cacheRset = cres.getResourceSet();
                ce.setOperationsStored(cacheType == 2);
                ce.setPendingResource(cres);
                cres.getContents().add((Object)cd);
                if (rootIndex.isArchiveRoot()) {
                    ce.setModificationStamp(((ArchiveRootIndex)rootIndex).getArchiveModificationStamp());
                } else {
                    try {
                        ce.setModificationStamp(type.getUnderlyingResource().getModificationStamp());
                    }
                    catch (JavaModelException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                        ce.markDeleted();
                        return null;
                    }
                }
                EList supers = jclass.getESuperTypes();
                if (!supers.isEmpty()) {
                    BeaninfoClassAdapter bca = BeaninfoClassAdapter.getBeaninfoClassAdapter((EObject)supers.get(0));
                    ce.setSuperModificationStamp(bca.getClassEntry().getModificationStamp());
                    if (supers.size() == 1) {
                        ce.setInterfaceNames(null);
                        ce.setInterfaceModificationStamps(null);
                    } else {
                        String[] interNames = new String[supers.size() - 1];
                        long[] interMods = new long[interNames.length];
                        int i = 1;
                        int indx = 0;
                        while (i < interNames.length) {
                            JavaClass javaClass = (JavaClass)supers.get(i);
                            bca = BeaninfoClassAdapter.getBeaninfoClassAdapter((EObject)javaClass);
                            bca.introspectIfNecessary();
                            interNames[indx] = javaClass.getQualifiedNameForReflection();
                            interMods[indx] = bca.getClassEntry().getModificationStamp();
                            ++i;
                            ++indx;
                        }
                        ce.setInterfaceNames(interNames);
                        ce.setInterfaceModificationStamps(interMods);
                    }
                } else {
                    ce.setSuperModificationStamp(-1L);
                    ce.setInterfaceNames(null);
                    ce.setInterfaceModificationStamps(null);
                }
            } else {
                if (cache != null) {
                    Resource cres = ce.getPendingOverrideResource();
                    if (cres != null) {
                        cres.getContents().clear();
                    } else {
                        cres = jclass.eResource().getResourceSet().createResource(URI.createFileURI((String)rootIndex.getCachePath().append(String.valueOf(className) + OVERRIDE_CACHE_SUFFIX).toString()));
                    }
                    cacheRset = cres.getResourceSet();
                    cres.getContents().addAll((Collection)((List)cache));
                    ce.setPendingOverrideResource(cres);
                    ce.setOverrideCacheExists(true);
                } else {
                    ce.setPendingOverrideResource(null);
                    ce.setOverrideCacheExists(false);
                }
                ce.setConfigurationModificationStamp(Platform.getPlatformAdmin().getState(false).getTimeStamp());
            }
        }
        this.queueClassEntry(ce, cacheRset);
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getCache(JavaClass jclass, ClassEntry ce, boolean reflectCache) {
        Object type;
        String className = jclass.getQualifiedNameForReflection();
        if (BeaninfoPlugin.getPlugin().getLogger().isLoggingLevel(Level.FINER)) {
            Logger logger = BeaninfoPlugin.getPlugin().getLogger();
            type = reflectCache ? "Class" : "Overrides";
            logger.log((Object)("Loading cache for class " + className + " cache type=" + (String)type), Level.FINER);
        }
        if (reflectCache) {
            boolean waitForJob = false;
            type = ce;
            synchronized (type) {
                if (ce.getPendingResource() != null) {
                    waitForJob = true;
                    if (BeaninfoPlugin.getPlugin().getLogger().isLoggingLevel(Level.FINER)) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Object)"Using pending class cache.", Level.FINER);
                    }
                }
            }
            if (waitForJob) {
                this.waitForCacheSaveJob();
            }
            try {
                return jclass.eResource().getResourceSet().getResource(URI.createFileURI((String)ce.getRootIndex().getCachePath().append(String.valueOf(className) + CLASS_CACHE_SUFFIX).toString()), true);
            }
            catch (Exception e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.INFO);
                return null;
            }
        }
        boolean waitForJob = false;
        ClassEntry e = ce;
        synchronized (e) {
            if (ce.getPendingResource() != null) {
                waitForJob = true;
                if (BeaninfoPlugin.getPlugin().getLogger().isLoggingLevel(Level.FINER)) {
                    BeaninfoPlugin.getPlugin().getLogger().log((Object)"Using pending override cache.", Level.FINER);
                }
            }
        }
        if (waitForJob) {
            this.waitForCacheSaveJob();
        }
        try {
            return jclass.eResource().getResourceSet().getResource(URI.createFileURI((String)ce.getRootIndex().getCachePath().append(String.valueOf(className) + OVERRIDE_CACHE_SUFFIX).toString()), true);
        }
        catch (Exception e2) {
            BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e2, Level.INFO);
            return null;
        }
    }

    private synchronized ClassEntry getClassEntry(RootIndex rootIndex, String className, boolean createEntry) {
        ClassEntry ce = (ClassEntry)rootIndex.classNameToClassEntry.get(className);
        if (createEntry && ce == null) {
            ce = new ClassEntry(rootIndex, className);
        }
        return ce;
    }

    private RootIndex getRootIndex(IType type) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getAncestor(3);
        if (!root.isExternal()) {
            return this.getRootIndex(root, root.getJavaProject().getProject());
        }
        return this.getRootIndex(root, null);
    }

    private synchronized RootIndex getRootIndex(IPackageFragmentRoot root, IProject project) {
        Index index = project != null ? this.getProjectIndex(project) : this.getMainIndex();
        IPath rootPath = root.getPath();
        RootIndex rootIndex = (RootIndex)index.rootToRootIndex.get(rootPath);
        if (rootIndex == null) {
            String rootName = ROOT_PREFIX + ++index.highRootNumber;
            rootIndex = root.isArchive() ? this.createArchiveRootIndex(root, rootName, index) : new FolderRootIndex(rootName, index);
            index.rootToRootIndex.put(rootPath, rootIndex);
        }
        rootIndex.setupIndex(project);
        return rootIndex;
    }

    private RootIndex createArchiveRootIndex(IPackageFragmentRoot rootArchive, String rootName, Index index) {
        long modStamp = -1L;
        if (rootArchive.isExternal()) {
            modStamp = rootArchive.getPath().toFile().lastModified();
        } else {
            try {
                modStamp = rootArchive.getUnderlyingResource().getModificationStamp();
            }
            catch (JavaModelException e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
            }
        }
        return new ArchiveRootIndex(rootName, modStamp, index);
    }

    public static IPath getCacheDir(IProject project) {
        if (project != null) {
            return project.getWorkingLocation(BeaninfoPlugin.getPlugin().getBundle().getSymbolicName()).append(CACHEDIR);
        }
        return BeaninfoPlugin.getPlugin().getStateLocation().append(CACHEDIR);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Index getProjectIndex(IProject project) {
        block11: {
            index = (Index)BeanInfoCacheController.PROJECT_INDEXES.get(project);
            if (index != null) return index;
            indexDirFile = BeanInfoCacheController.getCacheDir(project).append(".index").toFile();
            if (indexDirFile.canRead()) {
                ois = null;
                try {
                    try {
                        ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(indexDirFile)));
                        index = (Index)ois.readObject();
                    }
                    catch (IOException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                    }
                }
                catch (Throwable var7_7) {
                    var6_8 = null;
                    if (ois == null) throw var7_7;
                    try {
                        ois.close();
                        throw var7_7;
                    }
                    catch (IOException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                    }
                    throw var7_7;
                }
                {
                    var6_9 = null;
                    if (ois == null) break block11;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 129->137)] { 
lbl33:
                // 1 sources

                ois.close();
                break block11;
lbl35:
                // 1 sources

                catch (IOException e) {
                    BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                }
            }
        }
        if (index == null) {
            index = new Index();
            index.highRootNumber = 0;
            index.rootToRootIndex = new HashMap<K, V>();
        }
        BeanInfoCacheController.PROJECT_INDEXES.put(project, index);
        return index;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Index getMainIndex() {
        block10: {
            if (BeanInfoCacheController.MAIN_INDEX != null) return BeanInfoCacheController.MAIN_INDEX;
            indexDirFile = BeanInfoCacheController.getCacheDir(null).append(".index").toFile();
            if (indexDirFile.canRead()) {
                ois = null;
                try {
                    try {
                        ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(indexDirFile)));
                        BeanInfoCacheController.MAIN_INDEX = (Index)ois.readObject();
                    }
                    catch (IOException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                    }
                }
                catch (Throwable var5_5) {
                    var4_6 = null;
                    if (ois == null) throw var5_5;
                    try {
                        ois.close();
                        throw var5_5;
                    }
                    catch (IOException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                    }
                    throw var5_5;
                }
                {
                    var4_7 = null;
                    if (ois == null) break block10;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 112->119)] { 
lbl32:
                // 1 sources

                ois.close();
                break block10;
lbl34:
                // 1 sources

                catch (IOException e) {
                    BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                }
            }
        }
        if (BeanInfoCacheController.MAIN_INDEX != null) return BeanInfoCacheController.MAIN_INDEX;
        BeanInfoCacheController.MAIN_INDEX = new Index();
        BeanInfoCacheController.MAIN_INDEX.highRootNumber = 0;
        BeanInfoCacheController.MAIN_INDEX.rootToRootIndex = new HashMap<K, V>();
        return BeanInfoCacheController.MAIN_INDEX;
    }

    void waitForCacheSaveJob() {
        if (this.cacheWriteJob != null) {
            if (BeaninfoPlugin.getPlugin().getLogger().isLoggingLevel(Level.FINER)) {
                BeaninfoPlugin.getPlugin().getLogger().log((Object)"Forcing a cache save job to start early.", Level.FINER);
            }
            switch (this.cacheWriteJob.getState()) {
                case 1: {
                    this.cacheWriteJob.setPriority(10);
                    this.cacheWriteJob.wakeUp();
                }
            }
            try {
                this.cacheWriteJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void queueClassEntry(ClassEntry ce, ResourceSet rset) {
        if (this.cacheWriteQueue == null) {
            this.cacheWriteQueue = Collections.synchronizedList(new LinkedList());
            this.cacheWriteJob = new Job("Write BeanInfo cache files"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("", BeanInfoCacheController.this.cacheWriteQueue.size() + 10);
                    if (BeaninfoPlugin.getPlugin().getLogger().isLoggingLevel(Level.FINER)) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Object)"Starting write BeanInfo Cache files.", Level.FINER);
                    }
                    while (true) {
                        ClassEntry ce;
                        if (monitor.isCanceled() || BeanInfoCacheController.this.cacheWriteQueue.isEmpty()) {
                            monitor.done();
                            if (BeaninfoPlugin.getPlugin().getLogger().isLoggingLevel(Level.FINER)) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Object)"Finished write BeanInfo Cache files.", Level.FINER);
                            }
                            return Status.OK_STATUS;
                        }
                        ClassEntry classEntry = ce = (ClassEntry)BeanInfoCacheController.this.cacheWriteQueue.remove(0);
                        synchronized (classEntry) {
                            Object var6_8;
                            Resource cres = ce.getPendingResource();
                            if (cres != null) {
                                try {
                                    try {
                                        cres.save(SAVE_CACHE_OPTIONS);
                                    }
                                    catch (IOException e) {
                                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    var6_8 = null;
                                    cres.getResourceSet().getResources().remove((Object)cres);
                                    ce.setPendingResource(null);
                                    throw throwable;
                                }
                                {
                                    var6_8 = null;
                                }
                                cres.getResourceSet().getResources().remove((Object)cres);
                                ce.setPendingResource(null);
                            }
                            if ((cres = ce.getPendingOverrideResource()) != null) {
                                try {
                                    try {
                                        cres.save(SAVE_CACHE_OPTIONS);
                                    }
                                    catch (IOException e) {
                                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    var6_8 = null;
                                    cres.getResourceSet().getResources().remove((Object)cres);
                                    ce.setPendingOverrideResource(null);
                                    throw throwable;
                                }
                                {
                                    var6_8 = null;
                                }
                                cres.getResourceSet().getResources().remove((Object)cres);
                                ce.setPendingOverrideResource(null);
                            }
                            monitor.worked(1);
                        }
                    }
                }
            };
            this.cacheWriteJob.setPriority(20);
            this.cacheWriteJob.setSystem(true);
        }
        if (rset != null && EcoreUtil.getExistingAdapter((Notifier)rset, (Object)this) == null && rset instanceof ProjectResourceSet) {
            rset.eAdapters().add((Object)this.projectReleaseAdapter);
        }
        this.cacheWriteQueue.add(ce);
        this.cacheWriteJob.schedule(60000L);
    }

    protected static class Index
    implements Serializable {
        private static final long serialVersionUID = 1106864425465L;
        private transient boolean dirty;
        public int highRootNumber;
        public transient Map rootToRootIndex;

        protected Index() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDirty(boolean dirty) {
            BeanInfoCacheController beanInfoCacheController = INSTANCE;
            synchronized (beanInfoCacheController) {
                this.dirty = dirty;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDirty() {
            BeanInfoCacheController beanInfoCacheController = INSTANCE;
            synchronized (beanInfoCacheController) {
                return this.dirty;
            }
        }

        private void writeObject(ObjectOutputStream os) throws IOException {
            os.defaultWriteObject();
            os.writeInt(this.rootToRootIndex.size());
            Iterator mapItr = this.rootToRootIndex.entrySet().iterator();
            while (mapItr.hasNext()) {
                Map.Entry entry = mapItr.next();
                os.writeUTF(((IPath)entry.getKey()).toString());
                os.writeObject(entry.getValue());
            }
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.defaultReadObject();
            int size = is.readInt();
            this.rootToRootIndex = new HashMap(size < 100 ? 100 : size);
            while (size-- > 0) {
                this.rootToRootIndex.put(new Path(is.readUTF()), is.readObject());
            }
        }
    }

    public static abstract class RootIndex
    implements Serializable {
        private static final long serialVersionUID = 1106868674823L;
        private transient IPath cachePath;
        protected Map classNameToClassEntry;
        private String rootName;
        protected Index index;

        protected RootIndex() {
        }

        public RootIndex(String rootName, Index index) {
            this.rootName = rootName;
            this.classNameToClassEntry = new HashMap(100);
            this.index = index;
        }

        public String getRootName() {
            return this.rootName;
        }

        public void setDirty() {
            this.index.setDirty(true);
        }

        void setupIndex(IProject project) {
            if (this.getCachePath() == null) {
                this.cachePath = BeanInfoCacheController.getCacheDir(project).append(this.rootName);
            }
        }

        public IPath getCachePath() {
            return this.cachePath;
        }

        public abstract boolean isArchiveRoot();
    }

    public static class ArchiveRootIndex
    extends RootIndex {
        private static final long serialVersionUID = 110686867456L;
        private long archiveModificationStamp;

        protected ArchiveRootIndex() {
        }

        public ArchiveRootIndex(String rootName, long archiveModificationStamp, Index index) {
            super(rootName, index);
            this.archiveModificationStamp = archiveModificationStamp;
        }

        public boolean isArchiveRoot() {
            return true;
        }

        void setArchiveModificationStamp(long archiveModificationStamp) {
            this.archiveModificationStamp = archiveModificationStamp;
            this.setDirty();
        }

        public long getArchiveModificationStamp() {
            return this.archiveModificationStamp;
        }
    }

    public static class FolderRootIndex
    extends RootIndex {
        private static final long serialVersionUID = 1106868674842L;

        protected FolderRootIndex() {
        }

        public FolderRootIndex(String rootName, Index index) {
            super(rootName, index);
        }

        public boolean isArchiveRoot() {
            return false;
        }
    }

    public static class ClassEntry
    implements Serializable {
        private static final long serialVersionUID = 1106868674666L;
        public static final long DELETED_MODIFICATION_STAMP = Long.MIN_VALUE;
        private long modificationStamp;
        private long superModificationStamp;
        private String[] interfaceNames;
        private long[] interfaceModicationStamps;
        private transient Resource pendingResource;
        private RootIndex rootIndex;
        private String className;
        private boolean saveOperations;
        private long configurationModificationStamp;
        private boolean overrideCacheExists;
        private transient Resource pendingOverrideResource;

        protected ClassEntry() {
        }

        ClassEntry(RootIndex rootIndex, String className) {
            this.setRootIndex(rootIndex);
            this.className = className;
            this.modificationStamp = -1L;
            rootIndex.classNameToClassEntry.put(className, this);
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isDeleted() {
            return this.getModificationStamp() == Long.MIN_VALUE;
        }

        public synchronized void markDeleted() {
            if (!this.isDeleted()) {
                this.getRootIndex().classNameToClassEntry.remove(this.className);
                this.setModificationStamp(Long.MIN_VALUE);
            }
        }

        public boolean isStale() {
            return this.getModificationStamp() == -1L;
        }

        public synchronized long getModificationStamp() {
            return this.modificationStamp;
        }

        public synchronized long getSuperModificationStamp() {
            return this.superModificationStamp;
        }

        public synchronized String[] getInterfaceNames() {
            return this.interfaceNames;
        }

        public synchronized long[] getInterfaceModificationStamps() {
            return this.interfaceModicationStamps;
        }

        void setModificationStamp(long modificationStamp) {
            if (this.modificationStamp != modificationStamp) {
                this.modificationStamp = modificationStamp;
                this.getRootIndex().setDirty();
            }
        }

        public synchronized boolean isOperationsStored() {
            return this.saveOperations;
        }

        void setOperationsStored(boolean storeOperations) {
            this.saveOperations = storeOperations;
        }

        public synchronized long getConfigurationModificationStamp() {
            return this.configurationModificationStamp;
        }

        void setConfigurationModificationStamp(long configurationModificationStamp) {
            this.configurationModificationStamp = configurationModificationStamp;
            this.getRootIndex().setDirty();
        }

        public synchronized boolean overrideCacheExists() {
            return this.overrideCacheExists;
        }

        void setOverrideCacheExists(boolean overrideCacheExists) {
            this.overrideCacheExists = overrideCacheExists;
        }

        public synchronized Resource getPendingResource() {
            return this.pendingResource;
        }

        void setPendingResource(Resource pendingResource) {
            this.pendingResource = pendingResource;
        }

        public synchronized Resource getPendingOverrideResource() {
            return this.pendingOverrideResource;
        }

        void setPendingOverrideResource(Resource pendingOverrideResource) {
            this.pendingOverrideResource = pendingOverrideResource;
        }

        void setRootIndex(RootIndex rootIndex) {
            this.rootIndex = rootIndex;
        }

        RootIndex getRootIndex() {
            return this.rootIndex;
        }

        void setSuperModificationStamp(long superModificationStamp) {
            this.superModificationStamp = superModificationStamp;
        }

        void setInterfaceNames(String[] interfaceNames) {
            this.interfaceNames = interfaceNames;
        }

        void setInterfaceModificationStamps(long[] interfaceModificationStamps) {
            this.interfaceModicationStamps = interfaceModificationStamps;
        }
    }

    protected class SaveParticipant
    implements ISaveParticipant {
        protected SaveParticipant() {
        }

        public void doneSaving(ISaveContext context) {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saving(ISaveContext context) throws CoreException {
            boolean fullsave = false;
            switch (context.getKind()) {
                case 3: {
                    IProject project = context.getProject();
                    BeanInfoCacheController beanInfoCacheController = INSTANCE;
                    synchronized (beanInfoCacheController) {
                        Index projectIndex = (Index)PROJECT_INDEXES.get(project);
                        if (projectIndex != null && projectIndex.isDirty()) {
                            if (this.cleanIndexDirectory(project, projectIndex)) {
                                this.writeIndex(project, projectIndex);
                            } else {
                                PROJECT_INDEXES.remove(project);
                            }
                        }
                        break;
                    }
                }
                case 1: {
                    fullsave = true;
                    BeanInfoCacheController.this.waitForCacheSaveJob();
                }
                case 2: {
                    BeanInfoCacheController beanInfoCacheController = INSTANCE;
                    synchronized (beanInfoCacheController) {
                        try {
                            if (MAIN_INDEX != null) {
                                if (fullsave) {
                                    if (this.cleanIndexDirectory(null, MAIN_INDEX)) {
                                        if (MAIN_INDEX.isDirty()) {
                                            this.writeIndex(null, MAIN_INDEX);
                                        }
                                    } else {
                                        MAIN_INDEX = null;
                                    }
                                } else if (MAIN_INDEX.isDirty()) {
                                    this.writeIndex(null, MAIN_INDEX);
                                }
                            }
                            Iterator projectIndexEntryItr = PROJECT_INDEXES.entrySet().iterator();
                            while (projectIndexEntryItr.hasNext()) {
                                Map.Entry entry = projectIndexEntryItr.next();
                                IProject project = (IProject)entry.getKey();
                                Index index = (Index)entry.getValue();
                                if (fullsave) {
                                    if (this.cleanIndexDirectory(project, index)) {
                                        if (!index.isDirty()) continue;
                                        this.writeIndex(project, index);
                                        continue;
                                    }
                                    projectIndexEntryItr.remove();
                                    continue;
                                }
                                if (!index.isDirty()) continue;
                                this.writeIndex(project, index);
                            }
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
        }

        /*
         * Exception decompiling
         */
        private void writeIndex(IProject project, Index index) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 111->115)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean cleanIndexDirectory(IProject project, Index index) {
            File indexDir = BeanInfoCacheController.getCacheDir(project).toFile();
            if (index.rootToRootIndex.isEmpty()) {
                this.cleanDirectory(indexDir, false);
                return false;
            }
            HashSet<String> validFiles = new HashSet<String>(index.rootToRootIndex.size());
            validFiles.add(BeanInfoCacheController.INDEXFILENAME);
            Iterator itr = index.rootToRootIndex.values().iterator();
            while (itr.hasNext()) {
                RootIndex rootIndex = (RootIndex)itr.next();
                if (this.cleanClassCacheDirectory(rootIndex, project)) {
                    validFiles.add(rootIndex.getRootName());
                    continue;
                }
                itr.remove();
                index.setDirty(true);
            }
            String[] fileNames = indexDir.list();
            int i = 0;
            while (i < fileNames.length) {
                if (!validFiles.contains(fileNames[i])) {
                    File file = new File(indexDir, fileNames[i]);
                    if (file.isDirectory()) {
                        this.cleanDirectory(file, true);
                    } else {
                        file.delete();
                    }
                }
                ++i;
            }
            return true;
        }

        private boolean cleanClassCacheDirectory(RootIndex rootIndex, IProject project) {
            if (rootIndex.classNameToClassEntry.isEmpty()) {
                return false;
            }
            Set validFiles = rootIndex.classNameToClassEntry.keySet();
            File indexDir = BeanInfoCacheController.getCacheDir(project).append(rootIndex.getRootName()).toFile();
            String[] fileNames = indexDir.list();
            if (fileNames != null) {
                int i = 0;
                while (i < fileNames.length) {
                    String classname;
                    ClassEntry ce;
                    String fileName = fileNames[i];
                    if (!(!fileName.endsWith(BeanInfoCacheController.OVERRIDE_CACHE_SUFFIX) ? fileName.endsWith(BeanInfoCacheController.CLASS_CACHE_SUFFIX) && validFiles.contains(fileName.substring(0, fileName.length() - BeanInfoCacheController.CLASS_CACHE_SUFFIX.length())) : (ce = (ClassEntry)rootIndex.classNameToClassEntry.get(classname = fileName.substring(0, fileName.length() - BeanInfoCacheController.OVERRIDE_CACHE_SUFFIX.length()))) != null && ce.overrideCacheExists())) {
                        File file = new File(indexDir, fileName);
                        if (file.isDirectory()) {
                            this.cleanDirectory(file, true);
                        } else {
                            file.delete();
                        }
                    }
                    ++i;
                }
            }
            return true;
        }

        private void cleanDirectory(File dir, boolean eraseDir) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.cleanDirectory(files[i], true);
                } else {
                    files[i].delete();
                }
                ++i;
            }
            if (eraseDir) {
                dir.delete();
            }
        }
    }
}

