/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.osgi.framework.Bundle;

public abstract class RegistryReader {
    String pluginId;
    String extensionPointId;
    private static Bundle systemBundle;

    public static String getPluginId(IConfigurationElement configurationElement) {
        IExtension extension;
        String pluginId = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            pluginId = extension.getNamespace();
        }
        return pluginId;
    }

    public RegistryReader(IPluginRegistry registry, String pluginID, String extensionPoint) {
        this(pluginID, extensionPoint);
    }

    public RegistryReader(String pluginID, String extensionPoint) {
        this.pluginId = pluginID;
        this.extensionPointId = extensionPoint;
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (!recognized) {
            this.logError(element, "Error processing extension: " + element);
        }
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getNamespace() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        Logger.getLogger().logError(buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    public abstract boolean readElement(IConfigurationElement var1);

    public void readRegistry() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this.pluginId, this.extensionPointId);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.internalReadElement(elements[i]);
            ++i;
        }
    }

    public static boolean canCreateExecutableExtension(IConfigurationElement element) {
        return Platform.isRunning() && RegistryReader.getSystemBundle().getState() != 16;
    }

    protected static Bundle getSystemBundle() {
        if (systemBundle == null) {
            systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
        }
        return systemBundle;
    }
}

