/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.logger.proxyrender;

import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.proxy.ILogRenderer2;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.osgi.framework.Bundle;

public abstract class AbstractWorkBenchRenderer
implements ILogRenderer2 {
    private boolean fTraceMode = false;
    private boolean fSettingTrace = false;
    protected Bundle fMyBundle = null;
    protected Logger fMyLogger = null;
    protected ILog fWorkBenchLogger = null;
    protected static final boolean consoleLogOn = "true".equals(System.getProperty("eclipse.consoleLog"));
    private static final int[] STATUS_LEVEL;
    private static final Level[] STATUS_LEVEL_LOOKUP;
    private static final Level[] LEVEL_STATUS;

    static {
        STATUS_LEVEL_LOOKUP = new Level[]{Level.INFO, Level.WARNING, Level.SEVERE};
        STATUS_LEVEL = new int[]{1, 2, 4};
        int maxID = Math.max(0, Math.max(1, Math.max(2, 4)));
        LEVEL_STATUS = new Level[maxID + 1];
        AbstractWorkBenchRenderer.LEVEL_STATUS[0] = Level.FINE;
        AbstractWorkBenchRenderer.LEVEL_STATUS[1] = Level.INFO;
        AbstractWorkBenchRenderer.LEVEL_STATUS[2] = Level.WARNING;
        AbstractWorkBenchRenderer.LEVEL_STATUS[4] = Level.SEVERE;
    }

    public AbstractWorkBenchRenderer(Logger logger) {
        this.fMyLogger = logger;
        this.fTraceMode = this.fMyLogger.getTraceMode();
        String pluginID = this.fMyLogger.getPluginID();
        this.fMyBundle = Platform.getBundle((String)pluginID);
        if (this.fMyBundle == null) {
            throw new RuntimeException("Invalid Plugin ID");
        }
        this.fWorkBenchLogger = Platform.getLog((Bundle)this.fMyBundle);
        this.setTraceMode(this.fMyLogger.getTraceMode() || this.isDebugging(this.fMyBundle));
        this.fMyLogger.setRenderer(this);
    }

    private boolean isDebugging(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            String key = String.valueOf(symbolicName) + "/debug";
            String value = Platform.getDebugOption((String)key);
            return value == null ? false : value.equalsIgnoreCase("true");
        }
        return false;
    }

    public void setTraceMode(boolean flag) {
        if (this.fSettingTrace) {
            return;
        }
        this.fSettingTrace = true;
        this.fTraceMode = flag;
        this.fMyLogger.setTraceMode(flag);
        this.fSettingTrace = false;
    }

    public abstract String log(String var1);

    protected void log(String msg, Level l, boolean loggedToWorkbench) {
        this.log(msg);
    }

    public String log(String msg, int type) {
        String target = this.logWorkBench(msg, type);
        if (this.fTraceMode || target.equals("")) {
            return this.log(msg);
        }
        return target;
    }

    public String logWorkBench(String msg, int type) {
        try {
            if (this.fWorkBenchLogger != null) {
                int ErrCode;
                switch (type) {
                    case 0: {
                        ErrCode = 4;
                        break;
                    }
                    case 2: {
                        ErrCode = 2;
                        break;
                    }
                    case 3: {
                        ErrCode = 1;
                        break;
                    }
                    case 1: {
                        ErrCode = 0;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid Log Type");
                    }
                }
                Status status = new Status(ErrCode, this.fMyBundle.getSymbolicName(), 0, msg, null);
                this.fWorkBenchLogger.log((IStatus)status);
                return "workbench log";
            }
            return "";
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    protected boolean isLogging(Level level) {
        return this.fTraceMode || this.fMyLogger.isLoggingLevel(level);
    }

    protected Level getLogLevel(IStatus status) {
        return LEVEL_STATUS[status.getSeverity()];
    }

    protected int getStatusSeverity(Level logLevel) {
        int i = 0;
        while (i < STATUS_LEVEL_LOOKUP.length) {
            if (STATUS_LEVEL_LOOKUP[i] == logLevel) {
                return STATUS_LEVEL[i];
            }
            ++i;
        }
        return 0;
    }

    protected String logWorkbench(String msg, Level level) {
        String result = "";
        if (this.fMyLogger.isLoggingLevel(level)) {
            Platform.getLog((Bundle)this.fMyBundle).log((IStatus)new Status(this.getStatusSeverity(level), this.fMyBundle.getSymbolicName(), 0, msg, null));
            result = "workbench log";
            if (this.fTraceMode) {
                this.log(msg, level, true);
            }
        } else if (this.fTraceMode) {
            this.log(msg, level, false);
        }
        return result;
    }

    private String getStatusMsg(IStatus s, Level l) {
        if (s.getException() != null) {
            return this.fMyLogger.getGenericMsg(String.valueOf(s.toString()) + this.fMyLogger.fLineSeperator + this.fMyLogger.exceptionToString(s.getException()), l);
        }
        return this.fMyLogger.getGenericMsg(s.toString(), l);
    }

    protected String logWorkbench(IStatus s, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = this.getLogLevel(s);
        }
        String result = "";
        if (this.fMyLogger.isLoggingLevel(level)) {
            Platform.getLog((Bundle)this.fMyBundle).log(s);
            result = "workbench log";
            if (this.fTraceMode) {
                this.log(this.getStatusMsg(s, level), level, true);
            }
        } else if (this.fTraceMode) {
            this.log(this.getStatusMsg(s, level), level, false);
        }
        return result;
    }

    protected String logWorkbench(Throwable t, Level level) {
        String result = "";
        if (this.fMyLogger.isLoggingLevel(level)) {
            Platform.getLog((Bundle)this.fMyBundle).log((IStatus)new Status(this.getStatusSeverity(level), this.fMyBundle.getSymbolicName(), 0, "Exception thrown.", t));
            result = "workbench log";
            if (this.fTraceMode) {
                this.log(this.fMyLogger.getGenericMsg(this.fMyLogger.exceptionToString(t), level), level, true);
            }
        } else if (this.fTraceMode) {
            this.log(this.fMyLogger.getGenericMsg(this.fMyLogger.exceptionToString(t), level), level, false);
        }
        return result;
    }

    public String log(boolean b, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(b), level), level);
        }
        return "";
    }

    public String log(byte b, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(b), level), level);
        }
        return "";
    }

    public String log(char c, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(c), level), level);
        }
        return "";
    }

    public String log(double d, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(d), level), level);
        }
        return "";
    }

    public String log(float f, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(f), level), level);
        }
        return "";
    }

    public String log(int i, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(i), level), level);
        }
        return "";
    }

    public String log(long l, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(l), level), level);
        }
        return "";
    }

    public String log(Object o, Level level) {
        if (o instanceof IStatus) {
            return this.logWorkbench((IStatus)o, level);
        }
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(o), level), level);
        }
        return "";
    }

    public String log(short s, Level level) {
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(this.fMyLogger.getGenericMsg(String.valueOf(s), level), level);
        }
        return "";
    }

    public String log(Throwable t, Level level) {
        if (t instanceof CoreException) {
            return this.logWorkbench(((CoreException)t).getStatus(), level);
        }
        if (level == ILogRenderer2.DEFAULT) {
            level = Level.SEVERE;
        }
        if (this.isLogging(level)) {
            return this.logWorkbench(t, level);
        }
        return "";
    }
}

