/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.emf.workbench;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class JavaProjectUtilities
extends ProjectUtilities {
    public static IJavaProject getJavaProject(IProject p) {
        try {
            return (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void updateClasspath(IJavaProject javaProject) throws JavaModelException {
        if (javaProject != null) {
            javaProject.setRawClasspath(javaProject.getRawClasspath(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IPath getJavaProjectOutputLocation(IProject p) {
        try {
            IJavaProject javaProj = JavaProjectUtilities.getJavaProject(p);
            if (javaProj == null) {
                return null;
            }
            if (!javaProj.isOpen()) {
                javaProj.open(null);
            }
            return javaProj.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IContainer getJavaProjectOutputContainer(IProject p) {
        IPath path = JavaProjectUtilities.getJavaProjectOutputLocation(p);
        if (path == null) {
            return null;
        }
        if (path.segmentCount() == 1) {
            return p;
        }
        return p.getFolder(path.removeFirstSegments(1));
    }

    public static IPath getJavaProjectOutputAbsoluteLocation(IProject p) {
        IContainer container = JavaProjectUtilities.getJavaProjectOutputContainer(p);
        if (container != null) {
            return container.getLocation();
        }
        return null;
    }

    public static JavaModel getJavaModel() {
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public static List getSourcePackageFragmentRoots(IJavaProject javaProj) throws JavaModelException {
        ArrayList result = new ArrayList();
        IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() == 1) {
                result.add(result);
            }
            ++i;
        }
        return result;
    }

    public static void removeFromJavaClassPath(IProject p, IResource res) throws JavaModelException {
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)res.getFullPath(), null, null);
        JavaProjectUtilities.removeFromJavaClassPath(p, entry);
    }

    public static void removeFromJavaClassPath(IProject p, IPath path) throws JavaModelException {
        IFile f = p.getFile(path);
        JavaProjectUtilities.removeFromJavaClassPath(p, (IResource)f);
    }

    public static void removeFromJavaClassPath(IProject p, IClasspathEntry entry) throws JavaModelException {
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {}
        if (javaProject != null) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            javaProject.setRawClasspath(JavaProjectUtilities.primRemoveFromJavaClassPath(classpath, entry), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void removeFromJavaClassPath(IProject p, List entries) throws JavaModelException {
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {}
        if (javaProject != null) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            javaProject.setRawClasspath(JavaProjectUtilities.primRemoveFromJavaClassPath(classpath, entries), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected static IClasspathEntry[] primRemoveFromJavaClassPath(IClasspathEntry[] classpath, IClasspathEntry entry) throws JavaModelException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        boolean didRemove = false;
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry cpEntry = classpath[i];
            if (!entry.getPath().equals((Object)classpath[i].getPath())) {
                result.add(cpEntry);
            } else {
                didRemove = true;
            }
            ++i;
        }
        if (!didRemove) {
            return classpath;
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    protected static IClasspathEntry[] primRemoveFromJavaClassPath(IClasspathEntry[] classpath, List entries) throws JavaModelException {
        List<IClasspathEntry> arrayList = Arrays.asList(classpath);
        ArrayList<IClasspathEntry> removeable = new ArrayList<IClasspathEntry>(arrayList);
        boolean didRemove = false;
        int size = entries.size();
        int i = 0;
        while (i < size) {
            IClasspathEntry entry = (IClasspathEntry)entries.get(i);
            int j = 0;
            while (j < classpath.length) {
                IClasspathEntry cpEntry = classpath[j];
                if (entry.getPath().equals((Object)classpath[j].getPath()) && removeable.remove(cpEntry)) {
                    didRemove = true;
                }
                ++j;
            }
            ++i;
        }
        if (!didRemove) {
            return classpath;
        }
        return removeable.toArray(new IClasspathEntry[removeable.size()]);
    }

    public static URL[] getClasspathAsURLArray(IJavaProject javaProject) {
        if (javaProject == null) {
            return null;
        }
        HashSet visited = new HashSet();
        ArrayList urls = new ArrayList(20);
        JavaProjectUtilities.collectClasspathURLs(javaProject, urls, visited, true);
        URL[] result = new URL[urls.size()];
        urls.toArray(result);
        return result;
    }

    private static void collectClasspathURLs(IJavaProject javaProject, List urls, Set visited, boolean isFirstProject) {
        if (visited.contains(javaProject)) {
            return;
        }
        visited.add(javaProject);
        IPath outPath = JavaProjectUtilities.getJavaProjectOutputAbsoluteLocation(javaProject.getProject());
        outPath = outPath.addTrailingSeparator();
        URL out = ProjectUtilities.createFileURL(outPath);
        urls.add(out);
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: 
                case 5: {
                    JavaProjectUtilities.collectClasspathEntryURL(entry, urls);
                    break;
                }
                case 2: {
                    if (!isFirstProject && !entry.isExported()) break;
                    JavaProjectUtilities.collectClasspathURLs(JavaProjectUtilities.getJavaProject(entry), urls, visited, false);
                }
            }
            ++i;
        }
    }

    private static void collectClasspathEntryURL(IClasspathEntry entry, List urls) {
        URL url = ProjectUtilities.createFileURL(entry.getPath());
        if (url != null) {
            urls.add(url);
        }
    }

    private static IJavaProject getJavaProject(IClasspathEntry entry) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0));
        if (proj != null) {
            return JavaProjectUtilities.getJavaProject(proj);
        }
        return null;
    }

    public static boolean isBinaryProject(IProject aProject) {
        IJavaProject javaProj = JavaProjectUtilities.getJavaProject(aProject);
        if (javaProj == null) {
            return false;
        }
        IClasspathEntry[] entries = null;
        try {
            entries = javaProj.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void appendJavaClassPath(IProject p, List appendClasspathEntries) throws JavaModelException {
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {}
        if (javaProject != null) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (appendClasspathEntries.indexOf(entry) < 0) {
                    newPathList.add(entry);
                }
                ++i;
            }
            newPathList.addAll(appendClasspathEntries);
            IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
            javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendJavaClassPath(IProject p, IClasspathEntry newEntry) throws JavaModelException {
        IJavaProject javaProject = JavaProjectUtilities.getJavaProject(p);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (Platform.getOS().equals("win32")) {
                if (entry.getPath().toString().equalsIgnoreCase(newEntry.getPath().toString())) return;
                newPathList.add(entry);
            } else {
                if (entry.getPath().equals((Object)newEntry.getPath())) return;
                newPathList.add(entry);
            }
            ++i;
        }
        newPathList.add(newEntry);
        IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IPath getSourcePathOrFirst(IProject p, String defaultSourceName) {
        IJavaProject javaProj = JavaProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError(ex);
            return null;
        }
        IClasspathEntry firstSource = null;
        IPath defaultSourcePath = null;
        if (defaultSourceName != null) {
            defaultSourcePath = ProjectUtilities.createPath(p, defaultSourceName);
        }
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3) {
                if (firstSource == null) {
                    firstSource = cp[i];
                    if (defaultSourcePath == null) break;
                }
                if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                    return defaultSourcePath.removeFirstSegments(1);
                }
            }
            ++i;
        }
        if (firstSource == null) {
            return null;
        }
        if (firstSource.getPath().segment(0).equals(p.getName())) {
            return firstSource.getPath().removeFirstSegments(1);
        }
        return null;
    }

    protected static List getSourcePaths(IProject p) {
        IJavaProject javaProj = JavaProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError(ex);
            return null;
        }
        ArrayList<IPath> sourcePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3) {
                sourcePaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return sourcePaths;
    }

    public static void forceClasspathReload(IProject project) throws JavaModelException {
        IPath output;
        IClasspathEntry[] entries;
        IJavaProject javaProj = JavaProjectUtilities.getJavaProject(project);
        if (javaProj != null && (entries = javaProj.readRawClasspath()) != null && (output = javaProj.readOutputLocation()) != null) {
            javaProj.setRawClasspath(entries, output, null);
        }
    }

    public static List getLocalJARPathsFromClasspath(IProject proj) {
        IJavaProject javaProj = JavaProjectUtilities.getJavaProject(proj);
        if (javaProj == null) {
            return null;
        }
        IPath projectPath = proj.getFullPath();
        ArrayList<IPath> result = new ArrayList<IPath>();
        try {
            IClasspathEntry[] entries = javaProj.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IPath path;
                int segments;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 1 && (segments = (path = entry.getPath()).matchingFirstSegments(projectPath)) > 0) {
                    result.add(path.removeFirstSegments(segments));
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JEMUtilPlugin.getLogger().logError(e);
        }
        return result;
    }

    protected static List getlibraryPaths(IProject p) {
        IJavaProject javaProj = JavaProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError(ex);
            return null;
        }
        ArrayList<IPath> libraryPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 1) {
                libraryPaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return libraryPaths;
    }

    public static IContainer getSourceFolderOrFirst(IProject p, String defaultSourceName) {
        try {
            IPath sourcePath = JavaProjectUtilities.getSourcePathOrFirst(p, defaultSourceName);
            if (sourcePath == null) {
                return null;
            }
            if (sourcePath.isEmpty()) {
                return p;
            }
            return p.getFolder(sourcePath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static List getSourceFolders(IProject p) {
        try {
            ArrayList<IFolder> sourceFolders = new ArrayList<IFolder>();
            List sourcePaths = JavaProjectUtilities.getSourcePaths(p);
            if (sourcePaths != null && !sourcePaths.isEmpty()) {
                int i = 0;
                while (i < sourcePaths.size()) {
                    IPath path = (IPath)sourcePaths.get(i);
                    if (!path.isEmpty()) {
                        sourceFolders.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return sourceFolders;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    public static List getSourceContainers(IProject p) {
        try {
            ArrayList<Object> sourceContainers = new ArrayList<Object>();
            List sourcePaths = JavaProjectUtilities.getSourcePaths(p);
            if (sourcePaths != null && !sourcePaths.isEmpty()) {
                int i = 0;
                while (i < sourcePaths.size()) {
                    IPath path = (IPath)sourcePaths.get(i);
                    if (path.isEmpty()) {
                        sourceContainers.add(p);
                    } else {
                        sourceContainers.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return sourceContainers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    public static List getLibraryContainers(IProject p) {
        try {
            ArrayList<Object> libraryContainers = new ArrayList<Object>();
            List libraryPaths = JavaProjectUtilities.getlibraryPaths(p);
            if (libraryPaths != null && !libraryPaths.isEmpty()) {
                int i = 0;
                while (i < libraryPaths.size()) {
                    IPath path = (IPath)libraryPaths.get(i);
                    if (path.isEmpty()) {
                        libraryContainers.add(p);
                    } else {
                        libraryContainers.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return libraryContainers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }
}

