/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.emf.workbench;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.util.logger.proxy.Logger;

public class ProjectUtilities {
    public static final String DOT_PROJECT = ".project";
    public static final String DOT_CLASSPATH = ".classpath";
    static /* synthetic */ Class class$0;

    public static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
        newNatures[0] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    public static void addNatureToProjectLast(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    public static void removeNatureFromProject(IProject project, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int size = prevNatures.length;
        int newsize = 0;
        String[] newNatures = new String[size];
        boolean matchfound = false;
        int i = 0;
        while (i < size) {
            if (prevNatures[i].equals(natureId)) {
                matchfound = true;
            } else {
                newNatures[newsize++] = prevNatures[i];
            }
            ++i;
        }
        if (!matchfound) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jem.util", 0, "The nature id " + natureId + " does not exist on the project " + project.getName(), null));
        }
        String[] temp = newNatures;
        newNatures = new String[newsize];
        System.arraycopy(temp, 0, newNatures, 0, newsize);
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static void addReferenceProjects(IProject project, List toBeAddedProjectsList) throws CoreException {
        IProjectDescription description = project.getDescription();
        IProject[] projects = description.getReferencedProjects();
        ArrayList<Object> projectsList = new ArrayList<Object>();
        int i = 0;
        while (i < projects.length) {
            projectsList.add(projects[i]);
            ++i;
        }
        i = 0;
        while (i < toBeAddedProjectsList.size()) {
            projectsList.add(toBeAddedProjectsList.get(i));
            ++i;
        }
        IProject[] refProjects = new IProject[projectsList.size()];
        int i2 = 0;
        while (i2 < refProjects.length) {
            refProjects[i2] = (IProject)projectsList.get(i2);
            ++i2;
        }
        description.setReferencedProjects(refProjects);
        project.setDescription(description, null);
    }

    public static void addReferenceProjects(IProject project, IProject projectToBeAdded) throws CoreException {
        IProjectDescription description = project.getDescription();
        IProject[] projects = description.getReferencedProjects();
        ArrayList<IProject> projectsList = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            projectsList.add(projects[i]);
            ++i;
        }
        projectsList.add(projectToBeAdded);
        IProject[] refProjects = new IProject[projectsList.size()];
        int i2 = 0;
        while (i2 < refProjects.length) {
            refProjects[i2] = (IProject)projectsList.get(i2);
            ++i2;
        }
        description.setReferencedProjects(refProjects);
        project.setDescription(description, null);
    }

    public static void forceAutoBuild(IProject project, IProgressMonitor progressMonitor) {
        try {
            project.build(6, progressMonitor);
        }
        catch (CoreException coreException) {}
    }

    public static boolean getCurrentAutoBuildSetting() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wd = workspace.getDescription();
        return wd.isAutoBuilding();
    }

    public static IProject getProject(Object object, String natureId) {
        IProject result = ProjectUtilities.getProject(object);
        if (natureId == null) {
            return result;
        }
        if (result != null && result.isAccessible() && natureId != null) {
            try {
                if (result.hasNature(natureId)) {
                    return result;
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError(e);
            }
        }
        return null;
    }

    public static IProject getProject(Object object) {
        IProject result = null;
        if (object instanceof IProject) {
            result = (IProject)object;
        } else if (object instanceof IResource) {
            result = ((IResource)object).getProject();
        } else if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = (IProject)iAdaptable.getAdapter((Class)clazz);
        } else if (object instanceof EObject) {
            result = ProjectUtilities.getProject((EObject)object);
        }
        return result;
    }

    public static IProject getProject(EObject aRefObject) {
        if (aRefObject != null) {
            Resource resource = aRefObject.eResource();
            return ProjectUtilities.getProject(resource);
        }
        return null;
    }

    public static IProject getProject(Resource resource) {
        URIConverter converter;
        ResourceSet set;
        ResourceSet resourceSet = set = resource == null ? null : resource.getResourceSet();
        if (set instanceof ProjectResourceSet) {
            return ((ProjectResourceSet)set).getProject();
        }
        URIConverter uRIConverter = converter = set == null ? null : set.getURIConverter();
        if (converter != null && converter instanceof WorkbenchURIConverter && ((WorkbenchURIConverter)converter).getOutputContainer() != null) {
            return ((WorkbenchURIConverter)converter).getOutputContainer().getProject();
        }
        return null;
    }

    public static void removeReferenceProjects(IProject project, List toBeRemovedProjectList) throws CoreException {
        IProjectDescription description = project.getDescription();
        IProject[] projects = description.getReferencedProjects();
        ArrayList<IProject> projectsList = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            projectsList.add(projects[i]);
            ++i;
        }
        i = 0;
        while (i < toBeRemovedProjectList.size()) {
            projectsList.remove(toBeRemovedProjectList.get(i));
            ++i;
        }
        IProject[] refProjects = new IProject[projectsList.size()];
        int i2 = 0;
        while (i2 < refProjects.length) {
            refProjects[i2] = (IProject)projectsList.get(i2);
            ++i2;
        }
        description.setReferencedProjects(refProjects);
        project.setDescription(description, null);
    }

    public static void removeReferenceProjects(IProject project, IProject toBeRemovedProject) throws CoreException {
        IProjectDescription description = project.getDescription();
        IProject[] projects = description.getReferencedProjects();
        ArrayList<IProject> projectsList = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            projectsList.add(projects[i]);
            ++i;
        }
        projectsList.remove(toBeRemovedProject);
        IProject[] refProjects = new IProject[projectsList.size()];
        int i2 = 0;
        while (i2 < refProjects.length) {
            refProjects[i2] = (IProject)projectsList.get(i2);
            ++i2;
        }
        description.setReferencedProjects(refProjects);
        project.setDescription(description, null);
    }

    public static void turnAutoBuildOff() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription wd = workspace.getDescription();
            wd.setAutoBuilding(false);
            workspace.setDescription(wd);
        }
        catch (CoreException coreException) {}
    }

    public static void turnAutoBuildOn() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription wd = workspace.getDescription();
            wd.setAutoBuilding(true);
            workspace.setDescription(wd);
        }
        catch (CoreException coreException) {}
    }

    public static void turnAutoBuildOn(boolean aBoolean) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription wd = workspace.getDescription();
            wd.setAutoBuilding(aBoolean);
            workspace.setDescription(wd);
        }
        catch (CoreException coreException) {}
    }

    public static boolean addToBuildSpec(String builderID, IProject project) throws CoreException {
        return ProjectUtilities.addToBuildSpecBefore(builderID, null, project);
    }

    public static boolean addToBuildSpecBefore(String builderID, String successorID, IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            boolean successorFound = false;
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            int j = 0;
            int index = 0;
            while (j < commands.length) {
                if (successorID != null && commands[j].getBuilderName().equals(successorID)) {
                    successorFound = true;
                    newCommands[index++] = command;
                }
                newCommands[index] = commands[j];
                ++j;
                ++index;
            }
            if (!successorFound) {
                newCommands[newCommands.length - 1] = command;
            }
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        return !found;
    }

    public static boolean removeFromBuildSpec(String builderID, IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            ICommand[] newCommands = new ICommand[commands.length - 1];
            int newCount = 0;
            int i2 = 0;
            while (i2 < commands.length) {
                if (!commands[i2].getBuilderName().equals(builderID)) {
                    newCommands[newCount] = commands[i2];
                    ++newCount;
                }
                ++i2;
            }
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        return found;
    }

    public static void ensureContainerNotReadOnly(IResource resource) {
        if (resource != null && !resource.exists()) {
            IContainer container = resource.getParent();
            while (container != null && !container.isReadOnly()) {
                container = container.getParent();
            }
            if (container != null) {
                container.setReadOnly(false);
            }
        }
    }

    public static IProject[] getProjectsForPrimaryNature(String natureID) {
        IProject[] projectsWithNature = new IProject[]{};
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            if (ProjectUtilities.isProjectPrimaryNature(projects[i], natureID)) {
                result.add(projects[i]);
            }
            ++i;
        }
        return result.toArray(projectsWithNature);
    }

    public static IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public static boolean isProjectPrimaryNature(IProject project, String natureID) {
        String[] natures = null;
        try {
            natures = project.getDescription().getNatureIds();
        }
        catch (Exception exception) {}
        return natures != null && natures.length > 0 && natures[0].equals(natureID);
    }

    protected static IPath createPath(IProject p, String defaultSourceName) {
        Path path = new Path(p.getName());
        path = path.append(defaultSourceName);
        path = path.makeAbsolute();
        return path;
    }

    public static List getFilesAffectedByClasspathChange(IProject p) {
        ArrayList result = new ArrayList(2);
        ProjectUtilities.addFileIfExists(p, result, DOT_CLASSPATH);
        ProjectUtilities.addFileIfExists(p, result, DOT_PROJECT);
        return result;
    }

    protected static void addFileIfExists(IProject p, List aList, String filename) {
        IFile aFile = p.getFile(filename);
        if (aFile != null && aFile.exists()) {
            aList.add(aFile);
        }
    }

    public static String[] getProjectNamesWithoutForwardSlash(String[] projecNames) {
        String[] projNames = new String[projecNames.length];
        List<String> temp = Arrays.asList(projecNames);
        int i = 0;
        while (i < temp.size()) {
            String name = temp.get(i);
            projNames[i] = name.startsWith("/") ? name.substring(1, name.length()) : name;
            ++i;
        }
        return projNames;
    }

    protected static URL createFileURL(IPath path) {
        try {
            return path.toFile().toURL();
        }
        catch (MalformedURLException e) {
            Logger.getLogger().log(e, Level.WARNING);
            return null;
        }
    }

    public static Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        if (oldObjects == null && newObjects != null && newObjects.length == 1) {
            return newObjects[0];
        }
        return null;
    }

    public static List getAllProjectFiles(IProject project) {
        List result = new ArrayList();
        if (project == null) {
            return result;
        }
        try {
            result = ProjectUtilities.collectFiles(project.members(), result);
        }
        catch (CoreException coreException) {}
        return result;
    }

    private static List collectFiles(IResource[] members, List result) throws CoreException {
        int i = 0;
        while (i < members.length) {
            IResource res = members[i];
            if (res instanceof IFolder) {
                ProjectUtilities.collectFiles(((IFolder)res).members(), result);
            } else if (res instanceof IFile) {
                result.add(res);
            }
            ++i;
        }
        return result;
    }

    public static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static boolean hasBuilder(IProject project, String builderName) {
        try {
            ICommand[] builders = project.getDescription().getBuildSpec();
            int i = 0;
            while (i < builders.length) {
                ICommand builder = builders[i];
                if (builder != null && builder.getBuilderName().equals(builderName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

