/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.logger.proxyrender;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.logger.proxyrender.AbstractWorkBenchRenderer;
import org.osgi.framework.Bundle;

public class DefaultPluginTraceRenderer
extends AbstractWorkBenchRenderer {
    public static final String PluginTraceFileName = "/.log";
    private String fTraceFile = String.valueOf(Platform.getStateLocation((Bundle)this.fMyBundle).toString()) + "/.log";
    private PrintWriter traceFile = null;

    public DefaultPluginTraceRenderer(Logger logger) {
        super(logger);
        new File(this.fTraceFile).delete();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeTraceFile() {
        if (this.traceFile == null) {
            return;
        }
        try {
            this.traceFile.flush();
            this.traceFile.close();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.traceFile = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.traceFile = null;
            return;
        }
    }

    public String log(String msg) {
        System.out.println(msg);
        this.openTraceFile();
        if (this.traceFile != null) {
            this.traceFile.println(msg);
            this.closeTraceFile();
        }
        return this.fTraceFile;
    }

    protected void log(String msg, Level l, boolean loggedToWorkbench) {
        if (!loggedToWorkbench || !AbstractWorkBenchRenderer.consoleLogOn) {
            if (l == Level.SEVERE) {
                System.err.println(msg);
            } else {
                System.out.println(msg);
            }
        }
        this.openTraceFile();
        if (this.traceFile != null) {
            this.traceFile.println(msg);
            this.closeTraceFile();
        }
    }

    private void openTraceFile() {
        try {
            this.traceFile = new PrintWriter(new FileOutputStream(this.fTraceFile, true));
        }
        catch (IOException iOException) {
            this.traceFile = null;
        }
    }
}

