/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.plugin;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.util.emf.workbench.ProjectResourceSetImpl;
import org.eclipse.jem.internal.util.emf.workbench.WorkspaceResourceNotifier;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceHandler;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.osgi.framework.Bundle;

public class JEMUtilPlugin
extends Plugin {
    public static final String ID = "org.eclipse.jem.util";
    public static final String PLUGIN_ID = "org.eclipse.jem.util";
    public static final String UI_CONTEXT_EXTENSION_POINT = "uiContextSensitiveClass";
    public static final String UI_TESTER_EXTENSION_POINT = "uiTester";
    public static final String WORKSPACE_PROTOCOL = "workspace";
    public static final String PLATFORM_PROTOCOL = "platform";
    public static final String PLATFORM_RESOURCE = "resource";
    public static final String PLATFORM_PLUGIN = "plugin";
    private static WorkspaceResourceNotifier sharedCache;
    private static ResourceSet pluginResourceSet;
    private static String[] GLOBAL_LOADING_PLUGIN_NAMES;
    private static JEMUtilPlugin DEFAULT;

    public JEMUtilPlugin() {
        DEFAULT = this;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static JEMUtilPlugin getDefault() {
        return DEFAULT;
    }

    public static WorkspaceResourceNotifier getSharedCache() {
        if (sharedCache == null) {
            sharedCache = new WorkspaceResourceNotifier();
        }
        return sharedCache;
    }

    public static void setSharedCache(WorkspaceResourceNotifier aSharedCache) {
        sharedCache = aSharedCache;
    }

    public static ResourceSet createIsolatedResourceSet() {
        return null;
    }

    public static void addWorkspaceEMFResourceListener(Adapter adapter) {
        if (adapter != null && !JEMUtilPlugin.getSharedCache().eAdapters().contains((Object)adapter)) {
            JEMUtilPlugin.getSharedCache().eAdapters().add((Object)adapter);
        }
    }

    public static void removeWorkspaceEMFResourceListener(Adapter adapter) {
        if (adapter != null) {
            JEMUtilPlugin.getSharedCache().eAdapters().remove((Object)adapter);
        }
    }

    public static boolean isActivated() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jem.util");
        if (bundle != null) {
            return bundle.getState() == 32;
        }
        return false;
    }

    public void addExtendedResourceHandlers(ProjectResourceSet aResourceSet) {
        if (aResourceSet == null) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint pct = registry.getExtensionPoint(this.getBundle().getSymbolicName(), "ResourceHandlerExtension");
        IExtension[] extension = pct.getExtensions();
        int l = 0;
        while (l < extension.length) {
            IExtension config = extension[l];
            IConfigurationElement[] cElems = config.getConfigurationElements();
            ResourceHandler handler = null;
            int i = 0;
            while (i < cElems.length) {
                try {
                    handler = (ResourceHandler)cElems[i].createExecutableExtension("run");
                }
                catch (Exception exception) {
                    handler = null;
                }
                if (handler != null) {
                    aResourceSet.add(handler);
                }
                ++i;
            }
            ++l;
        }
    }

    public static ResourceSet getPluginResourceSet() {
        if (pluginResourceSet == null) {
            pluginResourceSet = new ProjectResourceSetImpl(null);
        }
        return pluginResourceSet;
    }

    public static void setPluginResourceSet(ResourceSet set) {
        pluginResourceSet = set;
    }

    public static String[] getGlobalLoadingPluginNames() {
        if (GLOBAL_LOADING_PLUGIN_NAMES == null) {
            GLOBAL_LOADING_PLUGIN_NAMES = JEMUtilPlugin.readGlobalLoadingPluginNames();
        }
        return GLOBAL_LOADING_PLUGIN_NAMES;
    }

    public static Logger getLogger() {
        return Logger.getLogger("org.eclipse.jem.util");
    }

    private static String[] readGlobalLoadingPluginNames() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = reg.getExtensionPoint("org.eclipse.jem.util", "globalPluginResourceLoad");
        IExtension[] extensions = exPoint.getExtensions();
        String[] names = new String[extensions.length];
        if (extensions.length > 0) {
            int i = 0;
            while (i < extensions.length) {
                names[i] = extensions[i].getNamespace();
                ++i;
            }
        }
        return names;
    }
}

