/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jem.internal.java.adapters.IJavaReflectionKeyExtension;
import org.eclipse.jem.internal.java.adapters.JavaReflectionKey;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.impl.JavaFactoryImpl;

public class JavaXMIFactoryImpl
extends XMIResourceFactoryImpl {
    private static final String SCHEMA_SEPERATOR = ":/";
    public static final String SCHEME = "java";
    protected List extensions = new ArrayList();
    public static final JavaXMIFactoryImpl INSTANCE = new JavaXMIFactoryImpl();

    public void registerReflectionKeyExtension(IJavaReflectionKeyExtension extension) {
        this.extensions.add(extension);
    }

    public void deregisterReflectionKeyExtension(IJavaReflectionKeyExtension extension) {
        this.extensions.remove(extension);
    }

    protected void createJavaPackage(String packageName, String xmiuri, Resource resource) {
        JavaRefFactory jfac = JavaRefFactory.eINSTANCE;
        JavaPackage pack = jfac.createJavaPackage();
        JavaFactoryImpl fact = new JavaFactoryImpl();
        pack.setEFactoryInstance((EFactory)fact);
        if (packageName.length() > 0) {
            pack.setNsPrefix(packageName);
            pack.setName(packageName);
        } else {
            pack.setNsPrefix("_-javaprim");
            pack.setName("_-javaprim");
        }
        pack.setNsURI(xmiuri);
        resource.getContents().add((Object)pack);
        ((XMIResource)pack.eResource()).setID((EObject)pack, "*package");
    }

    public Resource createResource(URI uri) {
        JavaXMIResource resource = new JavaXMIResource(uri);
        resource.setReflectionKey(new JavaReflectionKey(this.extensions, (XMIResource)resource));
        String uriString = uri.toString();
        this.createJavaPackage(this.stripScheme(uriString), uriString, (Resource)resource);
        return resource;
    }

    public static void register() {
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put(SCHEME, INSTANCE);
    }

    private String stripScheme(String uri) {
        int index = uri.indexOf(SCHEMA_SEPERATOR);
        if (index != -1) {
            return uri.substring(index + SCHEMA_SEPERATOR.length(), uri.length());
        }
        return uri;
    }

    public static class JavaXMIResource
    extends XMIResourceImpl {
        protected JavaReflectionKey reflectionKey;

        public JavaXMIResource(URI uri) {
            super(uri);
        }

        public void setReflectionKey(JavaReflectionKey key) {
            this.reflectionKey = key;
        }

        public void load(Map options) throws IOException {
            try {
                super.load(options);
            }
            catch (Exception exception) {}
        }

        public EObject getEObject(String uriFragment) {
            EObject result = super.getEObject(uriFragment);
            if (result == null && this.reflectionKey != null) {
                result = (EObject)this.reflectionKey.get(uriFragment);
            }
            return result;
        }

        protected boolean useIDAttributes() {
            return false;
        }
    }
}

