/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters.jdk;

import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.java.adapters.jdk.JDKAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaClassJDKAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaVisibilityKind;

public class JavaFieldJDKAdaptor
extends JDKAdaptor {
    protected java.lang.reflect.Field sourceField = null;
    protected Class parentType = null;

    public JavaFieldJDKAdaptor(Notifier target, JavaJDKAdapterFactory anAdapterFactory) {
        super(target, anAdapterFactory);
    }

    protected Class getParentType() {
        Field targetField;
        JavaClass parentJavaClass;
        JavaClassJDKAdaptor pa;
        if (this.parentType == null && (pa = (JavaClassJDKAdaptor)EcoreUtil.getAdapter((List)(parentJavaClass = (targetField = (Field)this.getTarget()).getJavaClass()).eAdapters(), (Object)"JavaReflection")) != null) {
            this.parentType = pa.getSourceType();
        }
        return this.parentType;
    }

    public Object getReflectionSource() {
        return this.getSourceField();
    }

    public boolean hasCachedReflectionSource() {
        return this.sourceField != null;
    }

    protected java.lang.reflect.Field getSourceField() {
        Class parent;
        if (this.sourceField == null && (parent = this.getParentType()) != null) {
            try {
                this.sourceField = parent.getDeclaredField(((Field)this.getTarget()).getName());
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return this.sourceField;
    }

    public Field getTargetField() {
        return (Field)this.getTarget();
    }

    public Object getValueIn(EObject object, EObject attribute) {
        return super.getValueIn(object, attribute);
    }

    public boolean reflectValues() {
        if (this.getSourceField() != null) {
            this.setModifiers();
            this.setType();
            this.setInitializerIfPossible();
            return true;
        }
        return false;
    }

    protected void setInitializerIfPossible() {
        if (!(this.getTargetField().isStatic() && this.getTargetField().isFinal() && "java.lang.String".equals(((JavaHelpers)this.getTargetField().getEType()).getQualifiedName()))) {
            return;
        }
        String value = null;
        try {
            value = (String)this.getSourceField().get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        if (value == null) {
            return;
        }
        value = "\"".concat(value).concat("\"");
        Block aBlock = this.createBlock(this.getTargetField().getName(), value);
        this.getTargetField().setInitializer(aBlock);
    }

    protected void setModifiers() {
        Field javaFieldTarget = (Field)this.getTarget();
        int modifiers = this.getSourceField().getModifiers();
        javaFieldTarget.setStatic(Modifier.isStatic(modifiers));
        javaFieldTarget.setTransient(Modifier.isTransient(modifiers));
        javaFieldTarget.setVolatile(Modifier.isVolatile(modifiers));
        javaFieldTarget.setFinal(Modifier.isFinal(modifiers));
        if (Modifier.isPublic(modifiers)) {
            javaFieldTarget.setJavaVisibility(JavaVisibilityKind.PUBLIC_LITERAL);
        } else if (Modifier.isPrivate(modifiers)) {
            javaFieldTarget.setJavaVisibility(JavaVisibilityKind.PRIVATE_LITERAL);
        } else if (Modifier.isProtected(modifiers)) {
            javaFieldTarget.setJavaVisibility(JavaVisibilityKind.PROTECTED_LITERAL);
        } else {
            javaFieldTarget.setJavaVisibility(JavaVisibilityKind.PACKAGE_LITERAL);
        }
    }

    protected void setType() {
        String typeName = JDKAdaptor.getTypeName(this.getSourceField().getType());
        this.setFieldType(this.getTargetField(), typeName);
    }
}

