/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.plugin;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.internal.java.adapters.JavaXMIFactoryImpl;
import org.eclipse.jem.internal.plugin.JavaPlugin;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.JavaProjectUtilities;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.util.emf.workbench.nature.EMFNature;

public class JavaEMFNature
extends EMFNature {
    public static final String NATURE_ID = "org.eclipse.jem.workbench.JavaEMFNature";

    public static JavaEMFNature createRuntime(IProject project) throws CoreException {
        if (!JavaEMFNature.hasRuntime(project)) {
            EMFNature.addNatureToProject((IProject)project, (String)NATURE_ID);
        }
        return JavaEMFNature.getRuntime(project);
    }

    public String getNatureID() {
        return NATURE_ID;
    }

    protected String getPluginID() {
        return JavaPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static JavaEMFNature getRuntime(IProject project) {
        JavaEMFNature nature = null;
        List runtimes = EMFNature.getRegisteredRuntimes((IProject)project);
        int i = 0;
        while (i < runtimes.size()) {
            if (runtimes.get(i) instanceof JavaEMFNature) {
                nature = (JavaEMFNature)((Object)runtimes.get(i));
            }
            ++i;
        }
        if (nature == null) {
            nature = JavaEMFNature.primGetRuntime(project);
        }
        return nature;
    }

    public static boolean hasRuntime(IProject project) {
        JavaEMFNature nature = null;
        List runtimes = EMFNature.getRegisteredRuntimes((IProject)project);
        int i = 0;
        while (i < runtimes.size()) {
            if (runtimes.get(i) instanceof JavaEMFNature) {
                nature = (JavaEMFNature)((Object)runtimes.get(i));
            }
            ++i;
        }
        if (nature == null) {
            return JavaEMFNature.primHasRuntime(project);
        }
        return true;
    }

    public static JavaEMFNature primGetRuntime(IProject project) {
        try {
            return (JavaEMFNature)project.getNature(NATURE_ID);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static boolean primHasRuntime(IProject project) {
        try {
            return project.hasNature(NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void primaryContributeToContext(EMFWorkbenchContextBase aNature) {
        if (this.emfContext == aNature) {
            return;
        }
        this.emfContext = aNature;
        ProjectResourceSet set = aNature.getResourceSet();
        set.getResourceFactoryRegistry().getProtocolToFactoryMap().put("java", JavaXMIFactoryImpl.INSTANCE);
        WorkbenchURIConverter conv = (WorkbenchURIConverter)set.getURIConverter();
        this.configureURIConverter(conv);
        this.addAdapterFactories((ResourceSet)set);
    }

    public void secondaryContributeToContext(EMFWorkbenchContextBase aNature) {
        this.primaryContributeToContext(aNature);
    }

    protected void configureURIConverter(WorkbenchURIConverter conv) {
        conv.removeInputContainer((IContainer)this.getProject());
        conv.addInputContainer(this.getEMFRoot());
    }

    protected void addAdapterFactories(ResourceSet aSet) {
        this.addJavaReflectionAdapterFactories(aSet);
    }

    protected void addJavaReflectionAdapterFactories(ResourceSet aSet) {
        AdapterFactory factory;
        EList factories = aSet.getAdapterFactories();
        if (!factories.isEmpty() && (factory = EcoreUtil.getAdapterFactory((List)factories, (Object)"JavaReflection")) != null) {
            factories.remove(factory);
        }
        factories.add(new JavaJDOMAdapterFactory(JavaProjectUtilities.getJavaProject((IProject)this.project)));
    }
}

