/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Statement;

public class PrimitiveOperation
extends Expression {
    protected int operation;
    protected Expression receiver;
    protected boolean isComplete = false;

    public PrimitiveOperation(Expression aReceiver, int anOperation) {
        this.receiver = aReceiver;
        this.operation = anOperation;
    }

    public Object evaluate() throws Exception {
        Object leftHandSide = this.receiver.evaluate();
        Object rightHandSide = this.currentExpression.evaluate();
        if (leftHandSide instanceof Integer && rightHandSide instanceof Integer) {
            if (this.operation == 124) {
                return new Integer((Integer)leftHandSide | (Integer)rightHandSide);
            }
            if (this.operation == 38) {
                return new Integer((Integer)leftHandSide & (Integer)rightHandSide);
            }
        }
        throw new RuntimeException("Invalid operator " + this.getOperDescription() + " between " + leftHandSide + " and " + rightHandSide);
    }

    protected String getOperDescription() {
        if (this.operation == 124) {
            return "|";
        }
        if (this.operation == 38) {
            return "&";
        }
        return "???";
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public Class getTypeClass() throws Exception {
        return Integer.TYPE;
    }

    protected String getTypeClassName() {
        return Integer.TYPE.getName();
    }

    public Expression push(char[] token, char tokenDelimiter) {
        Expression result;
        if (this.currentExpression == null && token.length > 0) {
            this.currentExpression = new Statement(this.fClassLoader).push(token, tokenDelimiter);
            this.pushExpressionStack(this.currentExpression);
            return this;
        }
        if (token.length == 0 && tokenDelimiter == ' ') {
            return this;
        }
        if (this.currentExpression != null && (result = this.currentExpression.push(token, tokenDelimiter)) != this.currentExpression) {
            this.pushExpressionStack(result);
        }
        if (this.currentExpression != null && this.currentExpression.isComplete()) {
            if (tokenDelimiter == ',') {
                this.isComplete = true;
                return this;
            }
            if (tokenDelimiter == ')') {
                if (this.receiver.parenthesisLevel > 0) {
                    --this.receiver.parenthesisLevel;
                } else {
                    this.isComplete = true;
                    return this;
                }
            }
        }
        return this;
    }

    public boolean isPrimitive() throws Exception {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.receiver != null) {
            buffer.append(this.receiver.toString());
        }
        buffer.append(this.getOperDescription());
        if (this.currentExpression != null) {
            buffer.append(this.currentExpression.toString());
        }
        return buffer.toString();
    }
}

