/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import org.eclipse.jem.internal.proxy.initParser.ArrayArguments;
import org.eclipse.jem.internal.proxy.initParser.Block;
import org.eclipse.jem.internal.proxy.initParser.BooleanLiteral;
import org.eclipse.jem.internal.proxy.initParser.Cast;
import org.eclipse.jem.internal.proxy.initParser.CharLiteral;
import org.eclipse.jem.internal.proxy.initParser.Constructor;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Field;
import org.eclipse.jem.internal.proxy.initParser.IParserConstants;
import org.eclipse.jem.internal.proxy.initParser.Message;
import org.eclipse.jem.internal.proxy.initParser.NullLiteral;
import org.eclipse.jem.internal.proxy.initParser.NumberLiteral;
import org.eclipse.jem.internal.proxy.initParser.ProxyInitParserMessages;
import org.eclipse.jem.internal.proxy.initParser.Static;
import org.eclipse.jem.internal.proxy.initParser.StringLiteral;

public class Statement
extends Expression {
    public boolean isStringObject = false;
    public boolean isCast = false;
    protected boolean messageOrFieldStarted;

    public Statement(ClassLoader aClassLoader) {
        this.fClassLoader = aClassLoader;
    }

    public boolean isComplete() {
        return this.currentExpression != null && this.currentExpression.isComplete();
    }

    public Object evaluate() throws Exception {
        if (this.currentExpression != null) {
            return this.currentExpression.evaluate();
        }
        throw new RuntimeException(ProxyInitParserMessages.getString("Statement.UnexpectedExecution_EXC_"));
    }

    public Class getTypeClass() throws Exception {
        return this.currentExpression.getTypeClass();
    }

    protected String getTypeClassName() {
        return this.currentExpression.getTypeClassName();
    }

    public Expression push(char[] token, char delimiter) {
        if (this.messageOrFieldStarted) {
            this.messageOrFieldStarted = false;
            if (delimiter == '(') {
                Message message = new Message(this.currentExpression, token, this.fClassLoader);
                this.currentExpression = message;
                return message;
            }
            Field field = new Field(this.currentExpression, token, this.fClassLoader);
            this.currentExpression = field;
            return field;
        }
        if (delimiter == ' ' && Expression.compare(token, IParserConstants.ConstantNew)) {
            this.currentExpression = this.isCast ? new Block(new Constructor(this.fClassLoader)) : new Constructor(this.fClassLoader);
            this.isCast = false;
            return this.currentExpression;
        }
        if (Expression.compare(token, IParserConstants.ConstantNull)) {
            this.currentExpression = new NullLiteral();
            this.isCast = false;
            return this;
        }
        if (this.isNumber(token) || delimiter == '-') {
            this.currentExpression = new NumberLiteral();
            this.currentExpression = this.currentExpression.push(token, delimiter);
            this.isCast = false;
            return this.currentExpression;
        }
        if (Expression.compare(token, IParserConstants.ConstantTrue)) {
            this.currentExpression = new BooleanLiteral(true);
            this.isCast = false;
            return this.currentExpression;
        }
        if (Expression.compare(token, IParserConstants.ConstantFalse)) {
            this.currentExpression = new BooleanLiteral(false);
            this.isCast = false;
            return this;
        }
        if (delimiter == '\"') {
            this.currentExpression = new StringLiteral();
            this.isCast = false;
            return this.currentExpression;
        }
        if (delimiter == '\'') {
            this.currentExpression = new CharLiteral();
            this.isCast = false;
            return this.currentExpression;
        }
        if (delimiter == '.' && token.length == 0 && this.currentExpression != null && this.currentExpression instanceof StringLiteral) {
            this.isStringObject = true;
            return this;
        }
        if (this.isStringObject && token.length > 0 && delimiter == '(') {
            return new Message(this.currentExpression, token, this.fClassLoader);
        }
        if (token.length == 0 && delimiter == '(') {
            if (this.isCast) {
                this.currentExpression = new Block(this.fClassLoader);
            } else {
                this.isCast = true;
            }
            return this;
        }
        if (this.isCast && (delimiter == ')' || token.length != 0)) {
            Static aStatic = new Static(this.fClassLoader);
            Cast aCast = new Cast(aStatic, this.fClassLoader);
            this.currentExpression = aCast.push(token, delimiter);
            return this.currentExpression;
        }
        if (token.length != 0) {
            this.currentExpression = new Static(this.fClassLoader).push(token, delimiter);
            return this.currentExpression;
        }
        if (delimiter == '{') {
            this.currentExpression = new ArrayArguments();
            return this.currentExpression;
        }
        if (this.currentExpression != null && this.currentExpression.isComplete() && delimiter == '.') {
            this.messageOrFieldStarted = true;
        }
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Statement{");
        if (this.currentExpression != null) {
            buffer.append(this.currentExpression.toString());
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean isPrimitive() throws Exception {
        if (this.currentExpression != null) {
            return this.currentExpression.isPrimitive();
        }
        throw new RuntimeException(ProxyInitParserMessages.getString("Statement.UnexpectedExecution_EXC_"));
    }
}

