/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IPDEContributeClasspath;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.DebugModeHelper;
import org.eclipse.jem.internal.proxy.remote.LocalFileConfigurationContributorController;
import org.eclipse.jem.internal.proxy.remote.LocalProxyLaunchDelegate;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteUtil;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.remote.awt.REMRegisterAWT;
import org.eclipse.jem.util.TimerTests;
import org.eclipse.jem.util.logger.proxy.Logger;

public class LocalProxyLaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final Random fgRandom = new Random(System.currentTimeMillis());

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor pm) throws CoreException {
        class StreamListener
        implements IStreamListener {
            String tracePrefix;
            Level level;
            final /* synthetic */ LocalProxyLaunchDelegate this$0;

            public StreamListener(LocalProxyLaunchDelegate localProxyLaunchDelegate, String type, Level level, String string) {
                this.this$0 = localProxyLaunchDelegate;
                this.tracePrefix = String.valueOf(string) + ':' + type + '>';
                this.level = level;
            }

            public void streamAppended(String newText, IStreamMonitor monitor) {
                Logger logger = ProxyPlugin.getPlugin().getLogger();
                if (logger.isLoggingLevel(this.level)) {
                    logger.log((Object)(String.valueOf(this.tracePrefix) + newText), this.level);
                }
            }
        }
        String launchKey = configuration.getAttribute("org.eclipse.jem.proxy.LaunchKey", null);
        if (launchKey == null) {
            this.abort(ProxyRemoteMessages.getString("ProxyRemoteNoLaunchKey"), null, 0);
        }
        if (ProxyLaunchSupport.ATTR_PRIVATE != null && configuration.getAttribute(ProxyLaunchSupport.ATTR_PRIVATE, false)) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        IJavaProject project = this.getJavaProject(configuration);
        String name = configuration.getAttribute("org.eclipse.jem.proxy.vmtitle", null);
        name = name == null ? MessageFormat.format(ProxyRemoteMessages.getString("ProxyRemoteVMName"), project != null ? project.getProject().getName() : "") : MessageFormat.format(ProxyRemoteMessages.getString("ProxyRemoteVMNameWithComment"), project != null ? project.getProject().getName() : "", name);
        String stepId = "Launch VM ( " + name + " )";
        TimerTests.basicTest.startStep(stepId);
        if (name.indexOf(34) != -1) {
            name = name.replace('\"', '\'');
        }
        pm.beginTask("", 500);
        pm.subTask(MessageFormat.format(ProxyRemoteMessages.getString("ProxyRemoteLaunchVM"), name));
        if (pm.isCanceled()) {
            return;
        }
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            this.abort(MessageFormat.format(ProxyRemoteMessages.getString("Proxy_NoRunner_ERROR_"), name), null, 0);
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        HashMap<String, String[]> vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        pm.worked(100);
        URL[] classpath = ProxyLaunchSupport.convertStringPathsToURL((String[])this.getClasspath(configuration));
        String[][] bootpathInfoStrings = this.getBootpathExt(vmAttributesMap);
        URL[][] bootpathInfo = new URL[][]{ProxyLaunchSupport.convertStringPathsToURL((String[])bootpathInfoStrings[0]), ProxyLaunchSupport.convertStringPathsToURL((String[])bootpathInfoStrings[1]), ProxyLaunchSupport.convertStringPathsToURL((String[])bootpathInfoStrings[2])};
        ProxyLaunchSupport.LaunchInfo launchInfo = ProxyLaunchSupport.getInfo((String)launchKey);
        final IConfigurationContributor[] contributors = launchInfo.contributors;
        final LocalFileConfigurationContributorController controller = new LocalFileConfigurationContributorController(classpath, bootpathInfo, launchInfo);
        if (contributors != null) {
            int i = 0;
            while (i < contributors.length) {
                final int ii = i++;
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        contributors[ii].contributeClasspaths((IConfigurationContributionController)controller);
                    }
                });
            }
        }
        ProxyRemoteUtil.updateClassPaths(controller);
        this.addInFragmentLibraries(controller);
        classpath = controller.getFinalClasspath();
        if (bootpathInfo[0] != controller.getFinalPrependBootpath()) {
            if (vmAttributesMap == null) {
                vmAttributesMap = new HashMap<String, String[]>(2);
            }
            vmAttributesMap.put(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_PREPEND, ProxyLaunchSupport.convertURLsToStrings((URL[])bootpathInfo[0]));
        }
        if (bootpathInfo[2] != controller.getFinalAppendBootpath()) {
            if (vmAttributesMap == null) {
                vmAttributesMap = new HashMap(2);
            }
            vmAttributesMap.put(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_APPEND, ProxyLaunchSupport.convertURLsToStrings((URL[])bootpathInfo[2]));
        }
        if (pm.isCanceled()) {
            return;
        }
        pm.worked(100);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration("org.eclipse.jem.internal.proxy.vm.remote.RemoteVMApplication", ProxyLaunchSupport.convertURLsToStrings((URL[])classpath));
        REMProxyFactoryRegistry registry = new REMProxyFactoryRegistry(ProxyRemoteUtil.getRegistryController(), name);
        Integer registryKey = registry.getRegistryKey();
        Integer bufSize = Integer.getInteger("proxyvm.bufsize");
        if (bufSize == null) {
            bufSize = new Integer(16000);
        }
        int masterServerPort = ProxyRemoteUtil.getRegistryController().getMasterSocketPort();
        DebugModeHelper dh = new DebugModeHelper();
        boolean debugMode = dh.debugMode(name);
        boolean useNoverify = ProxyPlugin.getPlugin().getPluginPreferences().getBoolean("JEM_PREFERENCES_VM_NOVERIFY_KEY");
        String[] evmArgs = execArgs.getVMArgumentsArray();
        int extraArgs = 4;
        if (debugMode) {
            extraArgs += 4;
        }
        if (useNoverify) {
            ++extraArgs;
        }
        List javaLibPaths = controller.getFinalJavaLibraryPath();
        int existingLibpaths = -1;
        if (!javaLibPaths.isEmpty()) {
            int i = 0;
            while (i < evmArgs.length) {
                if (evmArgs[i].startsWith("-Djava.library.path")) {
                    existingLibpaths = i;
                    break;
                }
                ++i;
            }
            if (existingLibpaths == -1) {
                ++extraArgs;
            }
        }
        String[] cvmArgs = new String[evmArgs.length + extraArgs];
        System.arraycopy(evmArgs, 0, cvmArgs, extraArgs, evmArgs.length);
        int cvmArgsCount = 0;
        cvmArgs[cvmArgsCount++] = "-Dproxyvm.registryKey=" + registryKey;
        cvmArgs[cvmArgsCount++] = "-Dproxyvm.masterPort=" + String.valueOf(masterServerPort);
        cvmArgs[cvmArgsCount++] = "-Dproxyvm.bufsize=" + bufSize;
        cvmArgs[cvmArgsCount++] = "-Dproxyvm.servername=" + name;
        if (useNoverify) {
            cvmArgs[cvmArgsCount++] = "-noverify";
        }
        int dport = -1;
        if (debugMode) {
            dport = LocalProxyLaunchDelegate.findUnusedLocalPort("localhost", 5000, 15000, new int[0]);
            cvmArgs[cvmArgsCount++] = "-Djava.compiler=NONE";
            cvmArgs[cvmArgsCount++] = "-Xdebug";
            cvmArgs[cvmArgsCount++] = "-Xnoagent";
            cvmArgs[cvmArgsCount++] = "-Xrunjdwp:transport=dt_socket,server=y,address=" + dport;
        }
        if (!javaLibPaths.isEmpty()) {
            StringBuffer appendTo = null;
            if (existingLibpaths != -1) {
                appendTo = new StringBuffer(evmArgs[existingLibpaths]);
                appendTo.append(File.pathSeparatorChar);
            } else {
                appendTo = new StringBuffer("-Djava.library.path=");
            }
            String[] libPaths = ProxyLaunchSupport.convertURLsToStrings((URL[])javaLibPaths.toArray(new URL[javaLibPaths.size()]));
            int i = 0;
            while (i < libPaths.length) {
                if (i != 0) {
                    appendTo.append(File.pathSeparator);
                }
                appendTo.append(libPaths[i]);
                ++i;
            }
            if (existingLibpaths != -1) {
                cvmArgs[extraArgs + existingLibpaths] = appendTo.toString();
            } else {
                cvmArgs[extraArgs - 1] = appendTo.toString();
            }
        }
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setEnvironment(envp);
        runConfig.setVMArguments(cvmArgs);
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setBootClassPath(this.getBootpath(configuration));
        if (pm.isCanceled()) {
            return;
        }
        pm.worked(100);
        this.setDefaultSourceLocator(launch, configuration);
        runner.run(runConfig, launch, (IProgressMonitor)new SubProgressMonitor(pm, 100));
        if (pm.isCanceled()) {
            return;
        }
        IProcess[] processes = launch.getProcesses();
        IProcess process = processes[0];
        if (process.isTerminated()) {
            IStreamsProxy stProxy = process.getStreamsProxy();
            StringWriter s = new StringWriter();
            PrintWriter w = new PrintWriter(s);
            w.println(ProxyRemoteMessages.getString("VM_TERMINATED_INFO_"));
            w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE1"));
            w.println(stProxy.getErrorStreamMonitor().getContents());
            w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE2"));
            w.println(stProxy.getOutputStreamMonitor().getContents());
            w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE3"));
            w.close();
            String msg = MessageFormat.format(ProxyRemoteMessages.getString("Proxy_Terminated_too_soon_ERROR_"), name);
            dh.displayErrorMessage(ProxyRemoteMessages.getString("Proxy_Error_Title"), msg);
            throw new CoreException((IStatus)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, s.toString(), null));
        }
        String traceName = name;
        IStreamsProxy fStreamsProxy = process.getStreamsProxy();
        IStreamMonitor monitor = fStreamsProxy.getErrorStreamMonitor();
        if (monitor != null) {
            monitor.addListener((IStreamListener)new StreamListener(this, "err", Level.WARNING, traceName));
        }
        if ("true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(ProxyPlugin.getPlugin().getBundle().getSymbolicName()) + "/remote/debug/vmtraceout"))) && (monitor = fStreamsProxy.getOutputStreamMonitor()) != null) {
            monitor.addListener((IStreamListener)new StreamListener(this, "out", Level.INFO, traceName));
        }
        if (debugMode && !dh.promptPort(dport)) {
            process.terminate();
            throw new CoreException((IStatus)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Debugger attach canceled", null));
        }
        registry.initializeRegistry(process);
        new REMStandardBeanTypeProxyFactory(registry);
        new REMStandardBeanProxyFactory(registry);
        new REMMethodProxyFactory(registry);
        if (debugMode || REMProxyFactoryRegistry.fGlobalNoTimeouts) {
            registry.fNoTimeouts = true;
        }
        if (configuration.getAttribute("org.eclipse.jem.proxy.AWT/Swing", true)) {
            REMRegisterAWT.registerAWT(registry);
        }
        launchInfo.resultRegistry = registry;
        pm.done();
        TimerTests.basicTest.stopStep(stepId);
    }

    private void addInFragmentLibraries(IConfigurationContributionController controller) throws CoreException {
        IPDEContributeClasspath instance = IPDEContributeClasspath.INSTANCE;
        if (instance != null) {
            instance.getPDEContributions(controller);
        }
    }

    private static int findUnusedLocalPort(String host, int searchFrom, int searchTo, int[] exclude) {
        int i = 0;
        while (i < 10) {
            int port = 0;
            block4: while (true) {
                port = LocalProxyLaunchDelegate.getRandomPort(searchFrom, searchTo);
                if (exclude == null) break;
                int e = 0;
                while (e < exclude.length) {
                    if (port == exclude[e]) continue block4;
                    ++e;
                }
                break;
            }
            try {
                new Socket(host, port);
            }
            catch (ConnectException connectException) {
                return port;
            }
            catch (IOException iOException) {}
            ++i;
        }
        return -1;
    }

    private static int getRandomPort(int low, int high) {
        return (int)(fgRandom.nextFloat() * (float)(high - low)) + low;
    }

    private String[][] getBootpathExt(Map vmMap) {
        String[][] ext = new String[3][];
        if (vmMap != null) {
            ext[0] = (String[])vmMap.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_PREPEND);
            ext[1] = (String[])vmMap.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH);
            ext[2] = (String[])vmMap.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_APPEND);
        }
        return ext;
    }
}

