/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.TransmitableArray;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

public abstract class REMAbstractBeanTypeProxy
implements IREMBeanTypeProxy {
    private Integer fID;
    protected final REMProxyFactoryRegistry fRegistry;
    protected final String fClassname;
    private IBeanTypeProxy fSuperType;

    protected REMAbstractBeanTypeProxy(REMProxyFactoryRegistry aRegistry, Integer anID, String aClassname, IBeanTypeProxy aSuperType) {
        this.fRegistry = aRegistry;
        this.fID = anID;
        this.fClassname = aClassname;
        this.fSuperType = aSuperType;
    }

    public boolean equals(Object anObject) {
        return super.equals(anObject);
    }

    public boolean sameAs(IBeanProxy aBeanProxy) {
        return this == aBeanProxy;
    }

    public Integer getID() {
        return this.fID;
    }

    public boolean isValid() {
        return this.fID != null;
    }

    public void release() {
        this.fID = null;
        this.fSuperType = null;
    }

    public IConstructorProxy getConstructorProxy(String[] argumentClassNames) {
        if (this.isInterface()) {
            return null;
        }
        IBeanTypeProxy[] argTypes = null;
        if (argumentClassNames != null) {
            IStandardBeanTypeProxyFactory typeFactory = this.fRegistry.getBeanTypeProxyFactory();
            argTypes = new IBeanTypeProxy[argumentClassNames.length];
            int i = 0;
            while (i < argumentClassNames.length) {
                argTypes[i] = typeFactory.getBeanTypeProxy(argumentClassNames[i]);
                IBeanTypeProxy type = argTypes[i];
                if (type == null) {
                    return null;
                }
                ++i;
            }
        }
        return this.getConstructorProxy(argTypes);
    }

    public IConstructorProxy getConstructorProxy(IBeanTypeProxy[] argumentTypes) {
        Object[] objectArray;
        if (this.isInterface()) {
            return null;
        }
        IREMMethodProxy getCtorMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassConstructor();
        if (argumentTypes != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = new TransmitableArray(22, (Object[])argumentTypes);
        } else {
            objectArray = null;
        }
        Object[] getParms = objectArray;
        try {
            return (IConstructorProxy)getCtorMethod.invokeWithParms(this, getParms);
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IConstructorProxy[] getConstructors() {
        if (this.isInterface()) {
            return null;
        }
        IREMMethodProxy getCtorMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassConstructors();
        try {
            IArrayBeanProxy ctors = (IArrayBeanProxy)getCtorMethod.invokeWithParms(this, null);
            IBeanProxy[] proxies = ctors.getSnapshot();
            IConstructorProxy[] ctorproxies = new IConstructorProxy[proxies.length];
            System.arraycopy(proxies, 0, ctorproxies, 0, proxies.length);
            return ctorproxies;
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IConstructorProxy getDeclaredConstructorProxy(String[] argumentClassNames) {
        if (this.isInterface()) {
            return null;
        }
        IBeanTypeProxy[] argTypes = null;
        if (argumentClassNames != null) {
            IStandardBeanTypeProxyFactory typeFactory = this.fRegistry.getBeanTypeProxyFactory();
            argTypes = new IBeanTypeProxy[argumentClassNames.length];
            int i = 0;
            while (i < argumentClassNames.length) {
                argTypes[i] = typeFactory.getBeanTypeProxy(argumentClassNames[i]);
                IBeanTypeProxy type = argTypes[i];
                if (type == null) {
                    return null;
                }
                ++i;
            }
        }
        return this.getDeclaredConstructorProxy(argTypes);
    }

    public IConstructorProxy getDeclaredConstructorProxy(IBeanTypeProxy[] argumentTypes) {
        Object[] objectArray;
        if (this.isInterface()) {
            return null;
        }
        IREMMethodProxy getCtorMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getDeclaredClassConstructor();
        if (argumentTypes != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = new TransmitableArray(22, (Object[])argumentTypes);
        } else {
            objectArray = null;
        }
        Object[] getParms = objectArray;
        try {
            return (IConstructorProxy)getCtorMethod.invokeWithParms(this, getParms);
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IConstructorProxy[] getDeclaredConstructors() {
        if (this.isInterface()) {
            return null;
        }
        IREMMethodProxy getCtorMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getDeclaredClassConstructors();
        try {
            IArrayBeanProxy ctors = (IArrayBeanProxy)getCtorMethod.invokeWithParms(this, null);
            IBeanProxy[] proxies = ctors.getSnapshot();
            IConstructorProxy[] ctorproxies = new IConstructorProxy[proxies.length];
            System.arraycopy(proxies, 0, ctorproxies, 0, proxies.length);
            return ctorproxies;
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IFieldProxy[] getFields() {
        IREMMethodProxy getFieldsMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassGetFields();
        try {
            IArrayBeanProxy fields = (IArrayBeanProxy)getFieldsMethod.invokeWithParms(this, null);
            IBeanProxy[] proxies = fields.getSnapshot();
            IFieldProxy[] fieldProxies = new IFieldProxy[proxies.length];
            System.arraycopy(proxies, 0, fieldProxies, 0, proxies.length);
            return fieldProxies;
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IFieldProxy[] getDeclaredFields() {
        IREMMethodProxy getDeclaredFieldsMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassGetDeclaredFields();
        try {
            IArrayBeanProxy fields = (IArrayBeanProxy)getDeclaredFieldsMethod.invokeWithParms(this, null);
            IBeanProxy[] proxies = fields.getSnapshot();
            IFieldProxy[] fieldProxies = new IFieldProxy[proxies.length];
            System.arraycopy(proxies, 0, fieldProxies, 0, proxies.length);
            return fieldProxies;
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IFieldProxy getDeclaredFieldProxy(String fieldName) {
        return (IFieldProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassGetDeclaredField().invokeCatchThrowableExceptions((IBeanProxy)this, (IBeanProxy)this.fRegistry.getBeanProxyFactory().createBeanProxyWith(fieldName));
    }

    public IFieldProxy getFieldProxy(String fieldName) {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).proxyConstants.getFieldProxy(this, fieldName);
    }

    public IMethodProxy[] getMethods() {
        IREMMethodProxy getMethodsMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassMethods();
        try {
            IArrayBeanProxy methods = (IArrayBeanProxy)getMethodsMethod.invokeWithParms(this, null);
            IBeanProxy[] proxies = methods.getSnapshot();
            IMethodProxy[] methodProxies = new IMethodProxy[proxies.length];
            System.arraycopy(proxies, 0, methodProxies, 0, proxies.length);
            return methodProxies;
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IMethodProxy[] getDeclaredMethods() {
        IREMMethodProxy getDeclaredMethodsMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassDeclaredMethods();
        try {
            IArrayBeanProxy methods = (IArrayBeanProxy)getDeclaredMethodsMethod.invokeWithParms(this, null);
            IBeanProxy[] proxies = methods.getSnapshot();
            IMethodProxy[] methodProxies = new IMethodProxy[proxies.length];
            System.arraycopy(proxies, 0, methodProxies, 0, proxies.length);
            return methodProxies;
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IMethodProxy getMethodProxy(String methodName) {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).proxyConstants.getMethodProxy((IBeanTypeProxy)this, methodName, (String[])null);
    }

    public IMethodProxy getMethodProxy(String methodName, String[] argumentClassNames) {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).proxyConstants.getMethodProxy((IBeanTypeProxy)this, methodName, argumentClassNames);
    }

    public IMethodProxy getMethodProxy(String methodName, String argumentQualifiedTypeName) {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).proxyConstants.getMethodProxy((IBeanTypeProxy)this, methodName, new String[]{argumentQualifiedTypeName});
    }

    public IMethodProxy getMethodProxy(String methodName, IBeanTypeProxy[] argumentTypes) {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).proxyConstants.getMethodProxy((IBeanTypeProxy)this, methodName, argumentTypes);
    }

    public IMethodProxy getDeclaredMethodProxy(String methodName, String[] argumentClassNames) {
        IBeanTypeProxy[] argTypes = null;
        if (argumentClassNames != null) {
            IStandardBeanTypeProxyFactory typeFactory = this.fRegistry.getBeanTypeProxyFactory();
            argTypes = new IBeanTypeProxy[argumentClassNames.length];
            int i = 0;
            while (i < argumentClassNames.length) {
                argTypes[i] = typeFactory.getBeanTypeProxy(argumentClassNames[i]);
                IBeanTypeProxy type = argTypes[i];
                if (type == null) {
                    return null;
                }
                ++i;
            }
        }
        return this.getDeclaredMethodProxy(methodName, argTypes);
    }

    public IMethodProxy getDeclaredMethodProxy(String methodName, IBeanTypeProxy[] argumentTypes) {
        Object[] objectArray;
        IREMMethodProxy getDeclaredMethodMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassDeclaredMethod();
        IStringBeanProxy nameProxy = this.fRegistry.getBeanProxyFactory().createBeanProxyWith(methodName);
        if (argumentTypes != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = nameProxy;
            objectArray = objectArray2;
            objectArray2[1] = new TransmitableArray(22, (Object[])argumentTypes);
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray3[0] = nameProxy;
        }
        Object[] getParms = objectArray;
        try {
            return (IMethodProxy)getDeclaredMethodMethod.invokeWithParms(this, getParms);
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IInvokable getInvokable(String methodName) {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).proxyConstants.getInvokable((IBeanTypeProxy)this, methodName, (String[])null);
    }

    public IInvokable getInvokable(String methodName, String[] argumentClassNames) {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).proxyConstants.getInvokable((IBeanTypeProxy)this, methodName, argumentClassNames);
    }

    public IInvokable getInvokable(String methodName, String argumentQualifiedTypeName) {
        return this.getInvokable(methodName, new String[]{argumentQualifiedTypeName});
    }

    public IInvokable getInvokable(String methodName, IBeanTypeProxy[] argumentTypes) {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).proxyConstants.getInvokable((IBeanTypeProxy)this, methodName, argumentTypes);
    }

    public IConstructorProxy getNullConstructorProxy() {
        return this.getConstructorProxy((IBeanTypeProxy[])null);
    }

    public ProxyFactoryRegistry getProxyFactoryRegistry() {
        return this.fRegistry;
    }

    public IBeanTypeProxy getSuperBeanTypeProxy() {
        return this.fSuperType;
    }

    public String getTypeName() {
        return this.fClassname;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isKindOf(IBeanTypeProxy aBeanProxyType) {
        return ((IBooleanBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassIsAssignableFrom().invokeCatchThrowableExceptions((IBeanProxy)aBeanProxyType, (IBeanProxy)this)).booleanValue();
    }

    public IBeanProxy newInstance(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        try {
            return ((REMStandardBeanProxyFactory)this.fRegistry.getBeanProxyFactory()).createBeanProxy(this, initializationString);
        }
        catch (CommandException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return null;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.getTypeName() + ")";
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).classClass;
    }

    public String toBeanString() {
        return this.getTypeName();
    }

    public IBeanProxy newInstance() throws ThrowableProxy {
        return ((REMStandardBeanProxyFactory)this.fRegistry.getBeanProxyFactory()).createBeanProxy(this);
    }

    public void renderBean(Commands.ValueObject value) {
        value.setObjectID(this.getID().intValue());
    }

    public String getFormalTypeName() {
        return this.getTypeName();
    }

    public String getInitializationError() {
        return null;
    }

    public IConstructorProxy getCompatibleConstructor(IBeanTypeProxy[] argumentTypes) throws NoSuchMethodException, AmbiguousMethodException {
        Object[] objectArray;
        if (this.isInterface()) {
            return null;
        }
        IREMMethodProxy findCompatibleMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getFindCompatibleConstructorMethod();
        if (argumentTypes != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this;
            objectArray = objectArray2;
            objectArray2[1] = new TransmitableArray(22, (Object[])argumentTypes);
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray3[0] = this;
        }
        Object[] getParms = objectArray;
        try {
            return (IConstructorProxy)findCompatibleMethod.invokeWithParms(this, getParms);
        }
        catch (ThrowableProxy e) {
            IConstructorProxy iConstructorProxy;
            try {
                if (e.getTypeProxy().equals((Object)this.fRegistry.getBeanTypeProxyFactory().getBeanTypeProxy("java.lang.NoSuchMethodException"))) {
                    throw new NoSuchMethodException(e.getProxyLocalizedMessage());
                }
                if (e.getTypeProxy().equals((Object)this.fRegistry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.jem.internal.proxy.common.AmbiguousMethodException"))) {
                    throw new AmbiguousMethodException(e.getProxyLocalizedMessage());
                }
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                iConstructorProxy = null;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.fRegistry.releaseProxy((IBeanProxy)e);
                throw throwable;
            }
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return iConstructorProxy;
        }
    }

    public IMethodProxy getCompatibleMethod(String methodName, IBeanTypeProxy[] argumentTypes) throws NoSuchMethodException, AmbiguousMethodException {
        Object[] objectArray;
        IREMMethodProxy findCompatibleMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getFindCompatibleMethodMethod();
        IStringBeanProxy methodNameProxy = this.fRegistry.getBeanProxyFactory().createBeanProxyWith(methodName);
        if (argumentTypes != null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this;
            objectArray2[1] = methodNameProxy;
            objectArray = objectArray2;
            objectArray2[2] = new TransmitableArray(22, (Object[])argumentTypes);
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = this;
            objectArray = objectArray3;
            objectArray3[1] = methodNameProxy;
        }
        Object[] getParms = objectArray;
        try {
            return (IMethodProxy)findCompatibleMethod.invokeWithParms(this, getParms);
        }
        catch (ThrowableProxy e) {
            IMethodProxy iMethodProxy;
            try {
                if (e.getTypeProxy().equals((Object)this.fRegistry.getBeanTypeProxyFactory().getBeanTypeProxy("java.lang.NoSuchMethodException"))) {
                    throw new NoSuchMethodException(e.getProxyLocalizedMessage());
                }
                if (e.getTypeProxy().equals((Object)this.fRegistry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.jem.internal.proxy.common.AmbiguousMethodException"))) {
                    throw new AmbiguousMethodException(e.getProxyLocalizedMessage());
                }
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                iMethodProxy = null;
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.fRegistry.releaseProxy((IBeanProxy)e);
                throw throwable;
            }
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return iMethodProxy;
        }
    }
}

