/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.instantiation.base;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.internal.instantiation.PTArrayAccess;
import org.eclipse.jem.internal.instantiation.PTArrayCreation;
import org.eclipse.jem.internal.instantiation.PTArrayInitializer;
import org.eclipse.jem.internal.instantiation.PTBooleanLiteral;
import org.eclipse.jem.internal.instantiation.PTCastExpression;
import org.eclipse.jem.internal.instantiation.PTCharacterLiteral;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTConditionalExpression;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInfixExpression;
import org.eclipse.jem.internal.instantiation.PTInfixOperator;
import org.eclipse.jem.internal.instantiation.PTInstanceof;
import org.eclipse.jem.internal.instantiation.PTInvalidExpression;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.PTNullLiteral;
import org.eclipse.jem.internal.instantiation.PTNumberLiteral;
import org.eclipse.jem.internal.instantiation.PTParenthesizedExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixOperator;
import org.eclipse.jem.internal.instantiation.PTStringLiteral;
import org.eclipse.jem.internal.instantiation.PTThisLiteral;
import org.eclipse.jem.internal.instantiation.PTTypeLiteral;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.base.InstantiationBaseMessages;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.IExpressionConstants;

public class ParseTreeAllocationInstantiationVisitor
extends ParseVisitor {
    private ProxyFactoryRegistry registry;
    private IExpression expression;
    private int nextExpression = 0;
    static final int[] INFIXTOPROXY = new int[PTInfixOperator.VALUES.size()];
    static final int[] PREFIXTOPROXY;

    static {
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[15] = 15;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[17] = 17;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[18] = 18;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[1] = 1;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[12] = 12;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[9] = 9;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[11] = 11;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[5] = 5;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[8] = 8;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[10] = 10;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[4] = 4;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[13] = 13;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[16] = 16;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[3] = 3;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[2] = 2;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[6] = 6;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[7] = 7;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[0] = 0;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[14] = 14;
        PREFIXTOPROXY = new int[PTPrefixOperator.VALUES.size()];
        ParseTreeAllocationInstantiationVisitor.PREFIXTOPROXY[2] = 2;
        ParseTreeAllocationInstantiationVisitor.PREFIXTOPROXY[1] = 1;
        ParseTreeAllocationInstantiationVisitor.PREFIXTOPROXY[3] = 3;
        ParseTreeAllocationInstantiationVisitor.PREFIXTOPROXY[0] = 0;
    }

    public static int convertPTInfixOperatorToProxyInfixOperator(PTInfixOperator operator) {
        return INFIXTOPROXY[operator.getValue()];
    }

    public static int convertPTPrefixOperatorToProxyPrefixOperator(PTPrefixOperator operator) {
        return PREFIXTOPROXY[operator.getValue()];
    }

    protected final ProxyFactoryRegistry getRegistry() {
        return this.registry;
    }

    protected final IExpression getExpression() {
        return this.expression;
    }

    public IBeanProxy getBeanProxy(PTExpression expression, ProxyFactoryRegistry registry) throws IllegalStateException, IllegalArgumentException, ThrowableProxy, IExpressionConstants.NoExpressionValueException, ProcessingException {
        this.registry = registry;
        this.expression = registry.getBeanProxyFactory().createExpression();
        this.setNextExpression(0);
        try {
            expression.accept(this);
        }
        catch (ProcessingException e) {
            Throwable t = e.getCause();
            if (t instanceof ThrowableProxy) {
                throw (ThrowableProxy)t;
            }
            if (t instanceof IExpressionConstants.NoExpressionValueException) {
                throw (IExpressionConstants.NoExpressionValueException)t;
            }
            throw e;
        }
        return this.getExpression().getExpressionValue();
    }

    protected final void setNextExpression(int nextExpression) {
        this.nextExpression = nextExpression;
    }

    protected final int getNextExpression() {
        return this.nextExpression;
    }

    public boolean visit(PTArrayAccess node) {
        try {
            this.getExpression().createArrayAccess(this.getNextExpression(), node.getIndexes().size());
            this.setNextExpression(1);
            node.getArray().accept(this);
            EList idx = node.getIndexes();
            int s = idx.size();
            int i = 0;
            while (i < s) {
                this.setNextExpression(2);
                ((PTExpression)idx.get(i)).accept(this);
                ++i;
            }
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTArrayCreation node) {
        try {
            this.getExpression().createArrayCreation(this.getNextExpression(), node.getType(), node.getDimensions().size());
            if (node.getDimensions().isEmpty()) {
                node.getInitializer().accept(this);
            } else {
                EList dims = node.getDimensions();
                int s = dims.size();
                int i = 0;
                while (i < s) {
                    this.setNextExpression(3);
                    ((PTExpression)dims.get(i)).accept(this);
                    ++i;
                }
            }
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTArrayInitializer node) {
        try {
            this.getExpression().createArrayInitializer(node.getExpressions().size());
            EList exps = node.getExpressions();
            int s = exps.size();
            int i = 0;
            while (i < s) {
                this.setNextExpression(4);
                ((PTExpression)exps.get(i)).accept(this);
                ++i;
            }
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTBooleanLiteral node) {
        try {
            this.getExpression().createPrimitiveLiteral(this.getNextExpression(), node.isBooleanValue());
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTCastExpression node) {
        try {
            this.getExpression().createCastExpression(this.getNextExpression(), node.getType());
            this.setNextExpression(5);
            node.getExpression().accept(this);
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTCharacterLiteral node) {
        try {
            this.getExpression().createPrimitiveLiteral(this.getNextExpression(), node.getCharValue());
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTClassInstanceCreation node) {
        try {
            this.getExpression().createClassInstanceCreation(this.getNextExpression(), node.getType(), node.getArguments().size());
            EList args = node.getArguments();
            int s = args.size();
            int i = 0;
            while (i < s) {
                this.setNextExpression(6);
                ((PTExpression)args.get(i)).accept(this);
                ++i;
            }
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTConditionalExpression node) {
        try {
            this.getExpression().createConditionalExpression(this.getNextExpression());
            this.setNextExpression(7);
            node.getCondition().accept(this);
            this.setNextExpression(8);
            node.getTrue().accept(this);
            this.setNextExpression(9);
            node.getFalse().accept(this);
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTFieldAccess node) {
        try {
            this.getExpression().createFieldAccess(this.getNextExpression(), node.getField(), node.getReceiver() != null);
            if (node.getReceiver() != null) {
                this.setNextExpression(10);
                node.getReceiver().accept(this);
            }
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTInfixExpression node) {
        try {
            this.getExpression().createInfixExpression(this.getNextExpression(), ParseTreeAllocationInstantiationVisitor.convertPTInfixOperatorToProxyInfixOperator(node.getOperator()), node.getExtendedOperands().size());
            this.setNextExpression(11);
            node.getLeftOperand().accept(this);
            this.setNextExpression(12);
            node.getRightOperand().accept(this);
            EList extended = node.getExtendedOperands();
            int s = extended.size();
            int i = 0;
            while (i < s) {
                this.setNextExpression(13);
                ((PTExpression)extended.get(i)).accept(this);
                ++i;
            }
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTInstanceof node) {
        try {
            this.getExpression().createInstanceofExpression(this.getNextExpression(), node.getType());
            this.setNextExpression(14);
            node.getOperand().accept(this);
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTInvalidExpression node) {
        throw new IllegalArgumentException(node.getMessage());
    }

    public boolean visit(PTMethodInvocation node) {
        try {
            this.getExpression().createMethodInvocation(this.getNextExpression(), node.getName(), node.getReceiver() != null, node.getArguments().size());
            if (node.getReceiver() != null) {
                this.setNextExpression(15);
                node.getReceiver().accept(this);
            }
            EList args = node.getArguments();
            int s = args.size();
            int i = 0;
            while (i < s) {
                this.setNextExpression(16);
                ((PTExpression)args.get(i)).accept(this);
                ++i;
            }
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTName node) {
        try {
            this.getExpression().createTypeReceiver(node.getName());
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTNullLiteral node) {
        try {
            this.getExpression().createNull(this.getNextExpression());
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTNumberLiteral node) {
        try {
            String lit = node.getToken();
            char lastChar = lit.charAt(lit.length() - 1);
            if (lastChar == 'l' || lastChar == 'L') {
                this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Long.decode(lit.substring(0, lit.length() - 1)).longValue());
            } else if (lastChar == 'F' || lastChar == 'f') {
                this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Float.parseFloat(lit.substring(0, lit.length() - 1)));
            } else if (lastChar == 'D' || lastChar == 'd') {
                this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Double.parseDouble(lit.substring(0, lit.length() - 1)));
            } else if (lit.indexOf(46) != -1 || lit.indexOf(101) != -1 || lit.indexOf(69) != -1) {
                this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Double.parseDouble(lit.substring(0, lit.length())));
            } else {
                this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Integer.decode(lit).intValue());
            }
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTParenthesizedExpression node) {
        node.getExpression().accept(this);
        return false;
    }

    public boolean visit(PTPrefixExpression node) {
        try {
            this.getExpression().createPrefixExpression(this.getNextExpression(), ParseTreeAllocationInstantiationVisitor.convertPTPrefixOperatorToProxyPrefixOperator(node.getOperator()));
            this.setNextExpression(17);
            node.getExpression().accept(this);
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTStringLiteral node) {
        try {
            this.getExpression().createProxyExpression(this.getNextExpression(), (IBeanProxy)this.getRegistry().getBeanProxyFactory().createBeanProxyWith(node.getLiteralValue()));
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public boolean visit(PTThisLiteral node) {
        throw new IllegalArgumentException(InstantiationBaseMessages.getString("ParseTreeAllocationInstantiationVisitor.CurrentlyThisNotSupported_EXC_"));
    }

    public boolean visit(PTTypeLiteral node) {
        try {
            this.getExpression().createTypeLiteral(this.getNextExpression(), node.getType());
        }
        catch (ThrowableProxy e) {
            throw new ProcessingException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new ProcessingException(e);
        }
        return false;
    }

    public static class ProcessingException
    extends RuntimeException {
        public ProcessingException(Throwable cause) {
            super(cause);
        }
    }
}

