/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.MapTypes;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDEArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBigDecimalBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBigIntegerBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBooleanClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBooleanTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEByteClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEByteTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDECharTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDECharacterClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEDoubleClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEDoubleTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEExtensionBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEFloatClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEFloatTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEInitErrorBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEIntegerClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEIntegerTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDELongClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDELongTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEShortClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEShortTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEStringBeanTypeProxy;

public class IDEStandardBeanTypeProxyFactory
implements IStandardBeanTypeProxyFactory {
    protected final IDEProxyFactoryRegistry fFactoryRegistry;
    protected Map beanProxies;
    public static Map MAP_SHORTSIG_TO_TYPE = new HashMap(8);
    public static Map MAP_TYPENAME_TO_SHORTSIG = new HashMap(8);
    IDEBeanTypeProxy objectClass;
    IDEBooleanTypeBeanTypeProxy booleanType;
    IDEBooleanClassBeanTypeProxy booleanClass;
    IDEIntegerTypeBeanTypeProxy intType;
    IDEIntegerClassBeanTypeProxy integerClass;
    IDEFloatTypeBeanTypeProxy floatType;
    IDEFloatClassBeanTypeProxy floatClass;
    IDELongTypeBeanTypeProxy longType;
    IDELongClassBeanTypeProxy longClass;
    IDEShortTypeBeanTypeProxy shortType;
    IDEShortClassBeanTypeProxy shortClass;
    IDEByteTypeBeanTypeProxy byteType;
    IDEByteClassBeanTypeProxy byteClass;
    IDECharTypeBeanTypeProxy charType;
    IDECharacterClassBeanTypeProxy charClass;
    IDEDoubleTypeBeanTypeProxy doubleType;
    IDEDoubleClassBeanTypeProxy doubleClass;
    IDEStringBeanTypeProxy stringClass;
    IDEClassBeanTypeProxy classClass;
    IDEBeanTypeProxy voidType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    static {
        MAP_SHORTSIG_TO_TYPE.put("B", Byte.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("C", Character.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("D", Double.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("F", Float.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("I", Integer.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("J", Long.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("S", Short.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("Z", Boolean.TYPE);
        MAP_TYPENAME_TO_SHORTSIG.put("byte", "B");
        MAP_TYPENAME_TO_SHORTSIG.put("char", "C");
        MAP_TYPENAME_TO_SHORTSIG.put("double", "D");
        MAP_TYPENAME_TO_SHORTSIG.put("float", "F");
        MAP_TYPENAME_TO_SHORTSIG.put("int", "I");
        MAP_TYPENAME_TO_SHORTSIG.put("long", "J");
        MAP_TYPENAME_TO_SHORTSIG.put("short", "S");
        MAP_TYPENAME_TO_SHORTSIG.put("boolean", "Z");
    }

    public IDEStandardBeanTypeProxyFactory(IDEProxyFactoryRegistry aRegistry) {
        this.fFactoryRegistry = aRegistry;
        aRegistry.registerBeanTypeProxyFactory(this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.objectClass = new IDEBeanTypeProxy(this.fFactoryRegistry, clazz);
        this.booleanType = new IDEBooleanTypeBeanTypeProxy(this.fFactoryRegistry, Boolean.TYPE);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.booleanClass = new IDEBooleanClassBeanTypeProxy(this.fFactoryRegistry, clazz2);
        this.intType = new IDEIntegerTypeBeanTypeProxy(this.fFactoryRegistry, Integer.TYPE);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.integerClass = new IDEIntegerClassBeanTypeProxy(this.fFactoryRegistry, clazz3);
        this.floatType = new IDEFloatTypeBeanTypeProxy(this.fFactoryRegistry, Float.TYPE);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.floatClass = new IDEFloatClassBeanTypeProxy(this.fFactoryRegistry, clazz4);
        this.longType = new IDELongTypeBeanTypeProxy(this.fFactoryRegistry, Long.TYPE);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.longClass = new IDELongClassBeanTypeProxy(this.fFactoryRegistry, clazz5);
        this.shortType = new IDEShortTypeBeanTypeProxy(this.fFactoryRegistry, Short.TYPE);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.shortClass = new IDEShortClassBeanTypeProxy(this.fFactoryRegistry, clazz6);
        this.byteType = new IDEByteTypeBeanTypeProxy(this.fFactoryRegistry, Byte.TYPE);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.byteClass = new IDEByteClassBeanTypeProxy(this.fFactoryRegistry, clazz7);
        this.charType = new IDECharTypeBeanTypeProxy(this.fFactoryRegistry, Character.TYPE);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.charClass = new IDECharacterClassBeanTypeProxy(this.fFactoryRegistry, clazz8);
        this.doubleType = new IDEDoubleTypeBeanTypeProxy(this.fFactoryRegistry, Double.TYPE);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.doubleClass = new IDEDoubleClassBeanTypeProxy(this.fFactoryRegistry, clazz9);
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.stringClass = new IDEStringBeanTypeProxy(this.fFactoryRegistry, clazz10);
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classClass = new IDEClassBeanTypeProxy(this.fFactoryRegistry, clazz11);
        this.voidType = new IDEBeanTypeProxy(this.fFactoryRegistry, Void.TYPE);
        this.beanProxies = new HashMap(20);
        this.beanProxies.put(this.intType.getTypeName(), this.intType);
        this.beanProxies.put(this.booleanType.getTypeName(), this.booleanType);
        this.beanProxies.put(this.charType.getTypeName(), this.charType);
        this.beanProxies.put(this.byteType.getTypeName(), this.byteType);
        this.beanProxies.put(this.shortType.getTypeName(), this.shortType);
        this.beanProxies.put(this.longType.getTypeName(), this.longType);
        this.beanProxies.put(this.floatType.getTypeName(), this.floatType);
        this.beanProxies.put(this.doubleType.getTypeName(), this.doubleType);
        this.beanProxies.put(this.integerClass.getTypeName(), this.integerClass);
        this.beanProxies.put(this.booleanClass.getTypeName(), this.booleanClass);
        this.beanProxies.put(this.charClass.getTypeName(), this.charClass);
        this.beanProxies.put(this.byteClass.getTypeName(), this.byteClass);
        this.beanProxies.put(this.shortClass.getTypeName(), this.shortClass);
        this.beanProxies.put(this.longClass.getTypeName(), this.longClass);
        this.beanProxies.put(this.floatClass.getTypeName(), this.floatClass);
        this.beanProxies.put(this.doubleClass.getTypeName(), this.doubleClass);
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = clazz12.getName();
        Class<?> clazz13 = class$11;
        if (clazz13 == null) {
            try {
                clazz13 = class$11 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.beanProxies.put(string, new IDEBigDecimalBeanTypeProxy(this.fFactoryRegistry, clazz13));
        Class<?> clazz14 = class$12;
        if (clazz14 == null) {
            try {
                clazz14 = class$12 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string2 = clazz14.getName();
        Class<?> clazz15 = class$12;
        if (clazz15 == null) {
            try {
                clazz15 = class$12 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.beanProxies.put(string2, new IDEBigIntegerBeanTypeProxy(this.fFactoryRegistry, clazz15));
        this.beanProxies.put(this.stringClass.getTypeName(), this.stringClass);
        this.beanProxies.put(this.classClass.getTypeName(), this.classClass);
        this.beanProxies.put(this.voidType.getTypeName(), this.voidType);
    }

    IBeanTypeProxy getBeanTypeProxy(Class anIDEClass) {
        return this.getBeanTypeProxy(anIDEClass.getName());
    }

    public synchronized IBeanTypeProxy getBeanTypeProxy(String typeName) {
        IBeanTypeProxy beanTypeProxy = (IBeanTypeProxy)this.beanProxies.get(typeName = MapTypes.getJNIFormatName((String)typeName));
        if (beanTypeProxy != null) {
            return beanTypeProxy;
        }
        if (typeName.charAt(0) != '[') {
            String msg;
            String packageName;
            IDEExtensionBeanTypeProxyFactory packageFactory;
            int packageIndex = typeName.lastIndexOf(46);
            if (packageIndex != -1 && (packageFactory = (IDEExtensionBeanTypeProxyFactory)this.fFactoryRegistry.getBeanTypeProxyFactoryExtension(packageName = typeName.substring(0, packageIndex))) != null && (beanTypeProxy = packageFactory.getExtensionBeanTypeProxy(typeName)) != null) {
                this.registerBeanTypeProxy(beanTypeProxy, false);
                return beanTypeProxy;
            }
            try {
                Class ideClass = this.fFactoryRegistry.loadClass(typeName);
                IDEBeanTypeProxy superTypeProxy = null;
                if (ideClass.getSuperclass() != null) {
                    superTypeProxy = (IDEBeanTypeProxy)this.getBeanTypeProxy(ideClass.getSuperclass());
                }
                if (superTypeProxy != null) {
                    beanTypeProxy = superTypeProxy.newBeanTypeForClass(ideClass);
                }
                if (beanTypeProxy == null) {
                    beanTypeProxy = new IDEBeanTypeProxy(this.fFactoryRegistry, ideClass);
                }
            }
            catch (ClassNotFoundException e) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(1, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg);
            }
            catch (ExceptionInInitializerError e) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg);
            }
            catch (LinkageError e) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg);
            }
            this.beanProxies.put(typeName, beanTypeProxy);
            return beanTypeProxy;
        }
        int dims = typeName.lastIndexOf(91) + 1;
        Class finalComponentType = null;
        if (typeName.charAt(dims) == 'L') {
            IDEBeanTypeProxy finalType = (IDEBeanTypeProxy)this.getBeanTypeProxy(typeName.substring(dims + 1, typeName.length() - 1));
            if (finalType != null) {
                finalComponentType = finalType.fClass;
            }
        } else {
            finalComponentType = (Class)MAP_SHORTSIG_TO_TYPE.get(typeName.substring(dims, dims + 1));
        }
        if (finalComponentType != null) {
            Object dummyArray = Array.newInstance(finalComponentType, new int[dims]);
            beanTypeProxy = new IDEArrayBeanTypeProxy(this.fFactoryRegistry, typeName, dummyArray.getClass());
            this.beanProxies.put(typeName, beanTypeProxy);
        }
        return beanTypeProxy;
    }

    public IBeanTypeProxy getBeanTypeProxy(String componentClassName, int dimensions) {
        String jniComponentTypeName;
        String compType = jniComponentTypeName = MapTypes.getJNIFormatName((String)componentClassName);
        if (jniComponentTypeName.charAt(0) != '[' && (compType = (String)MAP_TYPENAME_TO_SHORTSIG.get(componentClassName)) == null) {
            compType = "L" + jniComponentTypeName + ";";
        }
        StringBuffer buffer = new StringBuffer(dimensions + compType.length());
        int i = 0;
        while (i < dimensions) {
            buffer.append('[');
            ++i;
        }
        buffer.append(compType);
        return this.getBeanTypeProxy(buffer.toString());
    }

    public void terminateFactory(boolean wait) {
    }

    public synchronized void registerBeanTypeProxy(IBeanTypeProxy aBeanTypeProxy, boolean permanent) {
        this.beanProxies.put(aBeanTypeProxy.getTypeName(), aBeanTypeProxy);
    }

    public synchronized boolean isBeanTypeRegistered(String className) {
        return this.beanProxies.containsKey(MapTypes.getJNIFormatName((String)className));
    }

    public Set registeredTypes() {
        return this.beanProxies.keySet();
    }

    public boolean isBeanTypeNotFound(String className) {
        return false;
    }

    public boolean isMaintainNotFoundTypes() {
        return false;
    }

    public void setMaintainNotFoundTypes(boolean maintain) {
    }
}

