/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.vm.remote;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.MapTypes;
import org.eclipse.jem.internal.proxy.common.MethodHelper;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.tree.ExpressionProcesser;
import org.eclipse.jem.internal.proxy.initParser.tree.IExpressionConstants;
import org.eclipse.jem.internal.proxy.vm.remote.ConnectionHandler;
import org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread;

public class ExpressionProcesserController {
    protected final RemoteVMServerThread server;
    protected final ConnectionHandler connHandler;
    protected final ExpressionProcesser exp;
    protected Commands.ValueObject workerValue = new Commands.ValueObject();
    private ClassLoader classLoader;
    protected boolean errorOccurred = false;
    private String novalueMsg = null;
    private Throwable exception = null;
    private static final List PRIMITIVE_NAMES = Arrays.asList("byte", "char", "short", "int", "long", "float", "double");
    private static final Class[] PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    static /* synthetic */ Class class$0;

    public ExpressionProcesserController(RemoteVMServerThread server, ConnectionHandler connHandler) {
        this(server, connHandler, new ExpressionProcesser());
    }

    protected ExpressionProcesserController(RemoteVMServerThread server, ConnectionHandler connHandler, ExpressionProcesser exp) {
        this.server = server;
        this.connHandler = connHandler;
        this.exp = exp;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (className.endsWith("[]")) {
            return this.loadClass(MapTypes.getJNIFormatName((String)className));
        }
        int primIndex = PRIMITIVE_NAMES.indexOf(className);
        if (primIndex >= 0) {
            return PRIMITIVE_TYPES[primIndex];
        }
        if (this.classLoader == null) {
            return Class.forName(className);
        }
        return this.classLoader.loadClass(className);
    }

    public void process(DataInputStream in) throws CommandException, IOException {
        byte subcommand = in.readByte();
        try {
            switch (subcommand) {
                case 12: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    if (this.errorOccurred) break;
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    if (value == null) {
                        this.exp.pushExpression(null, MethodHelper.NULL_TYPE);
                        break;
                    }
                    if (this.workerValue.isPrimitive()) {
                        this.exp.pushExpression(value, this.workerValue.getPrimitiveType());
                        break;
                    }
                    this.exp.pushExpression(value, value.getClass());
                    break;
                }
                case 4: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    if (this.errorOccurred) break;
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    try {
                        if (value instanceof String) {
                            value = this.loadClass((String)value);
                        }
                        this.exp.pushCast((Class)value);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e) {
                        this.processException(e);
                    }
                    catch (ClassNotFoundException e) {
                        this.processException(e);
                    }
                    break;
                }
                case 8: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    if (this.errorOccurred) break;
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    try {
                        if (value instanceof String) {
                            value = this.loadClass((String)value);
                        }
                        this.exp.pushInstanceof((Class)value);
                    }
                    catch (ClassNotFoundException e) {
                        this.processException(e);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e) {
                        this.processException(e);
                    }
                    break;
                }
                case 9: {
                    byte infix_operator = in.readByte();
                    byte infix_operandType = in.readByte();
                    if (this.errorOccurred) break;
                    try {
                        this.exp.pushInfix((int)infix_operator, (int)infix_operandType);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e1) {
                        this.processException(e1);
                    }
                    break;
                }
                case 11: {
                    byte prefix_operandType = in.readByte();
                    if (this.errorOccurred) break;
                    try {
                        this.exp.pushPrefix((int)prefix_operandType);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e2) {
                        this.processException(e2);
                    }
                    break;
                }
                case 13: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    if (this.errorOccurred) break;
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    try {
                        value = this.loadClass((String)value);
                        Class clazz = (Class)value;
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("java.lang.Class");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.exp.pushExpression((Object)clazz, (Class)clazz2);
                    }
                    catch (ClassNotFoundException e) {
                        this.processException(e);
                    }
                    break;
                }
                case 1: {
                    int arrayAccess_Indexcount = in.readInt();
                    if (this.errorOccurred) break;
                    try {
                        this.exp.pushArrayAccess(arrayAccess_Indexcount);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e3) {
                        this.processException(e3);
                    }
                    break;
                }
                case 2: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    int arrayCreation_dimCount = in.readInt();
                    if (this.errorOccurred) break;
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    try {
                        if (value instanceof String) {
                            value = this.loadClass((String)value);
                        }
                        this.exp.pushArrayCreation((Class)value, arrayCreation_dimCount);
                    }
                    catch (ClassNotFoundException e) {
                        this.processException(e);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e) {
                        this.processException(e);
                    }
                    break;
                }
                case 3: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    int arrayInitializer_expressionCount = in.readInt();
                    if (this.errorOccurred) break;
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    try {
                        if (value instanceof String) {
                            value = this.loadClass((String)value);
                        }
                        this.exp.pushArrayInitializer((Class)value, arrayInitializer_expressionCount);
                    }
                    catch (ClassNotFoundException e) {
                        this.processException(e);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e) {
                        this.processException(e);
                    }
                    break;
                }
                case 6: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    int newInstance_argCount = in.readInt();
                    if (this.errorOccurred) {
                        return;
                    }
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    try {
                        if (value instanceof String) {
                            value = this.loadClass((String)value);
                        }
                        this.exp.pushClassInstanceCreation((Class)value, newInstance_argCount);
                    }
                    catch (ClassNotFoundException e) {
                        this.processException(e);
                    }
                    catch (EvaluationException e) {
                        this.processException(e);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e) {
                        this.processException(e);
                    }
                    catch (InstantiationException e) {
                        this.processException(e);
                    }
                    catch (IllegalAccessException e) {
                        this.processException(e);
                    }
                    catch (InvocationTargetException e) {
                        this.processException(e);
                    }
                    catch (LinkageError e) {
                        this.processError(e);
                    }
                    break;
                }
                case 14: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    if (this.errorOccurred) break;
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    try {
                        if (value instanceof String) {
                            value = this.loadClass((String)value);
                        }
                        this.exp.pushExpression(value, (Class)value);
                    }
                    catch (ClassNotFoundException e) {
                        this.processException(e);
                    }
                    break;
                }
                case 7: {
                    String fieldAccess_name = in.readUTF();
                    boolean fieldAccess_receiver = in.readBoolean();
                    if (this.errorOccurred) break;
                    try {
                        this.exp.pushFieldAccess(fieldAccess_name, fieldAccess_receiver);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e4) {
                        this.processException(e4);
                    }
                    catch (NoSuchFieldException e4) {
                        this.processException(e4);
                    }
                    catch (IllegalAccessException e4) {
                        this.processException(e4);
                    }
                    break;
                }
                case 10: {
                    String method_name = in.readUTF();
                    boolean method_receiver = in.readBoolean();
                    int method_argCount = in.readInt();
                    if (this.errorOccurred) break;
                    try {
                        this.exp.pushMethodInvocation(method_name, method_receiver, method_argCount);
                    }
                    catch (EvaluationException e5) {
                        this.processException(e5);
                    }
                    catch (IExpressionConstants.NoExpressionValueException e5) {
                        this.processException(e5);
                    }
                    catch (IllegalAccessException e5) {
                        this.processException(e5);
                    }
                    catch (InvocationTargetException e5) {
                        this.processException(e5);
                    }
                    break;
                }
                case 5: {
                    byte conditional_type = in.readByte();
                    if (this.errorOccurred) break;
                    try {
                        this.exp.pushConditional((int)conditional_type);
                        break;
                    }
                    catch (IExpressionConstants.NoExpressionValueException e6) {
                        this.processException(e6);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            this.processException(e);
        }
        this.workerValue.set();
    }

    public Object[] pullValue() {
        Object[] result = new Object[2];
        try {
            this.exp.pullValue(result);
            return result;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.processException(e);
            return null;
        }
    }

    protected final void processException(Exception e) {
        this.errorOccurred = true;
        this.exception = e;
    }

    protected final void processError(Error e) {
        this.errorOccurred = true;
        this.exception = e;
    }

    protected final void processException(InvocationTargetException e) {
        this.errorOccurred = true;
        this.exception = e.getTargetException();
    }

    protected final void processException(EvaluationException e) {
        this.errorOccurred = true;
        this.exception = e.getOriginalException();
    }

    protected final void processException(IExpressionConstants.NoExpressionValueException e) {
        this.errorOccurred = true;
        this.novalueMsg = e.getLocalizedMessage();
        if (this.novalueMsg == null) {
            this.novalueMsg = "";
        }
    }

    public boolean noErrors() {
        return !this.errorOccurred;
    }

    public int getErrorCode() {
        if (this.novalueMsg != null) {
            return 9;
        }
        return 0;
    }

    public String getErrorMsg() {
        if (this.novalueMsg != null && this.novalueMsg.length() > 0) {
            return this.novalueMsg;
        }
        return null;
    }

    public Throwable getErrorThrowable() {
        return this.exception;
    }

    public void close() {
        this.exp.close();
    }
}

