/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.vm;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jem.internal.beaninfo.common.BeanRecord;
import org.eclipse.jem.internal.beaninfo.common.EventSetRecord;
import org.eclipse.jem.internal.beaninfo.common.FeatureAttributeValue;
import org.eclipse.jem.internal.beaninfo.common.FeatureRecord;
import org.eclipse.jem.internal.beaninfo.common.IndexedPropertyRecord;
import org.eclipse.jem.internal.beaninfo.common.MethodRecord;
import org.eclipse.jem.internal.beaninfo.common.ParameterRecord;
import org.eclipse.jem.internal.beaninfo.common.PropertyRecord;
import org.eclipse.jem.internal.beaninfo.common.ReflectFieldRecord;
import org.eclipse.jem.internal.beaninfo.common.ReflectMethodRecord;
import org.eclipse.jem.internal.beaninfo.vm.FeatureDescriptorEquality;
import org.eclipse.jem.internal.beaninfo.vm.ModelingBeanInfo15;
import org.eclipse.jem.internal.beaninfo.vm.ModelingBeanInfoPre15;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.IVMServer;

public abstract class ModelingBeanInfo
implements ICallback {
    private static boolean PRE15;
    protected boolean fMergeInheritedEvents = false;
    protected boolean fMergeInheritedMethods = false;
    protected boolean fMergeInheritedProperties = false;
    protected final BeanInfo fTargetBeanInfo;
    protected EventSetDescriptor[] fEventSets;
    protected MethodDescriptor[] fMethods;
    protected PropertyDescriptor[] fProperties;
    protected String[] fNotInheritedEventSets;
    protected String[] fNotInheritedMethods;
    protected String[] fNotInheritedProperties;
    protected int doFlags;
    private IVMServer vmServer;
    private int callbackID;
    protected static final int BEAN_RECORD_TYPE = 0;
    protected static final int PROPERTY_RECORD_TYPE = 1;
    protected static final int INDEXEDPROPERTY_RECORD_TYPE = 2;
    protected static final int METHOD_RECORD_TYPE = 3;
    protected static final int PARAMETER_RECORD_TYPE = 4;
    protected static final int EVENTSET_RECORD_TYPE = 5;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        String version = System.getProperty("java.version", "");
        PRE15 = version.startsWith("1.");
        if (PRE15) {
            int revision = 0;
            if (version.length() > 2) {
                int revEnd = version.indexOf(46, 2);
                revision = version.length() > 2 ? Integer.parseInt(revEnd != -1 ? version.substring(2, revEnd) : version.substring(2)) : 0;
                PRE15 = revision < 5;
            }
        }
    }

    public static ModelingBeanInfo introspect(Class introspectClass, int doFlags) throws IntrospectionException {
        return ModelingBeanInfo.introspect(introspectClass, true, doFlags);
    }

    public static ModelingBeanInfo introspect(Class introspectClass, boolean introspectIfNoBeanInfo, int doFlags) throws IntrospectionException {
        if (!introspectIfNoBeanInfo) {
            boolean found = false;
            if (!ModelingBeanInfo.classExists(String.valueOf(introspectClass.getName()) + "BeanInfo", introspectClass)) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.beans.BeanInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(introspectClass)) {
                    String[] searchPath = Introspector.getBeanInfoSearchPath();
                    int startClassname = introspectClass.getName().lastIndexOf(".") + 1;
                    String biName = "." + introspectClass.getName().substring(startClassname) + "BeanInfo";
                    int i = 0;
                    while (i < searchPath.length) {
                        if (ModelingBeanInfo.classExists(String.valueOf(searchPath[i]) + biName, introspectClass)) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                } else {
                    found = true;
                }
            } else {
                found = true;
            }
            if (!found) {
                return null;
            }
        }
        BeanInfo bInfo = Introspector.getBeanInfo(introspectClass);
        Class superClass = introspectClass.getSuperclass();
        if (superClass == null) {
            return PRE15 ? new ModelingBeanInfoPre15(bInfo, doFlags) : new ModelingBeanInfo15(bInfo, doFlags);
        }
        return PRE15 ? new ModelingBeanInfoPre15(bInfo, Introspector.getBeanInfo(superClass), doFlags) : new ModelingBeanInfo15(bInfo, Introspector.getBeanInfo(superClass), doFlags);
    }

    protected static boolean classExists(String className, Class fromClass) {
        if (fromClass.getClassLoader() != null) {
            try {
                fromClass.getClassLoader().loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (ClassLoader.getSystemClassLoader() != null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                cl.loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return false;
            }
        }
    }

    protected ModelingBeanInfo(BeanInfo beanInfo, int doFlags) {
        this.fTargetBeanInfo = beanInfo;
        this.doFlags = doFlags;
    }

    protected ModelingBeanInfo(BeanInfo beanInfo, BeanInfo superBeanInfo, int doFlags) {
        this(beanInfo, doFlags);
        List inherited;
        List full;
        if ((doFlags & 8) != 0) {
            full = this.addAll(beanInfo.getEventSetDescriptors());
            inherited = this.addAll(superBeanInfo.getEventSetDescriptors());
            this.fMergeInheritedEvents = this.stripList(full, inherited);
            if (this.fMergeInheritedEvents) {
                if (!full.isEmpty()) {
                    this.fEventSets = full.toArray(new EventSetDescriptor[full.size()]);
                }
                if (!inherited.isEmpty()) {
                    this.createEventArray(inherited);
                }
            }
        }
        if ((doFlags & 4) != 0) {
            full = this.addAll(beanInfo.getMethodDescriptors());
            inherited = this.addAll(superBeanInfo.getMethodDescriptors());
            this.fMergeInheritedMethods = this.stripList(full, inherited);
            if (this.fMergeInheritedMethods) {
                if (!full.isEmpty()) {
                    this.fMethods = full.toArray(new MethodDescriptor[full.size()]);
                }
                if (!inherited.isEmpty()) {
                    this.createMethodEntries(inherited);
                }
            }
        }
        if ((doFlags & 2) != 0) {
            full = this.addAll(beanInfo.getPropertyDescriptors());
            inherited = this.addAll(superBeanInfo.getPropertyDescriptors());
            this.fMergeInheritedProperties = this.stripList(full, inherited);
            if (this.fMergeInheritedProperties) {
                if (!full.isEmpty()) {
                    this.fProperties = full.toArray(new PropertyDescriptor[full.size()]);
                }
                if (!inherited.isEmpty()) {
                    this.createPropertyArray(inherited);
                }
            }
        }
    }

    protected void createEventArray(List features) {
        this.fNotInheritedEventSets = this.createDescriptorNames(features);
    }

    protected void createMethodEntries(List features) {
        int s = features.size();
        this.fNotInheritedMethods = new String[s];
        int i = 0;
        while (i < s) {
            this.fNotInheritedMethods[i] = this.longName((MethodDescriptor)features.get(i));
            ++i;
        }
    }

    protected String longName(MethodDescriptor md) {
        String n = md.getName();
        StringBuffer sb = new StringBuffer(n.length() + 20);
        sb.append(n);
        sb.append(':');
        Method m = md.getMethod();
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] parms = m.getParameterTypes();
        int j = 0;
        while (j < parms.length) {
            if (j > 0) {
                sb.append(',');
            }
            if (!parms[j].isArray()) {
                sb.append(parms[j].getName().replace('$', '.'));
            } else {
                Class<?> finalType = parms[j].getComponentType();
                int insrt = sb.length();
                while (finalType.isArray()) {
                    sb.append("[]");
                    finalType = finalType.getComponentType();
                }
                sb.insert(insrt, finalType.getName().replace('$', '.'));
            }
            ++j;
        }
        return sb.toString();
    }

    protected void createPropertyArray(List features) {
        this.fNotInheritedProperties = this.createDescriptorNames(features);
    }

    protected String[] createDescriptorNames(List features) {
        String[] result = new String[features.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = ((FeatureDescriptor)features.get(i)).getName();
            ++i;
        }
        return result;
    }

    protected List addAll(Object[] set) {
        if (set != null) {
            ArrayList<Object> l = new ArrayList<Object>(set.length);
            int i = 0;
            while (i < set.length) {
                l.add(set[i]);
                ++i;
            }
            return l;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isMergeInheritedEvents() {
        return this.fMergeInheritedEvents;
    }

    public boolean isMergeInheritedMethods() {
        return this.fMergeInheritedMethods;
    }

    public boolean isMergeInheritedProperties() {
        return this.fMergeInheritedProperties;
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        return this.fTargetBeanInfo.getAdditionalBeanInfo();
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.fTargetBeanInfo.getBeanDescriptor();
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.fMergeInheritedEvents ? this.fEventSets : this.fTargetBeanInfo.getEventSetDescriptors();
    }

    public Image getIcon(int iconKind) {
        return this.fTargetBeanInfo.getIcon(iconKind);
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.fMergeInheritedMethods ? this.fMethods : this.fTargetBeanInfo.getMethodDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.fMergeInheritedProperties ? this.fProperties : this.fTargetBeanInfo.getPropertyDescriptors();
    }

    public String[] getNotInheritedEventSetDescriptors() {
        return this.fNotInheritedEventSets;
    }

    public String[] getNotInheritedMethodDescriptors() {
        return this.fNotInheritedMethods;
    }

    public String[] getNotInheritedPropertyDescriptors() {
        return this.fNotInheritedProperties;
    }

    protected String computeKey(FeatureDescriptor feature) {
        return feature instanceof MethodDescriptor ? this.longName((MethodDescriptor)feature) : feature.getName();
    }

    protected boolean stripList(List fullList, List inheritedList) {
        if (fullList.isEmpty()) {
            return false;
        }
        if (inheritedList.isEmpty()) {
            return false;
        }
        FeatureDescriptorEquality workingStrip = FeatureDescriptorEquality.createEquality((FeatureDescriptor)inheritedList.get(0));
        FeatureDescriptorEquality workingFull = FeatureDescriptorEquality.createEquality((FeatureDescriptor)fullList.get(0));
        int inheritedSize = inheritedList.size();
        boolean[] copy = new boolean[inheritedSize];
        HashMap<String, Integer> inheritedMap = new HashMap<String, Integer>(inheritedSize);
        int i = 0;
        while (i < inheritedSize) {
            FeatureDescriptor f = (FeatureDescriptor)inheritedList.get(i);
            String key = this.computeKey(f);
            Object value = inheritedMap.get(key);
            if (value == null) {
                inheritedMap.put(key, new Integer(i));
            }
            ++i;
        }
        int inheritedRetained = 0;
        Iterator fullItr = fullList.iterator();
        while (inheritedRetained < inheritedSize && fullItr.hasNext()) {
            FeatureDescriptor f = (FeatureDescriptor)fullItr.next();
            boolean foundFull = false;
            Object index = inheritedMap.get(this.computeKey(f));
            if (index != null) {
                workingFull.setFeature(f);
                int ndx = (Integer)index;
                workingStrip.setFeature((FeatureDescriptor)inheritedList.get(ndx));
                if (workingFull.equals(workingStrip)) {
                    copy[ndx] = true;
                    foundFull = true;
                    ++inheritedRetained;
                }
            }
            if (!foundFull) continue;
            fullItr.remove();
        }
        if (inheritedRetained == inheritedSize) {
            inheritedList.clear();
            return true;
        }
        if (inheritedRetained != 0) {
            ListIterator itr = inheritedList.listIterator(inheritedList.size());
            while (itr.hasPrevious()) {
                int i2 = itr.previousIndex();
                itr.previous();
                if (!copy[i2]) continue;
                itr.remove();
            }
            return true;
        }
        return false;
    }

    public void initializeCallback(IVMServer vmServer, int callbackID) {
        this.vmServer = vmServer;
        this.callbackID = callbackID;
    }

    public void send() throws IOException, CommandException {
        if (this.doFlags != 0) {
            ObjectOutputStream stream = new ObjectOutputStream(this.vmServer.requestStream(this.callbackID, 0));
            if ((this.doFlags & 1) != 0) {
                this.sendBeanDecorator(stream);
            }
            if ((this.doFlags & 2) != 0) {
                this.sendPropertyDecorators(stream);
            }
            if ((this.doFlags & 4) != 0) {
                this.sendMethodDecorators(stream);
            }
            if ((this.doFlags & 8) != 0) {
                this.sendEventDecorators(stream);
            }
            stream.writeInt(5);
            stream.close();
        }
    }

    public void sendBeanDecorator(ObjectOutputStream stream) throws IOException, CommandException {
        BeanRecord br = new BeanRecord();
        BeanDescriptor bd = this.getBeanDescriptor();
        if (bd != null) {
            br.customizerClassName = this.getClassName(bd.getCustomizerClass());
            br.mergeInheritedProperties = this.isMergeInheritedProperties();
            br.mergeInheritedOperations = this.isMergeInheritedMethods();
            br.mergeInheritedEvents = this.isMergeInheritedEvents();
            br.notInheritedPropertyNames = this.getNotInheritedPropertyDescriptors();
            br.notInheritedOperationNames = this.getNotInheritedMethodDescriptors();
            br.notInheritedEventNames = this.getNotInheritedEventSetDescriptors();
            this.fill(bd, (FeatureRecord)br, 0);
        }
        stream.writeInt(1);
        stream.writeObject(br);
    }

    public void sendPropertyDecorators(ObjectOutputStream stream) throws IOException, CommandException {
        PropertyDescriptor[] properties = this.getPropertyDescriptors();
        if (properties != null && properties.length > 0) {
            stream.writeInt(2);
            stream.writeInt(properties.length);
            int i = 0;
            while (i < properties.length) {
                PropertyDescriptor pd = properties[i];
                PropertyRecord usepr = null;
                int useType = 0;
                Class<?> clazz = pd.getClass();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.beans.IndexedPropertyDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                    IndexedPropertyRecord ipr = new IndexedPropertyRecord();
                    usepr = ipr;
                    useType = 2;
                    ipr.indexedReadMethod = this.getReflectedMethodRecord(ipd.getIndexedReadMethod());
                    ipr.indexedWriteMethod = this.getReflectedMethodRecord(ipd.getIndexedWriteMethod());
                    ipr.indexedPropertyTypeName = this.getClassName(ipd.getIndexedPropertyType());
                } else {
                    usepr = new PropertyRecord();
                    useType = 1;
                }
                usepr.propertyEditorClassName = this.getClassName(pd.getPropertyEditorClass());
                usepr.propertyTypeName = this.getClassName(pd.getPropertyType());
                usepr.readMethod = this.getReflectedMethodRecord(pd.getReadMethod());
                usepr.writeMethod = this.getReflectedMethodRecord(pd.getWriteMethod());
                usepr.bound = pd.isBound();
                usepr.constrained = pd.isConstrained();
                usepr.designTime = null;
                usepr.field = null;
                this.fill(pd, (FeatureRecord)usepr, useType);
                stream.writeObject(usepr);
                ++i;
            }
        }
    }

    public void sendMethodDecorators(ObjectOutputStream stream) throws IOException, CommandException {
        MethodDescriptor[] methods = this.getMethodDescriptors();
        if (methods != null && methods.length > 0) {
            stream.writeInt(3);
            stream.writeInt(methods.length);
            int i = 0;
            while (i < methods.length) {
                MethodRecord mr = new MethodRecord();
                this.fill(mr, methods[i]);
                stream.writeObject(mr);
                ++i;
            }
        }
    }

    protected void fill(MethodRecord mr, MethodDescriptor md) {
        mr.methodForDescriptor = this.getReflectedMethodRecord(md.getMethod());
        ParameterDescriptor[] parms = md.getParameterDescriptors();
        if (parms == null) {
            mr.parameters = null;
        } else {
            mr.parameters = new ParameterRecord[parms.length];
            int j = 0;
            while (j < parms.length) {
                ParameterRecord pr = new ParameterRecord();
                this.fill(parms[j], (FeatureRecord)pr, 4);
                mr.parameters[j] = pr;
                ++j;
            }
        }
        this.fill(md, (FeatureRecord)mr, 3);
    }

    public void sendEventDecorators(ObjectOutputStream stream) throws IOException, CommandException {
        EventSetDescriptor[] events = this.getEventSetDescriptors();
        if (events != null && events.length > 0) {
            stream.writeInt(4);
            stream.writeInt(events.length);
            int i = 0;
            while (i < events.length) {
                EventSetDescriptor ed = events[i];
                EventSetRecord er = new EventSetRecord();
                er.addListenerMethod = this.getReflectedMethodRecord(ed.getAddListenerMethod());
                MethodDescriptor[] mds = ed.getListenerMethodDescriptors();
                if (mds == null) {
                    er.listenerMethodDescriptors = null;
                } else {
                    er.listenerMethodDescriptors = new MethodRecord[mds.length];
                    int j = 0;
                    while (j < mds.length) {
                        er.listenerMethodDescriptors[j] = new MethodRecord();
                        this.fill(er.listenerMethodDescriptors[j], mds[j]);
                        ++j;
                    }
                }
                er.listenerTypeName = this.getClassName(ed.getListenerType());
                er.removeListenerMethod = this.getReflectedMethodRecord(ed.getRemoveListenerMethod());
                er.inDefaultEventSet = ed.isInDefaultEventSet();
                er.unicast = ed.isUnicast();
                er.eventAdapterClassName = null;
                this.fill(ed, (FeatureRecord)er, 5);
                stream.writeObject(er);
                ++i;
            }
        }
    }

    protected boolean fillFromAttributes(FeatureRecord record, FeatureDescriptor descr, String attributeName, int recordType) {
        switch (recordType) {
            case 1: 
            case 2: {
                if ("ivjDesignTimeProperty".equals(attributeName)) {
                    ((PropertyRecord)record).designTime = (Boolean)descr.getValue(attributeName);
                    return true;
                }
                if (!"field".equals(attributeName)) break;
                Field f = (Field)descr.getValue(attributeName);
                PropertyRecord pr = (PropertyRecord)record;
                pr.propertyTypeName = this.getClassName(f.getType());
                pr.field = this.getReflectedFieldRecord(f);
                pr.readMethod = null;
                pr.writeMethod = null;
                return true;
            }
            case 5: {
                if (!"eventAdapterClass".equals(attributeName)) break;
                ((EventSetRecord)record).eventAdapterClassName = (String)descr.getValue(attributeName);
                return true;
            }
        }
        return false;
    }

    protected void fill(FeatureDescriptor descr, FeatureRecord record, int recordType) {
        record.name = descr.getName();
        String dn = descr.getDisplayName();
        record.displayName = !record.name.equals(dn) ? dn : null;
        String shd = descr.getShortDescription();
        record.shortDescription = !dn.equals(shd) ? shd : null;
        record.expert = descr.isExpert();
        record.hidden = descr.isHidden();
        record.preferred = descr.isPreferred();
        record.category = null;
        Enumeration<String> attrs = descr.attributeNames();
        if (attrs.hasMoreElements()) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<FeatureAttributeValue> values = new ArrayList<FeatureAttributeValue>();
            while (attrs.hasMoreElements()) {
                String attrName = attrs.nextElement();
                if (attrName.equals("category")) {
                    record.category = (String)descr.getValue("category");
                    continue;
                }
                if (attrName.equals("preferred")) {
                    record.preferred = (Boolean)descr.getValue("preferred");
                    continue;
                }
                if (this.fillFromAttributes(record, descr, attrName, recordType)) continue;
                FeatureAttributeValue fv = new FeatureAttributeValue();
                fv.setValue(descr.getValue(attrName));
                names.add(attrName);
                values.add(fv);
            }
            if (!names.isEmpty()) {
                record.attributeNames = names.toArray(new String[names.size()]);
                record.attributeValues = values.toArray(new FeatureAttributeValue[values.size()]);
            } else {
                record.attributeNames = null;
                record.attributeValues = null;
            }
        } else {
            record.attributeNames = null;
            record.attributeValues = null;
        }
    }

    private String getClassName(Class classs) {
        return classs != null ? classs.getName() : null;
    }

    private ReflectMethodRecord getReflectedMethodRecord(Method method) {
        if (method != null) {
            ReflectMethodRecord rmr = new ReflectMethodRecord();
            rmr.className = this.getClassName(method.getDeclaringClass());
            rmr.methodName = method.getName();
            Class<?>[] parmTypes = method.getParameterTypes();
            if (parmTypes.length > 0) {
                rmr.parameterTypeNames = new String[parmTypes.length];
                int i = 0;
                while (i < parmTypes.length) {
                    rmr.parameterTypeNames[i] = this.getClassName(parmTypes[i]);
                    ++i;
                }
            }
            return rmr;
        }
        return null;
    }

    private ReflectFieldRecord getReflectedFieldRecord(Field field) {
        if (field != null) {
            ReflectFieldRecord rf = new ReflectFieldRecord();
            rf.className = this.getClassName(field.getDeclaringClass());
            rf.fieldName = field.getName();
            rf.readOnly = Modifier.isFinal(field.getModifiers());
            return rf;
        }
        return null;
    }

    static class FeatureEqualitySet
    extends HashSet {
        private FeatureDescriptorEquality workingKey;

        public FeatureEqualitySet(List features) {
            super(features.size());
            this.workingKey = FeatureDescriptorEquality.createEquality((FeatureDescriptor)features.get(0));
            this.addAll(features);
        }

        public boolean add(Object o) {
            return super.add(FeatureDescriptorEquality.createEquality((FeatureDescriptor)o));
        }

        public boolean contains(Object o) {
            this.workingKey.setFeature((FeatureDescriptor)o);
            return super.contains(this.workingKey);
        }
    }
}

