/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser.tree;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.InitparserTreeMessages;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalConditionalOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalExpressionProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalIfElseOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalInfixOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.VariableReference;

public class ExpressionProcesser {
    private List expressionStack = new ArrayList(10);
    private List expressionTypeStack = new ArrayList(10);
    private ArrayList expressionProxies;
    private boolean errorOccurred = false;
    private boolean novalueException = false;
    private Throwable exception = null;
    protected Object ignoreExpression = null;
    private List saveStates;
    protected final boolean traceOn;
    private final long thresholdTime;
    private long startExpressionStepTime;
    private long startExpressionTime;
    private long lastExpressionEndTime;
    protected final String traceHeader;
    private int indent = 0;
    private static int TRACE_COUNTER;
    private static final Object IFELSE_IGNORE;
    private int ifElseNesting = 0;
    private int ifElseIgnoreNestCount = 0;
    private boolean ifElseSkipTruePart;
    protected static final int BOOLEAN = 0;
    protected static final int BYTE = 1;
    protected static final int SHORT = 2;
    protected static final int CHAR = 3;
    protected static final int INT = 4;
    protected static final int LONG = 5;
    protected static final int FLOAT = 6;
    protected static final int DOUBLE = 7;
    private static final Object INFIX_IGNORE;
    private int infixNesting = 0;
    private int infixIgnoreNestCount = 0;
    private static final Object CONDITIONAL_IGNORE;
    private int conditionalNesting = 0;
    private int conditionalIgnoreNestCount = 0;
    private boolean skipTruePart;
    private static final Object BLOCK_IGNORE;
    private int[] blocks;
    private int topBlock = -1;
    private int breakBlock = -1;
    private static final Object TRY_THROW_IGNORE;
    private static final Object TRY_FINAL_IGNORE;
    private int[] trys;
    private Throwable[] trysInCatch;
    private int topTry = -1;
    private int breakTry = -1;
    private Throwable catchThrowable;
    private static final Throwable FINAL_CATCH;
    static /* synthetic */ Class class$0;

    static {
        IFELSE_IGNORE = "IF/ELSE IGNORE";
        INFIX_IGNORE = "INFIX IGNORE";
        CONDITIONAL_IGNORE = "CONDITIONAL IGNORE";
        BLOCK_IGNORE = "BLOCK IGNORE";
        TRY_THROW_IGNORE = "TRY THROW IGNORE";
        TRY_FINAL_IGNORE = "TRY FINAL IGNORE";
        FINAL_CATCH = new RuntimeException();
    }

    public final void processException(Throwable e) {
        this.novalueException = false;
        while (e.getCause() != null) {
            e = e.getCause();
        }
        if (this.traceOn) {
            System.out.println();
            System.out.print("***** >>>\tException: ");
            System.out.println(e);
        }
        this.throwException(e);
    }

    protected final void processSyntaxException(Throwable e) {
        this.errorOccurred = true;
        this.novalueException = false;
        this.exception = e;
    }

    /*
     * Exception decompiling
     */
    protected final void processSyntaxException(NoExpressionValueException e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 52->56)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean noErrors() {
        return !this.errorOccurred;
    }

    public boolean isNoExpressionValue() {
        return this.novalueException;
    }

    public Throwable getErrorThrowable() {
        return this.exception;
    }

    protected final void pushExpressionValue(Object o, Class type) {
        this.expressionStack.add(o);
        this.expressionTypeStack.add(type);
    }

    protected final Object popExpression() throws NoExpressionValueException {
        return this.popExpression(true);
    }

    protected final Object popExpression(boolean deReference) throws NoExpressionValueException {
        try {
            Object result = this.expressionStack.remove(this.expressionStack.size() - 1);
            if (deReference && result instanceof VariableReference) {
                result = ((VariableReference)result).dereference();
            }
            return result;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    protected final Object getExpression(int fromTop) throws NoExpressionValueException {
        try {
            return this.expressionStack.get(this.expressionStack.size() - fromTop);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    protected final void popExpressions(int count) throws NoExpressionValueException {
        try {
            int remove = this.expressionStack.size() - 1;
            while (count-- > 0) {
                this.expressionStack.remove(remove);
                this.expressionTypeStack.remove(remove--);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    protected final Class popExpressionType(boolean allowVoid) throws NoExpressionValueException {
        try {
            Class result = (Class)this.expressionTypeStack.remove(this.expressionTypeStack.size() - 1);
            if (!allowVoid && result == Void.TYPE) {
                throw new NoExpressionValueException(InitparserTreeMessages.getString("ExpressionProcesser.PopExpressionType.ExpressionVoid_EXC_"));
            }
            return result;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    protected final Class getExpressionType(int fromTop, boolean allowVoid) throws NoExpressionValueException {
        try {
            Class result = (Class)this.expressionTypeStack.get(this.expressionTypeStack.size() - fromTop);
            if (!allowVoid && result == Void.TYPE) {
                throw new NoExpressionValueException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    public ExpressionProcesser() {
        this(false, -1L);
    }

    public ExpressionProcesser(boolean traceOn, long threshold) {
        this.traceOn = traceOn;
        if (traceOn) {
            this.traceHeader = "**" + ++TRACE_COUNTER + ':';
            System.out.print(this.traceHeader);
            System.out.println(" Start expression");
            this.thresholdTime = threshold != -1L ? threshold : 100L;
            this.lastExpressionEndTime = this.startExpressionTime = System.currentTimeMillis();
        } else {
            this.traceHeader = null;
            this.thresholdTime = 100L;
        }
    }

    protected void printTrace(String msg, boolean ignore) {
        this.startExpressionStepTime = System.currentTimeMillis();
        long sinceLastExpression = this.startExpressionStepTime - this.lastExpressionEndTime;
        System.out.print(this.traceHeader);
        if (sinceLastExpression > 0L) {
            System.out.print('(');
            if (sinceLastExpression > this.thresholdTime) {
                System.out.print("***");
            }
            System.out.print(sinceLastExpression);
            System.out.print("ms)");
        }
        System.out.print('\t');
        if (!ignore) {
            System.out.print("\t");
        } else {
            System.out.print("##\t");
        }
        this.printIndent();
        System.out.print(msg);
    }

    protected void printIndent() {
        int i = this.indent;
        while (i > 0) {
            System.out.print("  ");
            --i;
        }
    }

    protected void printTraceEnd() {
        long stop = System.currentTimeMillis() - this.startExpressionStepTime;
        if (stop > 0L) {
            System.out.print(" (");
            if (stop > this.thresholdTime) {
                System.out.print("***");
            }
            System.out.print(stop);
            System.out.print("ms)");
        }
        System.out.println();
        this.lastExpressionEndTime = System.currentTimeMillis();
    }

    protected void indent(boolean indent) {
        this.indent += indent ? 1 : -1;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    protected void printObjectAndType(Object o, Class t) {
        System.out.print(' ');
        System.out.print("Object-");
        System.out.print(o);
        System.out.print(" Type-");
        System.out.print(t);
        System.out.print(' ');
    }

    /*
     * Exception decompiling
     */
    public final void close() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 123->127)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pullValue(Object[] value) throws NoExpressionValueException {
        if (this.traceOn) {
            this.printTrace("Pull value:", false);
        }
        try {
            value[0] = this.popExpression();
            value[1] = this.popExpressionType(false);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (this.traceOn) {
                this.printObjectAndType(value[0], (Class)value[1]);
                this.printTraceEnd();
            }
            throw throwable;
        }
        {
            Object var2_4 = null;
            if (this.traceOn) {
                this.printObjectAndType(value[0], (Class)value[1]);
                this.printTraceEnd();
            }
            this.close();
            return;
        }
    }

    public final void pullExpressionProxyValue(int proxyid, Object[] value) throws NoExpressionValueException {
        this.getExpressionProxyValue(proxyid, value, true, true);
    }

    public boolean getExpressionProxyValue(int proxyid, Object[] value) {
        try {
            return this.getExpressionProxyValue(proxyid, value, true, false);
        }
        catch (NoExpressionValueException noExpressionValueException) {
            return false;
        }
    }

    private boolean getExpressionProxyValue(int proxyid, Object[] value, boolean pull, boolean finalTrace) throws NoExpressionValueException {
        boolean doTrace;
        block15: {
            block16: {
                doTrace = finalTrace && this.traceOn;
                try {
                    if (this.expressionProxies == null || this.expressionProxies.size() <= proxyid) break block15;
                    InternalExpressionProxy proxy = (InternalExpressionProxy)this.expressionProxies.get(proxyid);
                    if (proxy == null || !proxy.isSet()) break block16;
                    value[0] = proxy.getValue();
                    if (value[0] instanceof VariableReference) {
                        value[0] = ((VariableReference)value[0]).dereference();
                    }
                    value[1] = proxy.getType();
                    if (doTrace) {
                        if (value[1] != Void.TYPE) {
                            this.printTrace("Return Proxy #" + proxyid + " Resolved to", false);
                            this.printObjectAndType(value[0], (Class)value[1]);
                        } else {
                            this.printTrace("Return Proxy #" + proxyid + " Resolved to void.", false);
                        }
                    }
                    Object var8_8 = null;
                    if (doTrace) {
                        this.printTraceEnd();
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var8_11 = null;
                        if (!doTrace) break block17;
                        this.printTraceEnd();
                    }
                    throw throwable;
                }
            }
            if (doTrace) {
                this.printTrace("Return Proxy #" + proxyid + ": Not resolved", false);
            }
            NoExpressionValueException e = new NoExpressionValueException(InitparserTreeMessages.getString("ExpressionProcesser.GetExpressionProxyValue.ExpressionProxyNotSet_EXC_"));
            if (pull) {
                throw e;
            }
            this.processSyntaxException(e);
            Object var8_9 = null;
            if (doTrace) {
                this.printTraceEnd();
            }
            return false;
        }
        if (doTrace) {
            this.printTrace("Return Proxy #" + proxyid + ": Never created.", false);
        }
        NoExpressionValueException e = new NoExpressionValueException(InitparserTreeMessages.getString("ExpressionProcesser.GetExpressionProxyValue.ExpressionProxyDoesntExist_EXC_"));
        if (pull) {
            throw e;
        }
        this.processSyntaxException(e);
        Object var8_10 = null;
        if (doTrace) {
            this.printTraceEnd();
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public final void pushExpression(Object o, Class t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 81->85)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushExpressionProxy(int proxyid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 193->197)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushCast(Class type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 126->130)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final Object castBean(Class returnType, Object bean, Class beanType) throws ClassCastException {
        if (bean == null) {
            if (!returnType.isPrimitive()) {
                return bean;
            }
            this.throwClassCast(returnType, bean);
        } else {
            if (returnType.equals(bean.getClass())) {
                return bean;
            }
            if (!returnType.isPrimitive()) {
                if (!beanType.isPrimitive() && returnType.isInstance(bean)) {
                    return bean;
                }
                this.throwClassCast(returnType, bean);
            } else {
                if (!beanType.isPrimitive()) {
                    this.throwClassCast(returnType, bean);
                }
                if (returnType == Boolean.TYPE) {
                    if (bean instanceof Boolean) {
                        return bean;
                    }
                    this.throwClassCast(returnType, bean);
                } else if (bean instanceof Number) {
                    if (returnType == Integer.TYPE) {
                        if (bean instanceof Integer) {
                            return bean;
                        }
                        return new Integer(((Number)bean).intValue());
                    }
                    if (returnType == Byte.TYPE) {
                        if (bean instanceof Byte) {
                            return bean;
                        }
                        return new Byte(((Number)bean).byteValue());
                    }
                    if (returnType == Character.TYPE) {
                        if (bean instanceof Character) {
                            return bean;
                        }
                        return new Character((char)((Number)bean).intValue());
                    }
                    if (returnType == Double.TYPE) {
                        if (bean instanceof Double) {
                            return bean;
                        }
                        return new Double(((Number)bean).doubleValue());
                    }
                    if (returnType == Float.TYPE) {
                        if (bean instanceof Float) {
                            return bean;
                        }
                        return new Float(((Number)bean).floatValue());
                    }
                    if (returnType == Long.TYPE) {
                        if (bean instanceof Long) {
                            return bean;
                        }
                        return new Long(((Number)bean).longValue());
                    }
                    if (returnType == Short.TYPE) {
                        if (bean instanceof Short) {
                            return bean;
                        }
                        return new Short(((Number)bean).shortValue());
                    }
                    this.throwClassCast(returnType, bean);
                } else if (bean instanceof Character) {
                    if (returnType == Character.TYPE) {
                        return bean;
                    }
                    if (returnType == Integer.TYPE) {
                        return new Integer(((Character)bean).charValue());
                    }
                    if (returnType == Byte.TYPE) {
                        return new Byte((byte)((Character)bean).charValue());
                    }
                    if (returnType == Double.TYPE) {
                        return new Double(((Character)bean).charValue());
                    }
                    if (returnType == Float.TYPE) {
                        return new Float(((Character)bean).charValue());
                    }
                    if (returnType == Long.TYPE) {
                        return new Long(((Character)bean).charValue());
                    }
                    if (returnType == Short.TYPE) {
                        return new Short((short)((Character)bean).charValue());
                    }
                    this.throwClassCast(returnType, bean);
                } else {
                    this.throwClassCast(returnType, bean);
                }
            }
        }
        return null;
    }

    private void throwClassCast(Class returnType, Object bean) throws ClassCastException {
        throw new ClassCastException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.CannotCastXToY_EXC_"), bean != null ? bean.getClass().getName() : null, returnType.getName()));
    }

    protected final Class getPrimitiveType(Object bean) throws IllegalArgumentException {
        if (bean instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (bean instanceof Integer) {
            return Integer.TYPE;
        }
        if (bean instanceof Byte) {
            return Byte.TYPE;
        }
        if (bean instanceof Character) {
            return Character.TYPE;
        }
        if (bean instanceof Double) {
            return Double.TYPE;
        }
        if (bean instanceof Float) {
            return Float.TYPE;
        }
        if (bean instanceof Long) {
            return Long.TYPE;
        }
        if (bean instanceof Short) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException(bean != null ? bean.getClass().getName() : "null");
    }

    /*
     * Exception decompiling
     */
    public final void pushIfElse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 69->72)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushIfElse(InternalIfElseOperandType clauseType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [6 : 274->278)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushInstanceof(Class type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 131->135)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final boolean isInstance(Class type, Object bean, Class beanType) {
        if (type.isPrimitive()) {
            return beanType.isPrimitive() && type == beanType;
        }
        return type.isInstance(bean);
    }

    /*
     * Exception decompiling
     */
    public final void pushNewInstanceFromString(String initializationString, Class resultType, ClassLoader classloader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 153->157)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushPrefix(PrefixOperator operator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [6 : 665->669)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pushAssignment() {
        if (this.ignoreExpression != null || this.errorOccurred) {
            if (!this.traceOn) return;
            this.printTrace("Assignment", true);
            this.printTraceEnd();
            return;
        }
        try {
            Object leftValue;
            Class refType;
            try {
                if (this.traceOn) {
                    this.printTrace("Assignment: ", false);
                }
                Object value = this.popExpression();
                Class type = this.popExpressionType(false);
                VariableReference left = (VariableReference)this.popExpression(false);
                refType = this.popExpressionType(false);
                if (this.traceOn) {
                    this.printObjectAndType(left, refType);
                }
                leftValue = left.set(value, type);
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (!this.traceOn) throw throwable;
                this.printTraceEnd();
                throw throwable;
            }
            {
                Object var6_12 = null;
                if (this.traceOn) {
                    this.printTraceEnd();
                }
                this.pushExpression(leftValue, refType);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            this.processException(e);
            return;
        }
        catch (NoExpressionValueException e) {
            this.processSyntaxException(e);
            return;
        }
        catch (IllegalAccessException e) {
            this.processException(e);
            return;
        }
        catch (RuntimeException e) {
            this.processException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public final void pushAssignment(InternalExpressionProxy proxy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 134->138)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void assignToExpressionProxyFromTopStackEntry(InternalExpressionProxy proxy) throws NoExpressionValueException {
        Object value = this.getExpression(1);
        Class type = this.getExpressionType(1, true);
        if (value instanceof VariableReference) {
            value = ((VariableReference)value).dereference();
        }
        proxy.setProxy(value, type);
        this.allocateExpressionProxy(proxy);
    }

    public void allocateExpressionProxy(InternalExpressionProxy proxy) {
        int minSize = proxy.getProxyID() + 1;
        if (this.expressionProxies == null) {
            this.expressionProxies = new ArrayList(minSize + 10);
        } else if (this.expressionProxies.size() < minSize) {
            this.expressionProxies.ensureCapacity(minSize + 10);
        }
        int fill = minSize - this.expressionProxies.size();
        if (fill > 0) {
            while (--fill > 0) {
                this.expressionProxies.add(null);
            }
            this.expressionProxies.add(proxy);
        } else {
            this.expressionProxies.set(proxy.getProxyID(), proxy);
        }
    }

    protected final int getEnumForPrimitive(Class primitiveType) throws IllegalArgumentException {
        if (primitiveType == Boolean.TYPE) {
            return 0;
        }
        if (primitiveType == Integer.TYPE) {
            return 4;
        }
        if (primitiveType == Byte.TYPE) {
            return 1;
        }
        if (primitiveType == Character.TYPE) {
            return 3;
        }
        if (primitiveType == Double.TYPE) {
            return 7;
        }
        if (primitiveType == Float.TYPE) {
            return 6;
        }
        if (primitiveType == Long.TYPE) {
            return 5;
        }
        if (primitiveType == Short.TYPE) {
            return 2;
        }
        throw new IllegalArgumentException(primitiveType != null ? primitiveType.getName() : "null");
    }

    private void throwInvalidPrefix(PrefixOperator operator, Object exp) throws IllegalArgumentException {
        throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.InvalidOperandOfPrefixOperator_EXC_"), exp != null ? exp.toString() : null, operator.toString()));
    }

    /*
     * Exception decompiling
     */
    public final void pushInfix(InfixOperator operator, InternalInfixOperandType operandType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 147->150)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startInfixIgnore() {
        this.ignoreExpression = INFIX_IGNORE;
        this.infixIgnoreNestCount = this.infixNesting;
    }

    protected final int getInt(Object bean) throws ClassCastException {
        return bean instanceof Number ? ((Number)bean).intValue() : (int)((Character)bean).charValue();
    }

    protected final float getFloat(Object bean) throws ClassCastException {
        return bean instanceof Number ? ((Number)bean).floatValue() : (float)((Character)bean).charValue();
    }

    protected final double getDouble(Object bean) throws ClassCastException {
        return bean instanceof Number ? ((Number)bean).doubleValue() : (double)((Character)bean).charValue();
    }

    protected final long getLong(Object bean) throws ClassCastException {
        return bean instanceof Number ? ((Number)bean).longValue() : (long)((Character)bean).charValue();
    }

    private void throwInvalidInfix(InfixOperator operator, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.InvalidOperandOfOperator_EXC_"), value != null ? value.toString() : null, operator.toString()));
    }

    private void testValidBitType(Class type, InfixOperator operator) {
        if (!type.isPrimitive() || type == Boolean.TYPE || type == Double.TYPE || type == Float.TYPE) {
            this.throwInvalidInfix(operator, type);
        }
    }

    private void testValidArithmeticType(Class type, InfixOperator operator) {
        if (!type.isPrimitive() || type == Boolean.TYPE) {
            this.throwInvalidInfix(operator, type);
        }
    }

    private void testValidPlusType(Class left, Class right) {
        block12: {
            block11: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (left == clazz) break block11;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (right != clazz2) break block12;
            }
            return;
        }
        this.testValidArithmeticType(left, InfixOperator.IN_PLUS);
        this.testValidArithmeticType(right, InfixOperator.IN_PLUS);
    }

    private void appendToBuffer(StringBuffer sb, Object value, Class valueType) {
        if (value == null) {
            sb.append((Object)null);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (valueType == clazz) {
                sb.append((String)value);
            } else if (valueType.isPrimitive()) {
                switch (this.getEnumForPrimitive(valueType)) {
                    case 0: {
                        sb.append((Boolean)value);
                        break;
                    }
                    case 1: {
                        sb.append(((Number)value).byteValue());
                        break;
                    }
                    case 3: {
                        sb.append(((Character)value).charValue());
                        break;
                    }
                    case 7: {
                        sb.append(((Number)value).doubleValue());
                        break;
                    }
                    case 6: {
                        sb.append(((Number)value).floatValue());
                        break;
                    }
                    case 4: {
                        sb.append(((Number)value).intValue());
                        break;
                    }
                    case 5: {
                        sb.append(((Number)value).longValue());
                        break;
                    }
                    case 2: {
                        sb.append(((Number)value).shortValue());
                    }
                }
            } else {
                sb.append(value);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public final void pushArrayAccess(int indexCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 423->427)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushArrayCreation(Class arrayType, int dimensionCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 310->314)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushArrayInitializer(Class arrayType, int stripCount, int expressionCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 679->683)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushClassInstanceCreation(Class type, int argumentCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [9 : 292->296)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushFieldAccess(Object field, boolean fieldIsString, boolean hasReceiver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [5 : 230->234)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushMethodInvocation(Object method, boolean methodIsString, boolean hasReceiver, int argCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [8 : 330->334)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushConditional(InternalConditionalOperandType expressionType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [5 : 206->209)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushBlockBegin(int blockNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 147->151)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushBlockEnd(int blockNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 151->155)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushBlockBreak(int blockNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 85->89)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushTryBegin(int tryNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 196->200)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushThrowException() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 119->123)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final void throwException(Throwable exception) {
        if (this.topTry == -1) {
            this.processSyntaxException(exception);
        } else if (this.trysInCatch[this.topTry] == null) {
            this.ignoreExpression = TRY_THROW_IGNORE;
            this.breakTry = this.trys[this.topTry];
            this.catchThrowable = exception;
        } else {
            this.ignoreExpression = TRY_FINAL_IGNORE;
            this.trysInCatch[this.topTry] = FINAL_CATCH;
            this.breakTry = this.trys[this.topTry];
            this.catchThrowable = exception;
        }
    }

    /*
     * Exception decompiling
     */
    public final void pushTryCatchClause(int tryNumber, Class exceptionType, InternalExpressionProxy expressionProxy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 329->333)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushTryFinallyClause(int tryNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 189->193)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushTryRethrow(int tryNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 195->199)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void pushTryEnd(int tryNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 215->219)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SaveState createSaveState(int markID) {
        return new SaveState(markID);
    }

    public final void pushMark(int markNumber) {
        if (this.traceOn) {
            this.printTrace("Mark#" + markNumber, false);
        }
        if (this.saveStates == null) {
            this.saveStates = new ArrayList();
        }
        this.saveStates.add(this.createSaveState(markNumber));
        if (this.traceOn) {
            this.printTraceEnd();
        }
    }

    /*
     * Exception decompiling
     */
    public final void pushEndmark(int markID, boolean restore) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 166->170)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static class FieldAccessReference
    extends VariableReference {
        private final Field field;
        private final Object receiver;

        public static FieldAccessReference createFieldAccessReference(Field field, Object receiver) throws IllegalArgumentException {
            if (!Modifier.isStatic(field.getModifiers()) && !field.getDeclaringClass().isInstance(receiver)) {
                throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.CreateFieldAccessReference.FieldsTypesNotMatching_EXC_"), field.getType(), receiver != null ? receiver.getClass() : null));
            }
            field.setAccessible(true);
            return new FieldAccessReference(field, receiver);
        }

        protected FieldAccessReference(Field field, Object receiver) {
            this.field = field;
            this.receiver = receiver;
        }

        public Object dereference() {
            try {
                return this.field.get(this.receiver);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }

        public Object set(Object value, Class type) throws IllegalArgumentException, IllegalAccessException {
            this.field.set(this.receiver, value);
            return this.field.get(this.receiver);
        }

        public String toString() {
            return "FieldAccess{" + this.field.toString() + "} on " + this.receiver.toString();
        }
    }

    protected static class ArrayAccessReference
    extends VariableReference {
        private final Object array;
        private final int index;

        public static ArrayAccessReference createArrayAccessReference(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
            int len = Array.getLength(array);
            if (index < 0 || len <= index) {
                throw new ArrayIndexOutOfBoundsException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.CreateArrayAccessReference.OutOfBounds_EXC_"), new Integer(index), new Integer(len)));
            }
            return new ArrayAccessReference(array, index);
        }

        protected ArrayAccessReference(Object array, int index) {
            this.array = array;
            this.index = index;
        }

        public Object dereference() {
            return Array.get(this.array, this.index);
        }

        public Object set(Object value, Class type) throws IllegalArgumentException {
            Array.set(this.array, this.index, value);
            return Array.get(this.array, this.index);
        }

        public String toString() {
            return "ArrayAccess[" + this.index + "]: " + this.array.toString();
        }
    }

    protected class SaveState {
        public int markID;
        public int topBlock;
        public int breakBlock;
        public int topTry;
        public int breakTry;
        public Throwable catchThrowable;
        public boolean errorOccurred;
        public boolean novalueException;
        public Throwable exception;
        public Object ignoreExpression;
        public int expressionStackPos;
        public int ifElseNesting;
        public int ifElseIgnoreNestCount;
        public boolean ifElseSkipTruePart;
        public int indent;
        public int expressionProxyPos;

        public SaveState(int markID) {
            this.markID = markID;
            ExpressionProcesser ep = ExpressionProcesser.this;
            this.topBlock = ep.topBlock;
            this.breakBlock = ep.breakBlock;
            this.topTry = ep.topTry;
            this.breakTry = ep.breakTry;
            this.catchThrowable = ep.catchThrowable;
            this.errorOccurred = ep.errorOccurred;
            this.novalueException = ep.novalueException;
            this.exception = ep.exception;
            this.ignoreExpression = ep.ignoreExpression;
            this.expressionStackPos = ExpressionProcesser.this.expressionStack.size() - 1;
            this.ifElseNesting = ep.ifElseNesting;
            this.ifElseIgnoreNestCount = ep.ifElseIgnoreNestCount;
            this.ifElseSkipTruePart = ep.ifElseSkipTruePart;
            this.indent = ep.indent;
            this.expressionProxyPos = ExpressionProcesser.this.expressionProxies != null ? ExpressionProcesser.this.expressionProxies.size() - 1 : -1;
        }

        public void restoreState() {
            int i;
            ExpressionProcesser ep = ExpressionProcesser.this;
            ep.topBlock = this.topBlock;
            ep.breakBlock = this.breakBlock;
            ep.topTry = this.topTry;
            ep.breakTry = this.breakTry;
            ep.catchThrowable = this.catchThrowable;
            if (ExpressionProcesser.this.trysInCatch != null) {
                i = this.topTry + 1;
                while (i < ep.trysInCatch.length) {
                    ((ExpressionProcesser)ep).trysInCatch[i] = null;
                    ++i;
                }
            }
            ep.errorOccurred = this.errorOccurred;
            ep.novalueException = ep.novalueException;
            ep.exception = this.exception;
            ep.ignoreExpression = this.ignoreExpression;
            i = ExpressionProcesser.this.expressionStack.size() - 1;
            while (i > this.expressionStackPos) {
                ExpressionProcesser.this.expressionStack.remove(i);
                ExpressionProcesser.this.expressionTypeStack.remove(i);
                --i;
            }
            ep.ifElseNesting = this.ifElseNesting;
            ep.ifElseIgnoreNestCount = this.ifElseIgnoreNestCount;
            ep.ifElseSkipTruePart = this.ifElseSkipTruePart;
            ep.indent = this.indent;
            if (ExpressionProcesser.this.expressionProxies != null) {
                i = ExpressionProcesser.this.expressionProxies.size() - 1;
                while (i > this.expressionProxyPos) {
                    ExpressionProcesser.this.expressionProxies.remove(i);
                    --i;
                }
            }
            ep.conditionalIgnoreNestCount = 0;
            ep.conditionalNesting = 0;
            ep.skipTruePart = false;
            ep.infixIgnoreNestCount = 0;
            ep.infixNesting = 0;
        }
    }
}

