/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.instantiation.base;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.internal.instantiation.PTArrayAccess;
import org.eclipse.jem.internal.instantiation.PTArrayCreation;
import org.eclipse.jem.internal.instantiation.PTArrayInitializer;
import org.eclipse.jem.internal.instantiation.PTBooleanLiteral;
import org.eclipse.jem.internal.instantiation.PTCastExpression;
import org.eclipse.jem.internal.instantiation.PTCharacterLiteral;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTConditionalExpression;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInfixExpression;
import org.eclipse.jem.internal.instantiation.PTInfixOperator;
import org.eclipse.jem.internal.instantiation.PTInstanceof;
import org.eclipse.jem.internal.instantiation.PTInvalidExpression;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.PTNullLiteral;
import org.eclipse.jem.internal.instantiation.PTNumberLiteral;
import org.eclipse.jem.internal.instantiation.PTParenthesizedExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixOperator;
import org.eclipse.jem.internal.instantiation.PTStringLiteral;
import org.eclipse.jem.internal.instantiation.PTThisLiteral;
import org.eclipse.jem.internal.instantiation.PTTypeLiteral;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.base.InstantiationBaseMessages;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;

public class ParseTreeAllocationInstantiationVisitor
extends ParseVisitor {
    private IExpression expression;
    private ForExpression nextExpression = ForExpression.ROOTEXPRESSION;
    static final InfixOperator[] INFIXTOPROXY = new InfixOperator[PTInfixOperator.VALUES.size()];
    static final PrefixOperator[] PREFIXTOPROXY;

    static {
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[15] = InfixOperator.IN_AND;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[17] = InfixOperator.IN_CONDITIONAL_AND;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[18] = InfixOperator.IN_CONDITIONAL_OR;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[1] = InfixOperator.IN_DIVIDE;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[12] = InfixOperator.IN_EQUALS;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[9] = InfixOperator.IN_GREATER;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[11] = InfixOperator.IN_GREATER_EQUALS;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[5] = InfixOperator.IN_LEFT_SHIFT;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[8] = InfixOperator.IN_LESS;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[10] = InfixOperator.IN_LESS_EQUALS;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[4] = InfixOperator.IN_MINUS;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[13] = InfixOperator.IN_NOT_EQUALS;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[16] = InfixOperator.IN_OR;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[3] = InfixOperator.IN_PLUS;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[2] = InfixOperator.IN_REMAINDER;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[6] = InfixOperator.IN_RIGHT_SHIFT_SIGNED;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[7] = InfixOperator.IN_RIGHT_SHIFT_UNSIGNED;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[0] = InfixOperator.IN_TIMES;
        ParseTreeAllocationInstantiationVisitor.INFIXTOPROXY[14] = InfixOperator.IN_XOR;
        PREFIXTOPROXY = new PrefixOperator[PTPrefixOperator.VALUES.size()];
        ParseTreeAllocationInstantiationVisitor.PREFIXTOPROXY[2] = PrefixOperator.PRE_COMPLEMENT;
        ParseTreeAllocationInstantiationVisitor.PREFIXTOPROXY[1] = PrefixOperator.PRE_MINUS;
        ParseTreeAllocationInstantiationVisitor.PREFIXTOPROXY[3] = PrefixOperator.PRE_NOT;
        ParseTreeAllocationInstantiationVisitor.PREFIXTOPROXY[0] = PrefixOperator.PRE_PLUS;
    }

    public static InfixOperator convertPTInfixOperatorToProxyInfixOperator(PTInfixOperator operator) {
        return INFIXTOPROXY[operator.getValue()];
    }

    public static PrefixOperator convertPTPrefixOperatorToProxyPrefixOperator(PTPrefixOperator operator) {
        return PREFIXTOPROXY[operator.getValue()];
    }

    protected final ProxyFactoryRegistry getRegistry() {
        return this.expression.getRegistry();
    }

    protected final IExpression getExpression() {
        return this.expression;
    }

    public IBeanProxy getBeanProxy(PTExpression expression, ProxyFactoryRegistry registry) throws IllegalStateException, IllegalArgumentException, ThrowableProxy, NoExpressionValueException, ProcessingException {
        this.expression = registry.getBeanProxyFactory().createExpression();
        this.setNextExpression(ForExpression.ROOTEXPRESSION);
        try {
            expression.accept(this);
        }
        catch (ProcessingException e) {
            Throwable t = e.getCause();
            if (t instanceof NoExpressionValueException) {
                throw (NoExpressionValueException)t;
            }
            if (t instanceof IllegalStateException) {
                throw (IllegalStateException)t;
            }
            throw e;
        }
        return this.getExpression().getExpressionValue();
    }

    public ExpressionProxy getProxy(PTExpression expression, IExpression expressionProcessor) throws IllegalStateException, IllegalArgumentException, ProcessingException {
        this.expression = expressionProcessor;
        try {
            ExpressionProxy proxy = expressionProcessor.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            this.setNextExpression(ForExpression.ASSIGNMENT_RIGHT);
            expression.accept(this);
            return proxy;
        }
        catch (ProcessingException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalStateException) {
                throw (IllegalStateException)t;
            }
            throw e;
        }
    }

    protected final void setNextExpression(ForExpression nextExpression) {
        this.nextExpression = nextExpression;
    }

    protected final ForExpression getNextExpression() {
        return this.nextExpression;
    }

    public boolean visit(PTArrayAccess node) {
        this.getExpression().createArrayAccess(this.getNextExpression(), node.getIndexes().size());
        this.setNextExpression(ForExpression.ARRAYACCESS_ARRAY);
        node.getArray().accept(this);
        EList idx = node.getIndexes();
        int s = idx.size();
        int i = 0;
        while (i < s) {
            this.setNextExpression(ForExpression.ARRAYACCESS_INDEX);
            ((PTExpression)idx.get(i)).accept(this);
            ++i;
        }
        return false;
    }

    public boolean visit(PTArrayCreation node) {
        this.getExpression().createArrayCreation(this.getNextExpression(), node.getType(), node.getDimensions().size());
        if (node.getDimensions().isEmpty()) {
            node.getInitializer().accept(this);
        } else {
            EList dims = node.getDimensions();
            int s = dims.size();
            int i = 0;
            while (i < s) {
                this.setNextExpression(ForExpression.ARRAYCREATION_DIMENSION);
                ((PTExpression)dims.get(i)).accept(this);
                ++i;
            }
        }
        return false;
    }

    public boolean visit(PTArrayInitializer node) {
        this.getExpression().createArrayInitializer(node.getExpressions().size());
        EList exps = node.getExpressions();
        int s = exps.size();
        int i = 0;
        while (i < s) {
            this.setNextExpression(ForExpression.ARRAYINITIALIZER_EXPRESSION);
            ((PTExpression)exps.get(i)).accept(this);
            ++i;
        }
        return false;
    }

    public boolean visit(PTBooleanLiteral node) {
        this.getExpression().createPrimitiveLiteral(this.getNextExpression(), node.isBooleanValue());
        return false;
    }

    public boolean visit(PTCastExpression node) {
        this.getExpression().createCastExpression(this.getNextExpression(), node.getType());
        this.setNextExpression(ForExpression.CAST_EXPRESSION);
        node.getExpression().accept(this);
        return false;
    }

    public boolean visit(PTCharacterLiteral node) {
        this.getExpression().createPrimitiveLiteral(this.getNextExpression(), node.getCharValue());
        return false;
    }

    public boolean visit(PTClassInstanceCreation node) {
        this.getExpression().createClassInstanceCreation(this.getNextExpression(), node.getType(), node.getArguments().size());
        EList args = node.getArguments();
        int s = args.size();
        int i = 0;
        while (i < s) {
            this.setNextExpression(ForExpression.CLASSINSTANCECREATION_ARGUMENT);
            ((PTExpression)args.get(i)).accept(this);
            ++i;
        }
        return false;
    }

    public boolean visit(PTConditionalExpression node) {
        this.getExpression().createConditionalExpression(this.getNextExpression());
        this.setNextExpression(ForExpression.CONDITIONAL_CONDITION);
        node.getCondition().accept(this);
        this.setNextExpression(ForExpression.CONDITIONAL_TRUE);
        node.getTrue().accept(this);
        this.setNextExpression(ForExpression.CONDITIONAL_FALSE);
        node.getFalse().accept(this);
        return false;
    }

    public boolean visit(PTFieldAccess node) {
        this.getExpression().createFieldAccess(this.getNextExpression(), node.getField(), node.getReceiver() != null);
        if (node.getReceiver() != null) {
            this.setNextExpression(ForExpression.FIELD_RECEIVER);
            node.getReceiver().accept(this);
        }
        return false;
    }

    public boolean visit(PTInfixExpression node) {
        this.getExpression().createInfixExpression(this.getNextExpression(), ParseTreeAllocationInstantiationVisitor.convertPTInfixOperatorToProxyInfixOperator(node.getOperator()), node.getExtendedOperands().size());
        this.setNextExpression(ForExpression.INFIX_LEFT);
        node.getLeftOperand().accept(this);
        this.setNextExpression(ForExpression.INFIX_RIGHT);
        node.getRightOperand().accept(this);
        EList extended = node.getExtendedOperands();
        int s = extended.size();
        int i = 0;
        while (i < s) {
            this.setNextExpression(ForExpression.INFIX_EXTENDED);
            ((PTExpression)extended.get(i)).accept(this);
            ++i;
        }
        return false;
    }

    public boolean visit(PTInstanceof node) {
        this.getExpression().createInstanceofExpression(this.getNextExpression(), node.getType());
        this.setNextExpression(ForExpression.INSTANCEOF_VALUE);
        node.getOperand().accept(this);
        return false;
    }

    public boolean visit(PTInvalidExpression node) {
        throw new IllegalArgumentException(node.getMessage());
    }

    public boolean visit(PTMethodInvocation node) {
        this.getExpression().createMethodInvocation(this.getNextExpression(), node.getName(), node.getReceiver() != null, node.getArguments().size());
        if (node.getReceiver() != null) {
            this.setNextExpression(ForExpression.METHOD_RECEIVER);
            node.getReceiver().accept(this);
        }
        EList args = node.getArguments();
        int s = args.size();
        int i = 0;
        while (i < s) {
            this.setNextExpression(ForExpression.METHOD_ARGUMENT);
            ((PTExpression)args.get(i)).accept(this);
            ++i;
        }
        return false;
    }

    public boolean visit(PTName node) {
        this.getExpression().createTypeReceiver(node.getName());
        return false;
    }

    public boolean visit(PTNullLiteral node) {
        this.getExpression().createNull(this.getNextExpression());
        return false;
    }

    public boolean visit(PTNumberLiteral node) {
        String lit = node.getToken();
        char lastChar = lit.charAt(lit.length() - 1);
        if (lastChar == 'l' || lastChar == 'L') {
            this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Long.decode(lit.substring(0, lit.length() - 1)).longValue());
        } else if (lastChar == 'F' || lastChar == 'f') {
            this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Float.parseFloat(lit.substring(0, lit.length() - 1)));
        } else if (lastChar == 'D' || lastChar == 'd') {
            this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Double.parseDouble(lit.substring(0, lit.length() - 1)));
        } else if (lit.indexOf(46) != -1 || lit.indexOf(101) != -1 || lit.indexOf(69) != -1) {
            this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Double.parseDouble(lit.substring(0, lit.length())));
        } else {
            this.getExpression().createPrimitiveLiteral(this.getNextExpression(), Integer.decode(lit).intValue());
        }
        return false;
    }

    public boolean visit(PTParenthesizedExpression node) {
        node.getExpression().accept(this);
        return false;
    }

    public boolean visit(PTPrefixExpression node) {
        this.getExpression().createPrefixExpression(this.getNextExpression(), ParseTreeAllocationInstantiationVisitor.convertPTPrefixOperatorToProxyPrefixOperator(node.getOperator()));
        this.setNextExpression(ForExpression.PREFIX_OPERAND);
        node.getExpression().accept(this);
        return false;
    }

    public boolean visit(PTStringLiteral node) {
        this.getExpression().createProxyExpression(this.getNextExpression(), (IProxy)this.getRegistry().getBeanProxyFactory().createBeanProxyWith(node.getLiteralValue()));
        return false;
    }

    public boolean visit(PTThisLiteral node) {
        throw new IllegalArgumentException(InstantiationBaseMessages.getString("ParseTreeAllocationInstantiationVisitor.CurrentlyThisNotSupported_EXC_"));
    }

    public boolean visit(PTTypeLiteral node) {
        this.getExpression().createTypeLiteral(this.getNextExpression(), node.getType());
        return false;
    }

    public static class ProcessingException
    extends RuntimeException {
        public ProcessingException(Throwable cause) {
            super(cause);
        }
    }
}

