/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.vm.remote;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.MapTypes;
import org.eclipse.jem.internal.proxy.common.MethodHelper;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.initParser.tree.ExpressionProcesser;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalConditionalOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalExpressionProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalIfElseOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalInfixOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;
import org.eclipse.jem.internal.proxy.vm.remote.ConnectionHandler;
import org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread;

public class ExpressionProcesserController {
    protected final RemoteVMServerThread server;
    protected final ConnectionHandler connHandler;
    protected final ExpressionProcesser exp;
    protected Commands.ValueObject workerValue = new Commands.ValueObject();
    private ClassLoader classLoader;
    private static final List PRIMITIVE_NAMES = Arrays.asList("byte", "char", "short", "int", "long", "float", "double");
    private static final Class[] PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExpressionProcesserController(RemoteVMServerThread server, ConnectionHandler connHandler) {
        this(server, connHandler, new ExpressionProcesser(Boolean.getBoolean("proxyvm.expressionTrace"), Long.getLong("proxyvm.expressionTraceTimerThreshold", -1L).longValue()));
    }

    protected ExpressionProcesserController(RemoteVMServerThread server, ConnectionHandler connHandler, ExpressionProcesser exp) {
        this.server = server;
        this.connHandler = connHandler;
        this.exp = exp;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (className.endsWith("[]")) {
            return this.loadClass(MapTypes.getJNIFormatName((String)className));
        }
        int primIndex = PRIMITIVE_NAMES.indexOf(className);
        if (primIndex >= 0) {
            return PRIMITIVE_TYPES[primIndex];
        }
        if (this.classLoader == null) {
            return Class.forName(className);
        }
        return this.classLoader.loadClass(className);
    }

    public void process(DataInputStream in) throws CommandException, IOException {
        byte subcommand = in.readByte();
        try {
            switch (subcommand) {
                case 12: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    Object value = this.connHandler.getInvokableObject(this.workerValue);
                    if (value == null) {
                        this.exp.pushExpression(null, MethodHelper.NULL_TYPE);
                        break;
                    }
                    if (this.workerValue.isPrimitive()) {
                        this.exp.pushExpression(value, this.workerValue.getPrimitiveType());
                        break;
                    }
                    this.exp.pushExpression(value, value.getClass());
                    break;
                }
                case 4: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    try {
                        Class classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushCast(classValue);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                case 8: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    try {
                        Class classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushInstanceof(classValue);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                case 9: {
                    byte infix_operator = in.readByte();
                    byte infix_operandType = in.readByte();
                    this.exp.pushInfix(InfixOperator.get((int)infix_operator), InternalInfixOperandType.get((int)infix_operandType));
                    break;
                }
                case 11: {
                    byte prefix_operandType = in.readByte();
                    this.exp.pushPrefix(PrefixOperator.get((int)prefix_operandType));
                    break;
                }
                case 1: {
                    int arrayAccess_Indexcount = in.readInt();
                    this.exp.pushArrayAccess(arrayAccess_Indexcount);
                    break;
                }
                case 2: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    int arrayCreation_dimCount = in.readInt();
                    try {
                        Class classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushArrayCreation(classValue, arrayCreation_dimCount);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                case 3: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    int stripCount = in.readInt();
                    int arrayInitializer_expressionCount = in.readInt();
                    try {
                        Class classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushArrayInitializer(classValue, stripCount, arrayInitializer_expressionCount);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                case 6: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    int newInstance_argCount = in.readInt();
                    try {
                        Class classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushClassInstanceCreation(classValue, newInstance_argCount);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                case 14: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    try {
                        Class classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushExpression((Object)classValue, classValue);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                case 7: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    boolean has_fieldAccess_receiver = in.readBoolean();
                    try {
                        Object fieldAccess = this.getFieldValue(this.workerValue);
                        this.exp.pushFieldAccess(fieldAccess, this.workerValue.getType() == 17, has_fieldAccess_receiver);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                    break;
                }
                case 10: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    boolean has_method_receiver = in.readBoolean();
                    int method_argCount = in.readInt();
                    try {
                        Object method = this.getMethodValue(this.workerValue);
                        this.exp.pushMethodInvocation(method, this.workerValue.getType() == 17, has_method_receiver, method_argCount);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    break;
                }
                case 5: {
                    this.exp.pushConditional(InternalConditionalOperandType.get((int)in.readByte()));
                    break;
                }
                case 15: {
                    int proxyid = in.readInt();
                    this.exp.pushAssignment((InternalExpressionProxy)new RemoteExpressionProxy(proxyid));
                    break;
                }
                case 17: {
                    this.exp.pushAssignment();
                    break;
                }
                case 16: {
                    this.exp.pushExpressionProxy(in.readInt());
                    break;
                }
                case 18: {
                    this.exp.pushBlockBegin(in.readInt());
                    break;
                }
                case 19: {
                    this.exp.pushBlockBreak(in.readInt());
                    break;
                }
                case 20: {
                    this.exp.pushBlockEnd(in.readInt());
                    break;
                }
                case 21: {
                    this.exp.pushTryBegin(in.readInt());
                    break;
                }
                case 22: {
                    int tryNumber = in.readInt();
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    int proxyid = in.readInt();
                    try {
                        Class classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushTryCatchClause(tryNumber, classValue, (InternalExpressionProxy)(proxyid != -1 ? new RemoteExpressionProxy(proxyid) : null));
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                case 23: {
                    this.exp.pushTryFinallyClause(in.readInt());
                    break;
                }
                case 24: {
                    this.exp.pushTryEnd(in.readInt());
                    break;
                }
                case 25: {
                    this.exp.pushThrowException();
                    break;
                }
                case 26: {
                    this.exp.pushTryRethrow(in.readInt());
                    break;
                }
                case 13: {
                    int proxyid = in.readInt();
                    String typeName = Commands.readStringData((DataInputStream)in);
                    try {
                        Class classValue = this.loadClass(typeName);
                        RemoteExpressionProxy rep = new RemoteExpressionProxy(proxyid);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("java.lang.Class");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        rep.setProxy(classValue, clazz);
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    catch (ClassNotFoundException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (LinkageError e) {
                        this.exp.processException((Throwable)e);
                    }
                    break;
                }
                case 27: {
                    int proxyid = in.readInt();
                    Commands.ValueObject decClassValue = Commands.readValue((DataInputStream)in, (Commands.ValueObject)new Commands.ValueObject());
                    String methodName = Commands.readStringData((DataInputStream)in);
                    int argCount = in.readInt();
                    Commands.ValueObject[] args = null;
                    if (argCount > 0) {
                        args = new Commands.ValueObject[argCount];
                        int i = 0;
                        while (i < argCount) {
                            args[i] = Commands.readValue((DataInputStream)in, (Commands.ValueObject)new Commands.ValueObject());
                            ++i;
                        }
                    }
                    try {
                        Class decClass = this.getBeanTypeValue(decClassValue);
                        Class[] argClasses = null;
                        if (argCount > 0) {
                            argClasses = new Class[argCount];
                            int i = 0;
                            while (i < argCount) {
                                argClasses[i] = this.getBeanTypeValue(args[i]);
                                ++i;
                            }
                        }
                        Method m = decClass.getMethod(methodName, argClasses);
                        RemoteExpressionProxy rep = new RemoteExpressionProxy(proxyid);
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("java.lang.reflect.Method");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        rep.setProxy(m, clazz);
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoSuchMethodException e) {
                        this.exp.processException((Throwable)e);
                    }
                    break;
                }
                case 28: {
                    int proxyid = in.readInt();
                    Commands.ValueObject decClassValue = Commands.readValue((DataInputStream)in, (Commands.ValueObject)new Commands.ValueObject());
                    String fieldName = Commands.readStringData((DataInputStream)in);
                    try {
                        Class decClass = this.getBeanTypeValue(decClassValue);
                        Field f = decClass.getField(fieldName);
                        RemoteExpressionProxy rep = new RemoteExpressionProxy(proxyid);
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("java.lang.reflect.Method");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        rep.setProxy(f, clazz);
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoSuchFieldException e) {
                        this.exp.processException((Throwable)e);
                    }
                    break;
                }
                case 30: {
                    this.exp.pushIfElse();
                    break;
                }
                case 29: {
                    this.exp.pushIfElse(InternalIfElseOperandType.get((int)in.readByte()));
                    break;
                }
                case 31: {
                    String initString = Commands.readStringData((DataInputStream)in);
                    this.workerValue = Commands.readValue((DataInputStream)in, (Commands.ValueObject)new Commands.ValueObject());
                    try {
                        Class classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushNewInstanceFromString(initString, classValue, this.classLoader);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                case 32: {
                    int markID = in.readInt();
                    this.exp.pushMark(markID);
                    break;
                }
                case 33: {
                    int markID = in.readInt();
                    boolean restore = in.readBoolean();
                    this.exp.pushEndmark(markID, restore);
                }
            }
        }
        catch (RuntimeException e) {
            this.exp.processException((Throwable)e);
        }
        this.workerValue.set();
    }

    protected Class getBeanTypeValue(Commands.ValueObject value) throws ClassCastException, ClassNotFoundException {
        Object beantype = this.connHandler.getInvokableObject(value);
        if (value.type == 3) {
            Object[] expvalue = new Object[2];
            if (this.exp.getExpressionProxyValue(((Integer)beantype).intValue(), expvalue)) {
                beantype = expvalue[0];
            } else {
                throw new ClassNotFoundException();
            }
        }
        return (Class)beantype;
    }

    protected Object getMethodValue(Commands.ValueObject value) throws NoSuchMethodException, ClassCastException {
        Object method = this.connHandler.getInvokableObject(value);
        if (value.type == 3) {
            Object[] expvalue = new Object[2];
            if (this.exp.getExpressionProxyValue(((Integer)method).intValue(), expvalue)) {
                method = expvalue[0];
            } else {
                throw new NoSuchMethodException();
            }
        }
        return method;
    }

    protected Object getFieldValue(Commands.ValueObject value) throws NoSuchFieldException, ClassCastException {
        Object field = this.connHandler.getInvokableObject(value);
        if (value.type == 3) {
            Object[] expvalue = new Object[2];
            if (this.exp.getExpressionProxyValue(((Integer)field).intValue(), expvalue)) {
                field = expvalue[0];
            } else {
                throw new NoSuchFieldException();
            }
        }
        return field;
    }

    public boolean pullExpressionProxyValue(int proxyID, Object[] result) {
        try {
            this.exp.pullExpressionProxyValue(proxyID, result);
            return true;
        }
        catch (NoExpressionValueException noExpressionValueException) {
            return false;
        }
    }

    public Object[] pullValue() throws NoExpressionValueException {
        Object[] result = new Object[2];
        this.exp.pullValue(result);
        return result;
    }

    public void close() {
        this.exp.close();
    }

    public Throwable getErrorThrowable() {
        return this.exp.getErrorThrowable();
    }

    public boolean noErrors() {
        return this.exp.noErrors();
    }

    public boolean isNoExpressionValue() {
        return this.exp.isNoExpressionValue();
    }

    private static class RemoteExpressionProxy
    implements InternalExpressionProxy {
        private final int proxyID;
        private Object value;
        private Class type;
        private boolean set;

        public RemoteExpressionProxy(int proxyID) {
            this.proxyID = proxyID;
        }

        public int getProxyID() {
            return this.proxyID;
        }

        public Class getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isSet() {
            return this.set;
        }

        public void setProxy(Object value, Class type) {
            this.value = value;
            this.type = type;
            this.set = true;
        }
    }
}

