/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.lang.reflect.Array;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.BeanProxyValueSender;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

public final class REMArrayBeanProxy
extends REMBeanProxy
implements IArrayBeanProxy {
    private int fLength = -1;

    REMArrayBeanProxy(REMProxyFactoryRegistry aRegistry, Integer anID, IBeanTypeProxy aType) {
        super(aRegistry, anID, aType);
    }

    public IBeanProxy get(int index) throws ThrowableProxy {
        Object[] parms = new Object[]{this, new Integer(index)};
        IBeanTypeProxy compType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getComponentType();
        if (!compType.isPrimitive()) {
            return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGet()).invokeWithParms(null, parms);
        }
        int id = ((IREMBeanProxy)compType).getID();
        switch (id) {
            case 5: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetByte()).invokeWithParms(null, parms);
            }
            case 1: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetBoolean()).invokeWithParms(null, parms);
            }
            case 7: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetChar()).invokeWithParms(null, parms);
            }
            case 9: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetDouble()).invokeWithParms(null, parms);
            }
            case 11: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetFloat()).invokeWithParms(null, parms);
            }
            case 3: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetInt()).invokeWithParms(null, parms);
            }
            case 15: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetLong()).invokeWithParms(null, parms);
            }
            case 13: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetShort()).invokeWithParms(null, parms);
            }
        }
        return null;
    }

    public IBeanProxy get(int[] indexes) throws ThrowableProxy {
        Object[] parms = new Object[]{this, indexes};
        int dims = ((IArrayBeanTypeProxy)this.getTypeProxy()).getDimensions();
        if (dims < indexes.length) {
            throw new IllegalArgumentException();
        }
        IBeanTypeProxy finalCompType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getFinalComponentType();
        if (dims == indexes.length && finalCompType.isPrimitive()) {
            int id = ((IREMBeanProxy)finalCompType).getID();
            switch (id) {
                case 5: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetByte()).invokeWithParms(null, parms);
                }
                case 1: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetBoolean()).invokeWithParms(null, parms);
                }
                case 7: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetChar()).invokeWithParms(null, parms);
                }
                case 9: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetDouble()).invokeWithParms(null, parms);
                }
                case 11: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetFloat()).invokeWithParms(null, parms);
                }
                case 3: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetInt()).invokeWithParms(null, parms);
                }
                case 15: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetLong()).invokeWithParms(null, parms);
                }
                case 13: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetShort()).invokeWithParms(null, parms);
                }
            }
        } else {
            return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGet()).invokeWithParms(null, parms);
        }
        return null;
    }

    public void set(IBeanProxy value, int index) throws ThrowableProxy {
        Object[] parms = new Object[]{this, new Integer(index), value};
        ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArraySet()).invokeWithParms(null, parms);
    }

    public void set(IBeanProxy value, int[] indexes) throws ThrowableProxy {
        Object[] parms = new Object[]{this, indexes, value};
        ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperSet()).invokeWithParms(null, parms);
    }

    public int getLength() {
        if (this.fLength == -1) {
            this.fLength = ((IIntegerBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetLength().invokeCatchThrowableExceptions(null, (IBeanProxy)this)).intValue();
        }
        return this.fLength;
    }

    public IBeanProxy getCatchThrowableException(int index) {
        try {
            return this.get(index);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBeanProxy[] getSnapshot() throws ThrowableProxy {
        IREMConnection connect = this.fFactory.getFreeConnection();
        REMStandardBeanProxyFactory proxyFactory = (REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory();
        proxyFactory.startTransaction();
        try {
            Commands.ValueObject returnValue = new Commands.ValueObject();
            try {
                try {
                    connect.getArrayContents(this.getID(), returnValue);
                    IBeanProxy[] iBeanProxyArray = this.processReturnValue(connect, returnValue);
                    Object var6_8 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return iBeanProxyArray;
                    this.fFactory.returnConnection(connect);
                    return iBeanProxyArray;
                }
                catch (CommandErrorException e) {
                    proxyFactory.processErrorReturn(e);
                }
            }
            catch (CommandException e) {
                if (e.isRecoverable()) {
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                    IBeanProxy[] iBeanProxyArray = null;
                    Object var6_11 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return iBeanProxyArray;
                    this.fFactory.returnConnection(connect);
                    return iBeanProxyArray;
                }
                this.fFactory.closeConnection(connect);
                connect = null;
                connect = this.fFactory.getFreeConnection();
                try {
                    connect.getArrayContents(this.getID(), returnValue);
                    IBeanProxy[] iBeanProxyArray = this.processReturnValue(connect, returnValue);
                    Object var6_9 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return iBeanProxyArray;
                    this.fFactory.returnConnection(connect);
                    return iBeanProxyArray;
                }
                catch (CommandException eAgain) {
                    this.fFactory.closeConnection(connect);
                    connect = null;
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)eAgain));
                    IBeanProxy[] iBeanProxyArray = null;
                    Object var6_10 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return iBeanProxyArray;
                    this.fFactory.returnConnection(connect);
                    return iBeanProxyArray;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            proxyFactory.stopTransaction();
            if (connect == null) throw throwable;
            this.fFactory.returnConnection(connect);
            throw throwable;
        }
        {
            Object var6_13 = null;
            proxyFactory.stopTransaction();
            if (connect == null) return null;
            this.fFactory.returnConnection(connect);
            return null;
        }
    }

    private IBeanProxy[] processReturnValue(IREMConnection connection, Commands.ValueObject returnValue) throws CommandException, ThrowableProxy {
        BeanProxyValueSender valueSender = new BeanProxyValueSender((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory(), returnValue);
        connection.readProxyArrayValues(returnValue, valueSender, false);
        Exception e = valueSender.getException();
        if (e != null) {
            if (e instanceof ThrowableProxy) {
                throw (ThrowableProxy)((Object)e);
            }
            throw (CommandException)((Object)e);
        }
        Object[] vals = valueSender.getArray();
        IBeanProxy[] proxyArray = new IBeanProxy[Array.getLength(vals)];
        System.arraycopy(vals, 0, proxyArray, 0, proxyArray.length);
        return proxyArray;
    }
}

