/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConstantBeanProxy;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;

public class REMThrowableBeanProxy
extends ThrowableProxy
implements IREMBeanProxy {
    private Integer fID;
    protected final REMProxyFactoryRegistry fFactory;
    private IBeanTypeProxy fTypeProxy;

    protected REMThrowableBeanProxy(REMProxyFactoryRegistry aRegistry, Integer anID, IBeanTypeProxy aType) {
        this.fFactory = aRegistry;
        this.fID = anID;
        this.fTypeProxy = aType;
    }

    public boolean equals(Object anObject) {
        if (super.equals(anObject)) {
            return true;
        }
        if (anObject instanceof IBeanProxy && !(anObject instanceof IREMConstantBeanProxy) && this.fFactory.isValid() && ((IBeanProxy)anObject).getProxyFactoryRegistry() == this.fFactory) {
            try {
                return ((IBooleanBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getObjectEquals().invoke((IBeanProxy)this, (IBeanProxy)anObject)).booleanValue();
            }
            catch (ThrowableProxy throwableProxy) {}
        }
        return false;
    }

    public boolean sameAs(IBeanProxy aBeanProxy) {
        return this == aBeanProxy;
    }

    public Integer getID() {
        return this.fID;
    }

    public boolean isValid() {
        return this.fID != null;
    }

    public void release() {
        this.fID = null;
        this.fTypeProxy = null;
    }

    public ProxyFactoryRegistry getProxyFactoryRegistry() {
        return this.fFactory;
    }

    public IBeanTypeProxy getTypeProxy() {
        return this.fTypeProxy;
    }

    public String toBeanString() {
        IStringBeanProxy string = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getObjectToString().invokeCatchThrowableExceptions((IBeanProxy)this);
        return string != null ? string.stringValue() : null;
    }

    public String getProxyLocalizedMessage() {
        IStringBeanProxy msg = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getThrowableLocalizedMessage().invokeCatchThrowableExceptions((IBeanProxy)this);
        return msg != null ? msg.stringValue() : null;
    }

    public String getProxyMessage() {
        IStringBeanProxy msg = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getThrowableMessage().invokeCatchThrowableExceptions((IBeanProxy)this);
        return msg != null ? msg.stringValue() : null;
    }

    private String getProxyStackTrace() {
        IMethodProxy tempGetStackTrace = this.fFactory.getMethodProxyFactory().getMethodProxy("org.eclipse.jem.internal.proxy.vm.remote.StackTraceUtility", "printStackTrace", new String[]{"java.lang.Throwable"});
        IStringBeanProxy trace = (IStringBeanProxy)tempGetStackTrace.invokeCatchThrowableExceptions(null, (IBeanProxy)this);
        return trace != null ? trace.stringValue() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProxyStackTrace(PrintWriter writer) {
        String trace = this.getProxyStackTrace();
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            writer.print(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProxyStackTrace(PrintStream stream) {
        String trace = this.getProxyStackTrace();
        PrintStream printStream = stream;
        synchronized (printStream) {
            stream.print(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProxyStackTrace() {
        String trace = this.getProxyStackTrace();
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.print(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println(ProxyRemoteMessages.getString("REMOTE_VM_TRACE_INFO_"));
            this.printProxyStackTrace();
            System.err.println(ProxyRemoteMessages.getString("REMOTE_VM_LOCAL_TRACE_INFO_"));
            super.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(ProxyRemoteMessages.getString("REMOTE_VM_TRACE_INFO_"));
            this.printProxyStackTrace(s);
            s.println(ProxyRemoteMessages.getString("REMOTE_VM_LOCAL_TRACE_INFO_"));
            super.printStackTrace(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(ProxyRemoteMessages.getString("REMOTE_VM_TRACE_INFO_"));
            this.printProxyStackTrace(s);
            s.println(ProxyRemoteMessages.getString("REMOTE_VM_LOCAL_TRACE_INFO_"));
            super.printStackTrace(s);
        }
    }

    public void renderBean(Commands.ValueObject value) {
        value.setObjectID(this.getID().intValue());
    }

    public final boolean isBeanProxy() {
        return true;
    }

    public final boolean isExpressionProxy() {
        return false;
    }
}

