/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.beaninfo.adapters.BeanInfoAdapterMessages;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoAdapterFactory;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoJavaReflectionKeyExtension;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoModelSynchronizer;
import org.eclipse.jem.internal.beaninfo.adapters.CreateRegistryJobHandler;
import org.eclipse.jem.internal.beaninfo.adapters.DOMReader;
import org.eclipse.jem.internal.beaninfo.adapters.SpecialResourceSet;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin;
import org.eclipse.jem.internal.beaninfo.core.BeaninfosDoc;
import org.eclipse.jem.internal.beaninfo.core.IBeanInfoContributor;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfoSupplier;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfosDocEntry;
import org.eclipse.jem.internal.beaninfo.core.Init;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.java.adapters.IJavaReflectionKeyExtension;
import org.eclipse.jem.internal.java.adapters.JavaXMIFactoryImpl;
import org.eclipse.jem.internal.java.beaninfo.IIntrospectionAdapter;
import org.eclipse.jem.internal.java.init.JavaInit;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.internal.proxy.core.ConfigurationContributorAdapter;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.util.emf.workbench.ResourceHandler;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class BeaninfoNature
implements IProjectNature {
    public static final String NATURE_ID = "org.eclipse.jem.beaninfo.BeanInfoNature";
    public static final String P_BEANINFO_SEARCH_PATH = ".beaninfoConfig";
    public static final QualifiedName CONFIG_INFO_SESSION_KEY = new QualifiedName("org.eclipse.jem.beaninfo", "CONFIG_INFO");
    public static final QualifiedName BEANINFO_CONTRIBUTORS_SESSION_KEY = new QualifiedName("org.eclipse.jem.beaninfo", "BEANINFO_CONTRIBUTORS");
    private ResourceTracker resourceTracker;
    private ProxyFactoryRegistry.IRegistryListener registryListener = new ProxyFactoryRegistry.IRegistryListener(){

        public void registryTerminated(ProxyFactoryRegistry registry) {
            BeaninfoNature.this.markAllStale();
        }
    };
    private IProject fProject;
    protected ProxyFactoryRegistry fRegistry;
    protected ResourceSet javaRSet;
    protected BeaninfoModelSynchronizer fSynchronizer;
    protected static BeaninfoJavaReflectionKeyExtension fReflectionKeyExtension;
    private static final String PI_CLASS = "class";
    private static final String ENCODING = "UTF-8";
    static final String sBeaninfos = "beaninfos";

    public static BeaninfoNature getRuntime(IProject project) throws CoreException {
        JavaEMFNature.createRuntime((IProject)project);
        if (project.hasNature(NATURE_ID)) {
            return (BeaninfoNature)project.getNature(NATURE_ID);
        }
        return BeaninfoNature.createRuntime(project);
    }

    public static boolean hasRuntime(IProject project) throws CoreException {
        return project.hasNature(NATURE_ID);
    }

    public static boolean isValidProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static BeaninfoNature createRuntime(IProject project) throws CoreException {
        if (!BeaninfoNature.isValidProject(project)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jem.beaninfo", 0, MessageFormat.format(BeanInfoAdapterMessages.getString("INTROSPECT_FAILED_EXC_"), project.getName(), BeanInfoAdapterMessages.getString("BeaninfoNature.InvalidProject")), null));
        }
        BeaninfoNature.addNatureToProject(project, NATURE_ID);
        return (BeaninfoNature)project.getNature(NATURE_ID);
    }

    private static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
        this.removeSharedProperty(P_BEANINFO_SEARCH_PATH, null);
        this.cleanup(true, true);
    }

    public void shutdown() {
        this.cleanup(true, false);
    }

    public ResourceSet newResourceSet() {
        SpecialResourceSet rset = new SpecialResourceSet();
        rset.add(new ResourceHandler(){

            public EObject getEObjectFailed(ResourceSet originatingResourceSet, URI uri, boolean loadOnDemand) {
                return null;
            }

            public Resource getResource(ResourceSet originatingResourceSet, URI uri) {
                return BeaninfoNature.this.getResourceSet().getResource(uri, "java".equals(uri.scheme()));
            }

            public Resource createResource(ResourceSet originatingResourceSet, URI uri) {
                if ("java".equals(uri.scheme())) {
                    return BeaninfoNature.this.getResourceSet().getResource(uri, true);
                }
                return null;
            }
        });
        if (Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("java")) {
            rset.getResourceFactoryRegistry().getExtensionToFactoryMap().put("java", new XMIResourceFactoryImpl());
        }
        return rset;
    }

    protected void cleanup(boolean clearResults, boolean deregister) {
        if (deregister) {
            BeaninfoPlugin.getPlugin().removeBeanInfoNature(this);
        }
        this.getProject().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceTracker);
        this.resourceTracker = null;
        this.fSynchronizer.stopSynchronizer(clearResults);
        Init.cleanup(this.javaRSet, clearResults);
        if (this.fRegistry != null) {
            this.fRegistry.terminateRegistry();
        }
        this.javaRSet = null;
        this.fRegistry = null;
        this.fProject = null;
        this.fSynchronizer = null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
        BeaninfoPlugin.getPlugin().addBeanInfoNature(this);
        try {
            JavaEMFNature javaNature = JavaEMFNature.createRuntime((IProject)this.fProject);
            JavaInit.init();
            if (fReflectionKeyExtension == null) {
                fReflectionKeyExtension = new BeaninfoJavaReflectionKeyExtension();
                JavaXMIFactoryImpl.INSTANCE.registerReflectionKeyExtension((IJavaReflectionKeyExtension)fReflectionKeyExtension);
            }
            this.javaRSet = javaNature.getResourceSet();
            Init.initialize(this.javaRSet, new IBeaninfoSupplier(){

                public ProxyFactoryRegistry getRegistry() {
                    return BeaninfoNature.this.getRegistry();
                }

                public boolean isRegistryCreated() {
                    return BeaninfoNature.this.isRegistryCreated();
                }

                public void closeRegistry() {
                    BeaninfoNature.this.closeRegistry();
                }

                public IProject getProject() {
                    return BeaninfoNature.this.getProject();
                }
            });
            this.fSynchronizer = new BeaninfoModelSynchronizer((BeaninfoAdapterFactory)EcoreUtil.getAdapterFactory((List)this.javaRSet.getAdapterFactories(), (Object)IIntrospectionAdapter.ADAPTER_KEY), JavaCore.create((IProject)javaNature.getProject()));
            this.resourceTracker = new ResourceTracker();
            project.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceTracker, 6);
        }
        catch (CoreException e) {
            BeaninfoPlugin.getPlugin().getLogger().log((Object)e.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeRegistry() {
        ProxyFactoryRegistry reg = null;
        BeaninfoNature beaninfoNature = this;
        synchronized (beaninfoNature) {
            reg = this.fRegistry;
            this.fRegistry = null;
            try {
                this.getProject().setSessionProperty(CONFIG_INFO_SESSION_KEY, null);
                this.getProject().setSessionProperty(BEANINFO_CONTRIBUTORS_SESSION_KEY, null);
            }
            catch (CoreException e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.INFO);
            }
        }
        if (reg != null) {
            reg.removeRegistryListener(this.registryListener);
            reg.terminateRegistry();
        }
    }

    public static void computeBeanInfoConfigInfo(IConfigurationContributionInfo info) throws CoreException {
        Object contributor;
        int i;
        IConfigurationElement[] contributors;
        Map.Entry entry;
        ArrayList<Object> contributorsList = new ArrayList<Object>(10);
        if (!info.getContainerIds().isEmpty()) {
            Iterator containerIdItr = info.getContainerIds().entrySet().iterator();
            while (containerIdItr.hasNext()) {
                entry = containerIdItr.next();
                if (!((Boolean)entry.getValue()).booleanValue() || (contributors = BeaninfoPlugin.getPlugin().getContainerIdContributors((String)entry.getKey())) == null) continue;
                i = 0;
                while (i < contributors.length) {
                    try {
                        contributor = contributors[i].createExecutableExtension(PI_CLASS);
                        if (contributor instanceof IBeanInfoContributor) {
                            contributorsList.add(contributor);
                        }
                    }
                    catch (CoreException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
                    }
                    ++i;
                }
            }
        }
        if (!info.getPluginIds().isEmpty()) {
            Iterator pluginIdItr = info.getPluginIds().entrySet().iterator();
            while (pluginIdItr.hasNext()) {
                entry = pluginIdItr.next();
                if (!((Boolean)entry.getValue()).booleanValue() || (contributors = BeaninfoPlugin.getPlugin().getPluginContributors((String)entry.getKey())) == null) continue;
                i = 0;
                while (i < contributors.length) {
                    try {
                        contributor = contributors[i].createExecutableExtension(PI_CLASS);
                        if (contributor instanceof IBeanInfoContributor) {
                            contributorsList.add(contributor);
                        }
                    }
                    catch (CoreException e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
                    }
                    ++i;
                }
            }
        }
        IBeanInfoContributor[] explicitContributors = contributorsList.toArray(new IBeanInfoContributor[contributorsList.size()]);
        info.getJavaProject().getProject().setSessionProperty(BEANINFO_CONTRIBUTORS_SESSION_KEY, (Object)explicitContributors);
        info.getJavaProject().getProject().setSessionProperty(CONFIG_INFO_SESSION_KEY, (Object)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyFactoryRegistry getRegistry() {
        BeaninfoNature beaninfoNature = this;
        synchronized (beaninfoNature) {
            if (this.fRegistry != null) {
                return this.fRegistry;
            }
        }
        CreateRegistryJobHandler.createRegistry(this);
        return this.fRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createRegistry(IProgressMonitor pm) {
        pm.beginTask(BeanInfoAdapterMessages.getString("UICreateRegistryJobHandler.StartBeaninfoRegistry"), 100);
        if (this.isRegistryCreated()) {
            pm.done();
            return;
        }
        try {
            try {
                ConfigurationContributor configurationContributor = (ConfigurationContributor)this.getConfigurationContributor();
                configurationContributor.setNature(this);
                ProxyFactoryRegistry registry = ProxyLaunchSupport.startImplementation((IProject)this.fProject, (String)"Beaninfo", (IConfigurationContributor[])new IConfigurationContributor[]{configurationContributor}, (boolean)false, (IProgressMonitor)new SubProgressMonitor(pm, 100));
                registry.addRegistryListener(this.registryListener);
                BeaninfoNature beaninfoNature = this;
                synchronized (beaninfoNature) {
                    this.fRegistry = registry;
                }
            }
            catch (CoreException e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Object)e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        pm.done();
    }

    public synchronized boolean isRegistryCreated() {
        return this.fRegistry != null;
    }

    public boolean isValidNature() {
        return this.fProject != null;
    }

    protected void setProxySearchPath(ProxyFactoryRegistry registry, List searchPaths) {
        if (searchPaths != null) {
            String[] stringSearchPath = searchPaths.toArray(new String[searchPaths.size()]);
            Utilities.setBeanInfoSearchPath(registry, stringSearchPath);
        } else {
            Utilities.setBeanInfoSearchPath(registry, null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BeaninfosDoc getSearchPath() {
        BeaninfosDoc bdoc = null;
        try {
            InputStream property = this.getSharedProperty(P_BEANINFO_SEARCH_PATH);
            if (property == null) return bdoc;
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new InputStreamReader(property, ENCODING)));
                Element root = doc.getDocumentElement();
                if (root != null && root.getNodeName().equalsIgnoreCase(sBeaninfos)) {
                    bdoc = BeaninfosDoc.readEntry(new DOMReader(), root, this.getProject());
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    property.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_9 = null;
                try {}
                catch (IOException iOException) {
                    return bdoc;
                }
                property.close();
                return bdoc;
            }
        }
        catch (CoreException e) {
            BeaninfoPlugin.getPlugin().getLogger().log((Object)e.getStatus());
            return bdoc;
        }
        catch (Exception e) {
            BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "", (Throwable)e));
        }
        return bdoc;
    }

    public void setSearchPath(BeaninfosDoc searchPath) throws CoreException {
        this.setSearchPath(searchPath, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSearchPath(BeaninfosDoc searchPath, IProgressMonitor monitor) throws CoreException {
        String property = null;
        if (searchPath != null && searchPath.getSearchpath().length > 0) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element root = doc.createElement(sBeaninfos);
                IBeaninfosDocEntry[] entries = searchPath.getSearchpath();
                int i = 0;
                while (true) {
                    if (i >= entries.length) {
                        doc.appendChild(root);
                        StringWriter strWriter = new StringWriter();
                        StreamResult result = new StreamResult(strWriter);
                        DOMSource source = new DOMSource(doc);
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("method", "xml");
                        transformer.transform(source, result);
                        property = strWriter.toString();
                        break;
                    }
                    root.appendChild(entries[i].writeEntry(doc, this.getProject()));
                    ++i;
                }
            }
            catch (TransformerConfigurationException e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
            }
            catch (TransformerException e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
            }
            catch (ParserConfigurationException e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
            }
            catch (FactoryConfigurationError e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
            }
        }
        if (property == null) {
            this.removeSharedProperty(P_BEANINFO_SEARCH_PATH, monitor);
            return;
        }
        InputStream is = this.getSharedProperty(P_BEANINFO_SEARCH_PATH);
        if (is != null) {
            Object var9_15;
            block22: {
                try {
                    try {
                        InputStreamReader reader = new InputStreamReader(is, ENCODING);
                        char[] chars = new char[1000];
                        StringBuffer oldProperty = new StringBuffer(1000);
                        int read = reader.read(chars);
                        while (true) {
                            if (read == -1) {
                                if (!oldProperty.toString().equals(property)) break block22;
                                var9_15 = null;
                                break;
                            }
                            oldProperty.append(chars, 0, read);
                            read = reader.read(chars);
                        }
                    }
                    catch (IOException iOException) {
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    var9_15 = null;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
                return;
            }
            var9_15 = null;
            try {}
            catch (IOException iOException) {}
            is.close();
        }
        this.setSharedProperty(P_BEANINFO_SEARCH_PATH, property, monitor);
    }

    public ResourceSet getResourceSet() {
        return this.javaRSet;
    }

    protected void markAllStale() {
        if (this.fRegistry != null) {
            this.fSynchronizer.getAdapterFactory().markAllStale();
        }
    }

    protected String computeSharedPropertyFileName(QualifiedName qName) {
        return qName.getLocalName();
    }

    protected InputStream getSharedProperty(String propertyFileName) throws CoreException {
        IFile rscFile = this.getProject().getFile(propertyFileName);
        if (rscFile.exists()) {
            return rscFile.getContents(true);
        }
        return null;
    }

    protected void setSharedProperty(String propertyName, String value, IProgressMonitor monitor) throws CoreException {
        try {
            IFile rscFile = this.getProject().getFile(propertyName);
            ByteArrayInputStream input = new ByteArrayInputStream(value.getBytes(ENCODING));
            if (rscFile.exists()) {
                rscFile.setContents((InputStream)input, true, false, null);
            } else {
                rscFile.create((InputStream)input, true, monitor);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    protected void removeSharedProperty(String propertyName, IProgressMonitor monitor) throws CoreException {
        IFile rscFile = this.getProject().getFile(propertyName);
        rscFile.delete(true, true, monitor);
    }

    public IConfigurationContributor getConfigurationContributor() {
        return new ConfigurationContributor(this.getSearchPath());
    }

    private class ResourceTracker
    implements IResourceChangeListener {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResource eventResource = e.getResource();
            if (eventResource.getName().equals(BeaninfoNature.this.getProject().getName()) && eventResource.equals((Object)BeaninfoNature.this.getProject())) {
                BeaninfoNature.this.cleanup(false, true);
                return;
            }
        }
    }

    private static class ConfigurationContributor
    extends ConfigurationContributorAdapter {
        private BeaninfosDoc doc;
        List computedSearchPath;
        private BeaninfoNature nature;
        private IConfigurationContributionInfo info;
        private IBeanInfoContributor[] explicitContributors;
        private static final IBeaninfosDocEntry[] EMPTY_ENTRIES = new IBeaninfosDocEntry[0];

        public ConfigurationContributor(BeaninfosDoc doc) {
            this.doc = doc;
        }

        public void setNature(BeaninfoNature nature) {
            this.nature = nature;
            if (nature != null) {
                this.computedSearchPath = new ArrayList(3);
            }
        }

        public void initialize(IConfigurationContributionInfo info) {
            this.info = info;
            try {
                if (info.getJavaProject().getProject().getSessionProperty(CONFIG_INFO_SESSION_KEY) == null) {
                    BeaninfoNature.computeBeanInfoConfigInfo(info);
                }
                this.explicitContributors = (IBeanInfoContributor[])info.getJavaProject().getProject().getSessionProperty(BEANINFO_CONTRIBUTORS_SESSION_KEY);
            }
            catch (CoreException e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
            }
        }

        public void contributeClasspaths(IConfigurationContributionController controller) throws CoreException {
            Map.Entry entry;
            this.contributeClasspathsForProject(controller, this.info.getJavaProject().getProject(), this.doc, true);
            if (!this.info.getProjectPaths().isEmpty()) {
                IWorkspaceRoot root = this.info.getJavaProject().getProject().getWorkspace().getRoot();
                Iterator projIter = this.info.getProjectPaths().entrySet().iterator();
                while (projIter.hasNext()) {
                    IResource res;
                    Map.Entry entry2 = projIter.next();
                    if (!((Boolean)entry2.getValue()).booleanValue() || !((res = root.findMember((IPath)entry2.getKey())) instanceof IProject) || !((IProject)res).isOpen() || !BeaninfoNature.hasRuntime((IProject)res)) continue;
                    this.contributeClasspathsForProject(controller, (IProject)res, BeaninfoNature.getRuntime((IProject)res).getSearchPath(), false);
                }
            }
            if (!this.info.getContainerIds().isEmpty()) {
                Iterator containerIdItr = this.info.getContainerIds().entrySet().iterator();
                while (containerIdItr.hasNext()) {
                    entry = containerIdItr.next();
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    this.processBeaninfoEntries(BeaninfoPlugin.getPlugin().getContainerIdBeanInfos((String)entry.getKey()), controller, this.info.getJavaProject());
                }
            }
            if (!this.info.getPluginIds().isEmpty()) {
                Iterator pluginIdItr = this.info.getPluginIds().entrySet().iterator();
                while (pluginIdItr.hasNext()) {
                    entry = pluginIdItr.next();
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    this.processBeaninfoEntries(BeaninfoPlugin.getPlugin().getPluginBeanInfos((String)entry.getKey()), controller, this.info.getJavaProject());
                }
            }
            if (!this.info.getContainers().isEmpty()) {
                Iterator containerItr = this.info.getContainers().entrySet().iterator();
                while (containerItr.hasNext()) {
                    entry = containerItr.next();
                    if (!((Boolean)entry.getValue()).booleanValue() || !(entry.getKey() instanceof IBeanInfoContributor)) continue;
                    this.processBeaninfoEntries(((IBeanInfoContributor)entry.getKey()).getBeanInfoEntryContributions(this.info), controller, this.info.getJavaProject());
                }
            }
            int i = 0;
            while (i < this.explicitContributors.length) {
                IBeanInfoContributor contributor = this.explicitContributors[i];
                this.processBeaninfoEntries(contributor.getBeanInfoEntryContributions(this.info), controller, this.info.getJavaProject());
                if (contributor instanceof IConfigurationContributor) {
                    Platform.run((ISafeRunnable)new ISafeRunnable(this, contributor, controller){
                        final /* synthetic */ ConfigurationContributor this$1;
                        private final /* synthetic */ IBeanInfoContributor val$contributor;
                        private final /* synthetic */ IConfigurationContributionController val$controller;
                        {
                            this.this$1 = configurationContributor;
                            this.val$contributor = iBeanInfoContributor;
                            this.val$controller = iConfigurationContributionController;
                        }

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            if (this.val$contributor instanceof IConfigurationContributor) {
                                ((IConfigurationContributor)this.val$contributor).contributeClasspaths(this.val$controller);
                            }
                        }
                    });
                }
                ++i;
            }
            controller.contributeClasspath(BeaninfoPlugin.getPlugin().getBundle(), "beaninfocommon.jar", 0, true);
            controller.contributeClasspath(BeaninfoPlugin.getPlugin().getBundle(), "vm/beaninfovm.jar", 0, true);
        }

        private IClasspathEntry get(IClasspathEntry[] array, SearchpathEntry se) {
            int i = 0;
            while (i < array.length) {
                if (array[i].getEntryKind() == se.getKind() && array[i].getPath().equals((Object)se.getPath())) {
                    return array[i];
                }
                ++i;
            }
            return null;
        }

        protected void contributeClasspathsForProject(IConfigurationContributionController controller, IProject project, BeaninfosDoc doc, boolean toplevelProject) throws CoreException {
            IJavaProject jProject = JavaCore.create((IProject)project);
            IClasspathEntry[] rawPath = jProject.getRawClasspath();
            IBeaninfosDocEntry[] entries = doc != null ? doc.getSearchpath() : EMPTY_ENTRIES;
            int i = 0;
            while (i < entries.length) {
                IBeaninfosDocEntry entry = entries[i];
                if (entry instanceof BeaninfoEntry) {
                    BeaninfoEntry be = (BeaninfoEntry)entry;
                    if (toplevelProject || be.isExported()) {
                        this.processBeaninfoEntry(be, controller, jProject);
                    }
                } else if (this.nature != null) {
                    String pkg;
                    IClasspathEntry cpe;
                    SearchpathEntry se = (SearchpathEntry)entry;
                    if ((toplevelProject || (cpe = this.get(rawPath, se)) != null && (cpe.getEntryKind() == 3 || cpe.isExported())) && (pkg = se.getPackage()) != null && !this.computedSearchPath.contains(pkg)) {
                        this.computedSearchPath.add(pkg);
                    }
                }
                ++i;
            }
        }

        protected void processBeaninfoEntries(BeaninfoEntry[] entries, IConfigurationContributionController controller, IJavaProject javaProject) throws CoreException {
            if (entries != null) {
                int i = 0;
                while (i < entries.length) {
                    this.processBeaninfoEntry(entries[i], controller, javaProject);
                    ++i;
                }
            }
        }

        protected void processBeaninfoEntry(BeaninfoEntry entry, IConfigurationContributionController controller, IJavaProject javaProject) throws CoreException {
            Object[] cps = entry.getClasspath(javaProject);
            int j = 0;
            while (j < cps.length) {
                IPath path;
                Bundle bundle;
                Object cp = cps[j];
                if (cp instanceof IProject) {
                    controller.contributeProject((IProject)cp);
                } else if (cp instanceof String) {
                    controller.contributeClasspath(ProxyLaunchSupport.convertStringPathToURL((String)((String)cp)), 0);
                } else if (cp instanceof IPath && (bundle = Platform.getBundle((String)(path = (IPath)cp).segment(0))) != null) {
                    controller.contributeClasspath(bundle, path.removeFirstSegments(1), 0, true);
                }
                ++j;
            }
            if (this.nature != null) {
                SearchpathEntry[] sees = entry.getSearchPaths();
                int j2 = 0;
                while (j2 < sees.length) {
                    SearchpathEntry searchpathEntry = sees[j2];
                    if (!this.computedSearchPath.contains(searchpathEntry.getPackage())) {
                        this.computedSearchPath.add(searchpathEntry.getPackage());
                    }
                    ++j2;
                }
            }
        }

        public void contributeToConfiguration(ILaunchConfigurationWorkingCopy config) {
            int i = 0;
            while (i < this.explicitContributors.length) {
                int ii = i++;
                Platform.run((ISafeRunnable)new ISafeRunnable(this, ii, config){
                    final /* synthetic */ ConfigurationContributor this$1;
                    private final /* synthetic */ int val$ii;
                    private final /* synthetic */ ILaunchConfigurationWorkingCopy val$config;
                    {
                        this.this$1 = configurationContributor;
                        this.val$ii = n;
                        this.val$config = iLaunchConfigurationWorkingCopy;
                    }

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        IBeanInfoContributor contributor = ConfigurationContributor.access$0(this.this$1)[this.val$ii];
                        if (contributor instanceof IConfigurationContributor) {
                            ((IConfigurationContributor)contributor).contributeToConfiguration(this.val$config);
                        }
                    }
                });
            }
        }

        public void contributeToRegistry(ProxyFactoryRegistry registry) {
            if (this.nature != null) {
                this.nature.setProxySearchPath(registry, this.computedSearchPath);
            }
            int i = 0;
            while (i < this.explicitContributors.length) {
                int ii = i++;
                Platform.run((ISafeRunnable)new ISafeRunnable(this, ii, registry){
                    final /* synthetic */ ConfigurationContributor this$1;
                    private final /* synthetic */ int val$ii;
                    private final /* synthetic */ ProxyFactoryRegistry val$registry;
                    {
                        this.this$1 = configurationContributor;
                        this.val$ii = n;
                        this.val$registry = proxyFactoryRegistry;
                    }

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        IBeanInfoContributor contributor = ConfigurationContributor.access$0(this.this$1)[this.val$ii];
                        if (contributor instanceof IConfigurationContributor) {
                            ((IConfigurationContributor)contributor).contributeToRegistry(this.val$registry);
                        }
                    }
                });
            }
        }

        static /* synthetic */ IBeanInfoContributor[] access$0(ConfigurationContributor configurationContributor) {
            return configurationContributor.explicitContributors;
        }
    }
}

