/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.common;

import java.util.HashMap;

public class MapTypes {
    public static final HashMap MAP_SHORTSIG_TO_TYPE = new HashMap(8);
    public static final HashMap MAP_TYPENAME_TO_SHORTSIG = new HashMap(8);

    static {
        MAP_SHORTSIG_TO_TYPE.put("B", Byte.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("C", Character.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("D", Double.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("F", Float.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("I", Integer.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("J", Long.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("S", Short.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("Z", Boolean.TYPE);
        MAP_TYPENAME_TO_SHORTSIG.put("byte", "B");
        MAP_TYPENAME_TO_SHORTSIG.put("char", "C");
        MAP_TYPENAME_TO_SHORTSIG.put("double", "D");
        MAP_TYPENAME_TO_SHORTSIG.put("float", "F");
        MAP_TYPENAME_TO_SHORTSIG.put("int", "I");
        MAP_TYPENAME_TO_SHORTSIG.put("long", "J");
        MAP_TYPENAME_TO_SHORTSIG.put("short", "S");
        MAP_TYPENAME_TO_SHORTSIG.put("boolean", "Z");
    }

    public static String getJNIFormatName(String classname) {
        int firstOpenBracket;
        if (classname.length() == 0 || !classname.endsWith("]")) {
            return classname;
        }
        StringBuffer jni = new StringBuffer(classname.length());
        int ob = firstOpenBracket = classname.indexOf(91);
        while (ob > -1) {
            int cb = classname.indexOf(93, ob);
            if (cb == -1) break;
            jni.append('[');
            ob = classname.indexOf(91, cb);
        }
        String finalType = classname.substring(0, firstOpenBracket).trim();
        if (finalType != null) {
            String shortSig = (String)MAP_TYPENAME_TO_SHORTSIG.get(finalType);
            if (shortSig == null) {
                jni.append('L');
                jni.append(finalType);
                jni.append(';');
            } else {
                jni.append(shortSig);
            }
        }
        return jni.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static String getFormalTypeName(String jniName) {
        if (jniName.charAt(0) != '[') {
            if (jniName.length() != 1) return jniName;
            Class type = (Class)MAP_SHORTSIG_TO_TYPE.get(jniName);
            if (type == null) return jniName;
            return type.getName();
        }
        int dims = jniName.lastIndexOf(91) + 1;
        int startType = dims + 1;
        StringBuffer fName = new StringBuffer(jniName.length() + 2 * dims);
        if (jniName.charAt(dims) == 'L') {
            fName.append(jniName.substring(startType, jniName.length() - 1));
        } else {
            if (jniName.length() != startType + 1) return "";
            Class type = (Class)MAP_SHORTSIG_TO_TYPE.get(jniName.substring(startType, startType));
            if (type == null) return "";
            fName.append(type.getName());
        }
        while (dims-- > 0) {
            fName.append("[]");
        }
        return fName.toString();
    }

    public static String getJNITypeName(String finalComponent, int dimensions) {
        StringBuffer jni = new StringBuffer(finalComponent.length() + dimensions + 2);
        while (dimensions-- > 0) {
            jni.append('[');
        }
        String shortSig = (String)MAP_TYPENAME_TO_SHORTSIG.get(finalComponent);
        if (shortSig == null) {
            jni.append('L');
            jni.append(finalComponent);
            jni.append(';');
        } else {
            jni.append(shortSig);
        }
        return jni.toString();
    }
}

