/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.workbench.utility;

import java.text.MessageFormat;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.workbench.utility.ParseTreeCreationFromAST;
import org.eclipse.jem.workbench.utility.WorkbenchUtilityMessages;

public class ASTBoundResolver
extends ParseTreeCreationFromAST.Resolver {
    public PTExpression resolveName(Name name) {
        IBinding binding = name.resolveBinding();
        if (binding == null) {
            return null;
        }
        switch (binding.getKind()) {
            case 2: {
                String typename = this.getTypeName((ITypeBinding)binding);
                PTName ptname = InstantiationFactory.eINSTANCE.createPTName();
                ptname.setName(typename);
                return ptname;
            }
            case 3: {
                IVariableBinding variableBinding = (IVariableBinding)binding;
                if (variableBinding.isField()) {
                    if (Modifier.isStatic((int)variableBinding.getModifiers())) {
                        PTFieldAccess fa = InstantiationFactory.eINSTANCE.createPTFieldAccess();
                        if (name.isQualifiedName()) {
                            fa.setReceiver(this.resolveName(((QualifiedName)name).getQualifier()));
                        }
                        fa.setField(variableBinding.getName());
                        return fa;
                    }
                    this.throwInvalidExpressionException(MessageFormat.format(WorkbenchUtilityMessages.getString("ASTBoundResolver.CannotHandleLocalField_EXC_"), variableBinding.getName()));
                    break;
                }
                this.throwInvalidExpressionException(MessageFormat.format(WorkbenchUtilityMessages.getString("ASTBoundResolver.CannotHandleLocalVariable_EXC_"), variableBinding.getName()));
            }
        }
        return null;
    }

    public String resolveType(Type type) {
        ITypeBinding binding = type.resolveBinding();
        return binding != null ? this.getTypeName(binding) : null;
    }

    public String resolveType(Name name) throws ParseTreeCreationFromAST.InvalidExpressionException {
        ITypeBinding binding = name.resolveTypeBinding();
        return binding != null ? this.getTypeName(binding) : null;
    }

    protected String getTypeName(ITypeBinding typeBinding) {
        if (typeBinding.isArray()) {
            StringBuffer name = new StringBuffer(this.getTypeName(typeBinding.getElementType()));
            int dimensions = typeBinding.getDimensions();
            int i = 0;
            while (i < dimensions) {
                name.append("[]");
                ++i;
            }
            return name.toString();
        }
        StringBuffer name = new StringBuffer(typeBinding.getName());
        IPackageBinding packageBinding = typeBinding.getPackage();
        typeBinding = typeBinding.getDeclaringClass();
        while (typeBinding != null) {
            name.insert(0, '$').insert(0, typeBinding.getName());
            typeBinding = typeBinding.getDeclaringClass();
        }
        if (packageBinding != null && !packageBinding.isUnnamed()) {
            name.insert(0, '.').insert(0, packageBinding.getName());
        }
        return name.toString();
    }

    public PTExpression resolveThis() throws ParseTreeCreationFromAST.InvalidExpressionException {
        return InstantiationFactory.eINSTANCE.createPTThisLiteral();
    }
}

