/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.ui.BPListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPSearchListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoPathsBlock;
import org.eclipse.jem.internal.beaninfo.ui.BuildSearchBasePage;
import org.eclipse.jem.internal.beaninfo.ui.PackageOnlyContentProvider;
import org.eclipse.jem.internal.beaninfo.ui.SPListElementSorter;
import org.eclipse.jem.internal.beaninfo.ui.SearchPathListLabelProvider;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class PackagesWorkbookPage
extends BuildSearchBasePage {
    private BeaninfoPathsBlock biPathsBlock;
    private IJavaProject fCurrJProject;
    private Control fSWTControl;
    private ListDialogField fSearchPackagesList;
    private IPackageFragmentRoot[][] rootsPerRawEntry;
    private IClasspathEntry[] rawList;
    SearchPathListLabelProvider labelProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public PackagesWorkbookPage(IWorkspaceRoot root, BeaninfoPathsBlock biPathsBlock, List interestedFieldsForEnableControl) {
        this.biPathsBlock = biPathsBlock;
        this.fSWTControl = null;
        PackagesAdapter adapter = new PackagesAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = BeanInfoUIMessages.getString("PackagesWorkbook.ChoosePackages");
        stringArray[1] = BeanInfoUIMessages.getString("PackagesWorkbook.ChooseDefinedPaths");
        stringArray[3] = BeanInfoUIMessages.getString("PackagesWorkbook.Remove");
        String[] buttonLabels = stringArray;
        this.labelProvider = new SearchPathListLabelProvider();
        this.fSearchPackagesList = new ListDialogField((IListAdapter)adapter, buttonLabels, (ILabelProvider)this.labelProvider);
        this.fSearchPackagesList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fSearchPackagesList.setLabelText(BeanInfoUIMessages.getString("PackagesWorkbook.LabelText"));
        this.fSearchPackagesList.setRemoveButtonIndex(3);
        this.fSearchPackagesList.setViewerSorter((ViewerSorter)new SPListElementSorter());
        interestedFieldsForEnableControl.add(this.fSearchPackagesList);
    }

    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        this.labelProvider.setJavaProject(jproject);
        try {
            this.rawList = this.fCurrJProject.getRawClasspath();
            this.rootsPerRawEntry = new IPackageFragmentRoot[this.rawList.length][];
            int i = 0;
            while (i < this.rawList.length) {
                this.rootsPerRawEntry[i] = this.fCurrJProject.findPackageFragmentRoots(this.rawList[i]);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            this.rawList = new IClasspathEntry[0];
            this.rootsPerRawEntry = new IPackageFragmentRoot[0][];
        }
        this.updatePackagesList();
    }

    private void updatePackagesList() {
        List spelements = this.biPathsBlock.getSearchOrder().getElements();
        ArrayList<BPListElement> packageElements = new ArrayList<BPListElement>(spelements.size());
        int i = 0;
        while (i < spelements.size()) {
            BPListElement spe = (BPListElement)spelements.get(i);
            if (spe instanceof BPSearchListElement) {
                packageElements.add(spe);
            }
            ++i;
        }
        this.fSearchPackagesList.setElements(packageElements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fSearchPackagesList}, (boolean)true, (int)-1, (int)-1);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fSearchPackagesList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JEMUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void packagesPageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fSearchPackagesList) {
            List elementsToAdd = null;
            if (index == 0) {
                elementsToAdd = this.choosePackages();
            } else if (index == 1) {
                elementsToAdd = this.chooseDefined();
            }
            if (elementsToAdd != null && !elementsToAdd.isEmpty()) {
                this.fSearchPackagesList.addElements(elementsToAdd);
                this.fSearchPackagesList.postSetSelection((ISelection)new StructuredSelection(elementsToAdd));
            }
        }
    }

    private void packagesPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (field == this.fSearchPackagesList) {
            this.updateSearchpathList();
        }
    }

    private void updateSearchpathList() {
        List searchelements = this.biPathsBlock.getSearchOrder().getElements();
        List packageelements = this.fSearchPackagesList.getElements();
        boolean changeDone = false;
        ListIterator spitr = searchelements.listIterator(searchelements.size());
        while (spitr.hasPrevious()) {
            BPListElement element = (BPListElement)spitr.previous();
            if (!(element instanceof BPSearchListElement) || packageelements.remove(element)) continue;
            spitr.remove();
            changeDone = true;
        }
        searchelements.addAll(packageelements);
        boolean bl = changeDone = changeDone || !packageelements.isEmpty();
        if (changeDone) {
            this.biPathsBlock.setSearchOrderElements(searchelements);
        }
    }

    public List getSelection() {
        return this.fSearchPackagesList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fSearchPackagesList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    private List choosePackages() {
        ChoosePackagesSelectionValidator validator = new ChoosePackagesSelectionValidator();
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.IPackageFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class[] acceptedClasses = classArray;
        Object[] rejectedFragments = this.getFilteredExistingEntries();
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedFragments){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (super.select(viewer, parentElement, element)) {
                    if (element instanceof IPackageFragment) {
                        IPackageFragment pkg = (IPackageFragment)element;
                        try {
                            return pkg.hasChildren();
                        }
                        catch (JavaModelException javaModelException) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        PackageOnlyContentProvider provider = new PackageOnlyContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setTitle(BeanInfoUIMessages.getString("BeaninfoPathsBlock_UI_.addsearchpath.title"));
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(BeanInfoUIMessages.getString("BeaninfoPathsBlock_UI_.addsearchpath.description"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fCurrJProject);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            ArrayList<BPListElement> newElements = new ArrayList<BPListElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                BPListElement newGuy = this.newBPListElement(elements[i]);
                if (newGuy != null) {
                    newElements.add(newGuy);
                }
                ++i;
            }
            return newElements;
        }
        return Collections.EMPTY_LIST;
    }

    protected Object[] getFilteredExistingEntries() {
        try {
            IPackageFragmentRoot[] roots = this.fCurrJProject.getPackageFragmentRoots();
            List entries = this.fSearchPackagesList.getElements();
            ArrayList fragments = new ArrayList(entries.size());
            Iterator itr = entries.iterator();
            while (itr.hasNext()) {
                BPListElement elem = (BPListElement)itr.next();
                if (!(elem instanceof BPSearchListElement)) continue;
                BPSearchListElement bse = (BPSearchListElement)elem;
                fragments.addAll(this.getPackages(bse, roots));
            }
            return fragments.toArray();
        }
        catch (JavaModelException javaModelException) {
            return new Object[0];
        }
    }

    private List chooseDefined() {
        ArrayList<BPSearchListElement> inputs = new ArrayList<BPSearchListElement>();
        List currentList = this.fSearchPackagesList.getElements();
        int i = 0;
        while (i < this.rawList.length) {
            if (this.rawList[i].getEntryKind() == 2) {
                boolean exists = false;
                int j = 0;
                while (j < currentList.size()) {
                    BPSearchListElement bse = (BPSearchListElement)currentList.get(j);
                    if (bse.getEntry().getKind() == 2 && this.rawList[i].getPath().equals((Object)bse.getEntry().getPath())) {
                        exists = true;
                        break;
                    }
                    ++j;
                }
                if (!exists) {
                    inputs.add(new BPSearchListElement(new SearchpathEntry(2, this.rawList[i].getPath(), null), false, false, this.rawList[i].isExported()));
                }
            }
            ++i;
        }
        SearchPathListLabelProvider labelProvider1 = new SearchPathListLabelProvider(this.fCurrJProject);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider1);
        dialog.setTitle(BeanInfoUIMessages.getString("PackagesWorkbook.SelectionDialog.DefinedPaths.Title"));
        dialog.setMessage(BeanInfoUIMessages.getString("PackagesWorkbook.SelectionDialog.DefinedPaths.Message"));
        dialog.setElements(inputs.toArray());
        if (dialog.open() == 0) {
            return Arrays.asList(dialog.getResult());
        }
        return Collections.EMPTY_LIST;
    }

    protected BPListElement newBPListElement(Object element) {
        SearchpathEntry se = null;
        boolean isExported = false;
        IPackageFragment frag = (IPackageFragment)element;
        IPackageFragmentRoot root = (IPackageFragmentRoot)frag.getParent();
        int i = 0;
        while (i < this.rootsPerRawEntry.length) {
            int j = 0;
            while (j < this.rootsPerRawEntry[i].length) {
                if (this.rootsPerRawEntry[i][j].equals(root)) {
                    isExported = this.rawList[i].isExported() || this.rawList[i].getEntryKind() == 3;
                    se = new SearchpathEntry(this.rawList[i].getEntryKind(), this.rawList[i].getPath(), frag.getElementName());
                    break;
                }
                ++j;
            }
            ++i;
        }
        return new BPSearchListElement(se, false, false, isExported);
    }

    protected List getPackages(BPSearchListElement element, IPackageFragmentRoot[] roots) {
        String packageName = ((SearchpathEntry)element.getEntry()).getPackage();
        if (packageName == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            ArrayList<IJavaElement> packages = new ArrayList<IJavaElement>(10);
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] pfs = roots[i].getChildren();
                int j = 0;
                while (j < pfs.length) {
                    if (pfs[j].getElementType() == 4 && pfs[j].getElementName().equals(packageName)) {
                        packages.add(pfs[j]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return packages;
        }
        catch (JavaModelException javaModelException) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class ChoosePackagesSelectionValidator
    implements ISelectionStatusValidator {
        private IStatus fgErrorStatus = new StatusInfo(4, "");
        private IStatus fgOKStatus = new StatusInfo();

        public IStatus validate(Object[] selection) {
            if (this.isValid(selection)) {
                return this.fgOKStatus;
            }
            return this.fgErrorStatus;
        }

        private boolean isValid(Object[] selection) {
            if (selection.length == 0) {
                return false;
            }
            int i = 0;
            while (i < selection.length) {
                if (!(selection[i] instanceof IPackageFragment)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class PackagesAdapter
    implements IListAdapter,
    IDialogFieldListener {
        PackagesAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            PackagesWorkbookPage.this.packagesPageCustomButtonPressed((DialogField)field, index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            PackagesWorkbookPage.this.packagesPageDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
        }
    }
}

