/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfosDocEntry;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.ui.BPListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPSearchListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.OverlayComposite;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Bundle;

public class SearchPathListLabelProvider
extends LabelProvider {
    IWorkspaceRoot fRoot;
    IJavaProject javaProject;
    private Image fJarIcon;
    private Image fExtJarIcon;
    private Image fFolderImage;
    private Image fProjectImage;
    private Image fVariableImage;
    private Image fLibraryImage;
    private Image fMissingJarImage;
    private Image fMissingVariableImage;
    private Image fMissingFolderImage;
    private Image fMissingProjectImage;
    private Image fPackageImage;
    private Image fPluginImage;
    private Image fBeanImage;
    private Image fMissingPackageImage;
    private Image fBlankImage;
    private Image fMissingLibraryImage;
    private HashMap fBeanedImages = new HashMap();
    private HashMap fPackagedImages = new HashMap();
    private HashMap fMissingPackagedImages = new HashMap();
    private HashMap fNormalImages = new HashMap();

    public SearchPathListLabelProvider() {
        this(null);
    }

    public SearchPathListLabelProvider(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        ImageRegistry reg = JavaPlugin.getDefault().getImageRegistry();
        this.fJarIcon = reg.get("org.eclipse.jdt.ui.jar_obj.gif");
        this.fExtJarIcon = reg.get("org.eclipse.jdt.ui.jar_l_obj.gif");
        this.fFolderImage = reg.get("org.eclipse.jdt.ui.packagefolder_obj.gif");
        this.fVariableImage = reg.get("org.eclipse.jdt.ui.envvar_obj.gif");
        this.fLibraryImage = reg.get("org.eclipse.jdt.ui.library_obj.gif");
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fMissingJarImage = reg.get("org.eclipse.jdt.ui.jar_nonexist_obj.gif");
        this.fMissingVariableImage = reg.get("org.eclipse.jdt.ui.envvar_nonexist_obj.gif");
        this.fMissingFolderImage = reg.get("org.eclipse.jdt.ui.packagefolder_nonexist_obj.gif");
        this.fMissingProjectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
        this.fPackageImage = reg.get("org.eclipse.jdt.ui.package_obj.gif");
        Rectangle r = this.fLibraryImage.getBounds();
        Point s = new Point(r.width, r.height);
        JavaElementImageDescriptor jed = new JavaElementImageDescriptor(reg.getDescriptor("org.eclipse.jdt.ui.library_obj.gif"), 32, s);
        this.fMissingLibraryImage = jed.createImage();
        Bundle bundle = JEMUIPlugin.getPlugin().getBundle();
        URL url = Platform.find((Bundle)bundle, (IPath)new Path("icons/plugin_obj.gif"));
        this.fPluginImage = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : ImageDescriptor.getMissingImageDescriptor().createImage();
        url = Platform.find((Bundle)bundle, (IPath)new Path("icons/javabean.gif"));
        this.fBeanImage = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : ImageDescriptor.getMissingImageDescriptor().createImage();
        url = Platform.find((Bundle)bundle, (IPath)new Path("icons/package_obj_missing.gif"));
        this.fMissingPackageImage = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : ImageDescriptor.getMissingImageDescriptor().createImage();
        url = Platform.find((Bundle)bundle, (IPath)new Path("icons/blank.gif"));
        this.fBlankImage = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : ImageDescriptor.getMissingImageDescriptor().createImage();
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public String getText(Object element) {
        if (element instanceof BPListElement) {
            String packageName;
            BPListElement bpentry = (BPListElement)element;
            IBeaninfosDocEntry docEntry = bpentry.getEntry();
            IPath path = docEntry.getPath();
            String pathString = null;
            switch (docEntry.getKind()) {
                case 1: {
                    IResource resource = this.fRoot.findMember(path);
                    if (resource instanceof IFolder) {
                        pathString = MessageFormat.format(BeanInfoUIMessages.getString("LabelProvider.Library.Folder"), path.makeRelative().toString());
                        break;
                    }
                    if (resource instanceof IFile) {
                        if (!ArchiveFileFilter.isArchivePath((IPath)path)) break;
                        Object[] args = new String[]{path.lastSegment(), path.removeLastSegments(1).makeRelative().toString()};
                        pathString = MessageFormat.format(BeanInfoUIMessages.getString("LabelProvider.Library.(PathLastSegment,PathRelative)"), args);
                        break;
                    }
                    if (ArchiveFileFilter.isArchivePath((IPath)path)) {
                        Object[] args = new String[]{path.lastSegment(), path.removeLastSegments(1).toString()};
                        pathString = MessageFormat.format(BeanInfoUIMessages.getString("LabelProvider.Library.(PathLastSegment,PathExceptLast)"), args);
                        break;
                    }
                    pathString = path.makeRelative().toString();
                    break;
                }
                case 4: {
                    String name = path.makeRelative().toString();
                    IPath entryPath = JavaCore.getClasspathVariable((String)path.segment(0));
                    if (entryPath != null) {
                        pathString = MessageFormat.format(BeanInfoUIMessages.getString("LabelProvider.Variable.(name,PathOSString)"), name, entryPath.append(path.removeFirstSegments(1)).toOSString());
                        break;
                    }
                    pathString = name;
                    break;
                }
                case 5: {
                    try {
                        IClasspathContainer c = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)this.javaProject);
                        if (c != null) {
                            pathString = c.getDescription();
                            break;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    pathString = path.toString();
                    break;
                }
                case 2: {
                    pathString = path.toString();
                    break;
                }
                case 3: {
                    pathString = path.makeRelative().toString();
                    break;
                }
                case 100: {
                    pathString = path.toString();
                }
            }
            if (docEntry instanceof SearchpathEntry && (packageName = ((SearchpathEntry)docEntry).getPackage()) != null && packageName.length() > 0) {
                if (pathString != null) {
                    return MessageFormat.format(BeanInfoUIMessages.getString("LabelProvider.(packageName,Path)"), packageName, pathString);
                }
                return packageName;
            }
            if (pathString != null) {
                return pathString;
            }
            return "?";
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        Image returnedImage = null;
        boolean imageIsNormal = true;
        if (element instanceof BPListElement) {
            BPListElement bpentry = (BPListElement)element;
            IBeaninfosDocEntry docEntry = bpentry.getEntry();
            IPath path = docEntry.getPath();
            Image pathImage = null;
            switch (docEntry.getKind()) {
                case 3: {
                    if (!bpentry.isMissing()) {
                        pathImage = this.fFolderImage;
                        break;
                    }
                    pathImage = this.fMissingFolderImage;
                    break;
                }
                case 1: {
                    if (!bpentry.isMissing()) {
                        IResource resource = this.fRoot.findMember(path);
                        if (resource instanceof IFolder) {
                            pathImage = this.fFolderImage;
                            break;
                        }
                        if (resource instanceof IFile) {
                            pathImage = this.fJarIcon;
                            break;
                        }
                        pathImage = this.fExtJarIcon;
                        break;
                    }
                    pathImage = this.fMissingJarImage;
                    break;
                }
                case 2: {
                    if (!bpentry.isMissing()) {
                        pathImage = this.fProjectImage;
                        break;
                    }
                    pathImage = this.fMissingProjectImage;
                    break;
                }
                case 4: {
                    if (!bpentry.isMissing()) {
                        pathImage = this.fVariableImage;
                        break;
                    }
                    pathImage = this.fMissingVariableImage;
                    break;
                }
                case 5: {
                    if (!bpentry.isMissing()) {
                        pathImage = this.fLibraryImage;
                        break;
                    }
                    pathImage = this.fMissingLibraryImage;
                    break;
                }
                case 100: {
                    pathImage = this.fPluginImage;
                    break;
                }
            }
            if (bpentry instanceof BPSearchListElement) {
                SearchpathEntry se = (SearchpathEntry)docEntry;
                BPSearchListElement bpse = (BPSearchListElement)bpentry;
                if (se.getPackage() != null && pathImage != null) {
                    if (!bpse.isPackageMissing()) {
                        imageIsNormal = false;
                        returnedImage = (Image)this.fPackagedImages.get(pathImage);
                        if (returnedImage == null) {
                            OverlayComposite oc = new OverlayComposite(pathImage.getImageData());
                            oc.setRightExtension(this.fPackageImage.getImageData());
                            returnedImage = oc.createImage();
                            this.fPackagedImages.put(pathImage, returnedImage);
                        }
                    } else {
                        imageIsNormal = false;
                        returnedImage = (Image)this.fMissingPackagedImages.get(pathImage);
                        if (returnedImage == null) {
                            OverlayComposite oc = new OverlayComposite(pathImage.getImageData());
                            oc.setRightExtension(this.fMissingPackageImage.getImageData());
                            returnedImage = oc.createImage();
                            this.fMissingPackagedImages.put(pathImage, returnedImage);
                        }
                    }
                }
                if (pathImage == null && returnedImage == null) {
                    returnedImage = !bpse.isPackageMissing() ? this.fPackageImage : this.fMissingPackageImage;
                } else if (returnedImage == null) {
                    returnedImage = pathImage;
                }
            } else {
                if (pathImage != null) {
                    imageIsNormal = false;
                    returnedImage = (Image)this.fBeanedImages.get(pathImage);
                    if (returnedImage == null) {
                        OverlayComposite oc = new OverlayComposite(pathImage.getImageData());
                        oc.setRightExtension(this.fBeanImage.getImageData());
                        returnedImage = oc.createImage();
                        this.fBeanedImages.put(pathImage, returnedImage);
                    }
                }
                if (returnedImage == null) {
                    returnedImage = this.fBeanImage;
                }
            }
        }
        if (imageIsNormal && returnedImage != null) {
            Image newReturned = (Image)this.fNormalImages.get(returnedImage);
            if (newReturned == null) {
                OverlayComposite oc = new OverlayComposite(returnedImage.getImageData());
                oc.setRightExtension(this.fBlankImage.getImageData());
                newReturned = oc.createImage();
                this.fNormalImages.put(returnedImage, newReturned);
            }
            returnedImage = newReturned;
        }
        return returnedImage;
    }

    public void dispose() {
        super.dispose();
        this.fPluginImage.dispose();
        this.fBeanImage.dispose();
        this.fMissingPackageImage.dispose();
        this.fBlankImage.dispose();
        this.fMissingLibraryImage.dispose();
        Iterator itr = this.fBeanedImages.values().iterator();
        while (itr.hasNext()) {
            ((Image)itr.next()).dispose();
        }
        itr = this.fPackagedImages.values().iterator();
        while (itr.hasNext()) {
            ((Image)itr.next()).dispose();
        }
        itr = this.fMissingPackagedImages.values().iterator();
        while (itr.hasNext()) {
            ((Image)itr.next()).dispose();
        }
        itr = this.fNormalImages.values().iterator();
        while (itr.hasNext()) {
            ((Image)itr.next()).dispose();
        }
    }
}

