/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SplashInfo
extends ProductObject
implements ISplashInfo {
    private static final long serialVersionUID = 1L;
    private String fLocation;

    public SplashInfo(IProductModel model) {
        super(model);
    }

    public void setLocation(String location) {
        String old = this.fLocation;
        this.fLocation = location;
        if (this.isEditable()) {
            this.firePropertyChanged("location", old, this.fLocation);
        }
    }

    public String getLocation() {
        return this.fLocation;
    }

    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fLocation = element.getAttribute("location");
        }
    }

    public void write(String indent, PrintWriter writer) {
        if (this.fLocation != null && this.fLocation.length() > 0) {
            writer.println(String.valueOf(indent) + "<splash " + "location" + "=\"" + this.getWritableString(this.fLocation) + "\"/>");
        }
    }
}

