/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text;

import java.util.HashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.core.util.PropertiesUtil;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractTextChangeListener
implements IModelTextChangeListener {
    protected HashMap fOperationTable = new HashMap();
    protected IDocument fDocument;

    public AbstractTextChangeListener(IDocument document) {
        this.fDocument = document;
    }

    public TextEdit[] getTextOperations() {
        if (this.fOperationTable.size() == 0) {
            return new TextEdit[0];
        }
        TextEdit[] ops = this.fOperationTable.values().toArray(new TextEdit[this.fOperationTable.size()]);
        try {
            if (!PropertiesUtil.isNewlineNeeded(this.fDocument)) {
                return ops;
            }
        }
        catch (BadLocationException badLocationException) {}
        TextEdit[] result = new TextEdit[this.fOperationTable.size() + 1];
        result[0] = new InsertEdit(PropertiesUtil.getInsertOffset(this.fDocument), TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument));
        System.arraycopy(ops, 0, result, 1, ops.length);
        return result;
    }

    protected void insertKey(IDocumentKey key) {
        int offset = PropertiesUtil.getInsertOffset(this.fDocument);
        this.fOperationTable.put(key, new InsertEdit(offset, key.write()));
    }

    protected void deleteKey(IDocumentKey key) {
        if (key.getOffset() >= 0) {
            this.fOperationTable.put(key, new DeleteEdit(key.getOffset(), key.getLength()));
        }
    }

    protected void modifyKey(IDocumentKey key) {
        if (key.getOffset() == -1) {
            this.insertKey(key);
        } else {
            ReplaceEdit op = new ReplaceEdit(key.getOffset(), key.getLength(), key.write());
            this.fOperationTable.put(key, op);
        }
    }
}

