/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourceTree;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class Project
extends Container
implements IProject {
    protected Project(IPath path, Workspace container) {
        super(path, container);
    }

    protected MultiStatus basicSetDescription(ProjectDescription description, int updateFlags) {
        String message = Messages.resources_projectDesc;
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 568, message, null);
        ProjectDescription current = this.internalGetDescription();
        current.setComment(description.getComment());
        current.setBuildSpec(description.getBuildSpec(true));
        boolean flushOrder = false;
        Object[] oldReferences = current.getReferencedProjects();
        Object[] newReferences = description.getReferencedProjects();
        if (!Arrays.equals(oldReferences, newReferences)) {
            current.setReferencedProjects((IProject[])newReferences);
            flushOrder = true;
        }
        if (!Arrays.equals(oldReferences = current.getDynamicReferences(), newReferences = description.getDynamicReferences())) {
            current.setDynamicReferences((IProject[])newReferences);
            flushOrder = true;
        }
        if (flushOrder) {
            this.workspace.flushBuildOrder();
        }
        if ((updateFlags & 0x40) == 0) {
            this.workspace.getNatureManager().configureNatures(this, current, description, result);
        } else {
            current.setNatureIds(description.getNatureIds(false));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(int trigger, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        ISchedulingRule rule = this.workspace.getRuleFactory().buildRule();
        try {
            block10: {
                block11: {
                    monitor.beginTask(null, Policy.opWork);
                    try {
                        this.workspace.prepareOperation(rule, monitor);
                        ResourceInfo info = this.getResourceInfo(false, false);
                        int flags = this.getFlags(info);
                        if (this.exists(flags, true)) {
                            if (this.isOpen(flags)) break block10;
                        }
                        Object var6_6 = null;
                        if (!this.workspace.getElementTree().isImmutable()) break block11;
                        this.workspace.newWorkingTree();
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (this.workspace.getElementTree().isImmutable()) {
                            this.workspace.newWorkingTree();
                        }
                        this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
                        throw throwable;
                    }
                }
                this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
                Object var8_9 = null;
                monitor.done();
                return;
            }
            this.workspace.beginOperation(true);
            this.workspace.aboutToBuild(this, trigger);
            this.workspace.getBuildManager().build(this, trigger, Policy.subMonitorFor(monitor, Policy.opWork));
            this.workspace.broadcastBuildEvent(this, 16, trigger);
            Object var6_8 = null;
            if (this.workspace.getElementTree().isImmutable()) {
                this.workspace.newWorkingTree();
            }
            this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(int trigger, String builderName, Map args, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        ISchedulingRule rule = this.workspace.getRuleFactory().buildRule();
        try {
            block10: {
                block11: {
                    monitor.beginTask(null, Policy.opWork);
                    try {
                        this.workspace.prepareOperation(rule, monitor);
                        ResourceInfo info = this.getResourceInfo(false, false);
                        int flags = this.getFlags(info);
                        if (this.exists(flags, true)) {
                            if (this.isOpen(flags)) break block10;
                        }
                        Object var8_8 = null;
                        if (!this.workspace.getElementTree().isImmutable()) break block11;
                        this.workspace.newWorkingTree();
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (this.workspace.getElementTree().isImmutable()) {
                            this.workspace.newWorkingTree();
                        }
                        this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
                        throw throwable;
                    }
                }
                this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
                Object var10_11 = null;
                monitor.done();
                return;
            }
            this.workspace.beginOperation(true);
            this.workspace.aboutToBuild(this, trigger);
            this.workspace.getBuildManager().build(this, trigger, builderName, args, Policy.subMonitorFor(monitor, Policy.opWork));
            this.workspace.broadcastBuildEvent(this, 16, trigger);
            Object var8_10 = null;
            if (this.workspace.getElementTree().isImmutable()) {
                this.workspace.newWorkingTree();
            }
            this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void checkAccessible(int flags) throws CoreException {
        super.checkAccessible(flags);
        if (!this.isOpen(flags)) {
            String message = NLS.bind((String)Messages.resources_mustBeOpen, (Object)this.getFullPath());
            throw new ResourceException(372, this.getFullPath(), message, null);
        }
    }

    protected void checkDescription(IProject project, IProjectDescription desc, boolean moving) throws CoreException {
        URI location = desc.getLocationURI();
        if (location == null) {
            return;
        }
        String message = Messages.resources_invalidProjDesc;
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 77, message, null);
        status.merge(this.workspace.validateName(desc.getName(), 4));
        if (moving) {
            URI sourceLocation = this.internalGetDescription().getLocationURI();
            if (sourceLocation == null || !sourceLocation.equals(location)) {
                status.merge(this.workspace.validateProjectLocationURI(project, location));
            }
        } else {
            status.merge(this.workspace.validateProjectLocationURI(project, location));
        }
        if (!status.isOK()) {
            throw new ResourceException((IStatus)status);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            ISchedulingRule rule;
            block11: {
                block10: {
                    String msg = NLS.bind((String)Messages.resources_closing_1, (Object)this.getName());
                    monitor.beginTask(msg, 100);
                    rule = this.workspace.getRuleFactory().modifyRule(this);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(1, this));
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    int flags = this.getFlags(info);
                    this.checkExists(flags, true);
                    monitor.subTask(msg);
                    if (this.isOpen(flags)) break block10;
                    Object var8_7 = null;
                    this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                    Object var10_10 = null;
                    monitor.done();
                    return;
                }
                this.workspace.beginOperation(true);
                this.workspace.flushBuildOrder();
                IProgressMonitor sub = Policy.subMonitorFor(monitor, Policy.opWork / 2, 2);
                IStatus saveStatus = this.workspace.getSaveManager().save(3, this, sub);
                this.internalClose();
                monitor.worked(Policy.opWork / 2);
                if (saveStatus == null || saveStatus.isOK()) break block11;
                throw new ResourceException(saveStatus);
            }
            Object var8_9 = null;
            this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            {
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                    throw throwable;
                }
            }
            Object var10_12 = null;
            monitor.done();
            return;
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        if (destination.segmentCount() == 1) {
            String projectName = destination.segment(0);
            IProjectDescription desc = this.getDescription();
            desc.setName(projectName);
            desc.setLocation(null);
            this.internalCopy(desc, updateFlags, monitor);
        } else {
            this.checkCopyRequirements(destination, 4, updateFlags);
        }
    }

    public void copy(IProjectDescription destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)destination);
        this.internalCopy(destination, updateFlags, monitor);
    }

    protected void copyMetaArea(IProject source, IProject destination, IProgressMonitor monitor) throws CoreException {
        IFileStore oldMetaArea = EFS.getFileSystem((String)"file").getStore(this.workspace.getMetaArea().locationFor(source));
        IFileStore newMetaArea = EFS.getFileSystem((String)"file").getStore(this.workspace.getMetaArea().locationFor(destination));
        oldMetaArea.copy(newMetaArea, 0, monitor);
    }

    public void create(IProgressMonitor monitor) throws CoreException {
        this.create(null, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Messages.resources_create, 100);
            this.checkValidPath(this.path, 4, false);
            ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    boolean hasSavedDescription;
                    ProjectDescription desc;
                    this.workspace.prepareOperation(rule, monitor);
                    this.checkDoesNotExist();
                    if (description != null) {
                        this.checkDescription(this, description, false);
                    }
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(8, this));
                    this.workspace.beginOperation(true);
                    this.workspace.createResource((IResource)this, false);
                    this.workspace.getMetaArea().create(this);
                    ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, true);
                    if (description == null) {
                        desc = new ProjectDescription();
                    } else {
                        desc = (ProjectDescription)((ProjectDescription)description).clone();
                        desc.setLocationURI(FileUtil.canonicalURI(description.getLocationURI()));
                    }
                    desc.setName(this.getName());
                    this.internalSetDescription(desc, false);
                    boolean hasContent = hasSavedDescription = this.getLocalManager().hasSavedDescription(this);
                    if (!hasSavedDescription) {
                        hasContent = this.getLocalManager().hasSavedContent(this);
                    }
                    try {
                        if (hasSavedDescription) {
                            this.updateDescription();
                            this.workspace.getMetaArea().writePrivateDescription(this);
                        } else {
                            this.writeDescription(1);
                        }
                    }
                    catch (CoreException e) {
                        this.workspace.deleteResource(this);
                        throw e;
                    }
                    info.clearModificationStamp();
                    if (hasContent) {
                        info.set(0x100000);
                    }
                    this.workspace.getSaveManager().requestSnapshot();
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var9_12 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        monitor.done();
    }

    private void createParentFolders(IResource resource) throws CoreException {
        IContainer parent = resource.getParent();
        if (parent == null || parent.exists() || parent.getType() == 4) {
            return;
        }
        this.createParentFolders(parent);
        this.workspace.createResource((IResource)parent, false);
    }

    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags |= deleteContent ? 4 : 8, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags, monitor);
    }

    protected void fixupAfterMoveSource() {
        this.workspace.deleteResource(this);
    }

    public IContentTypeMatcher getContentTypeMatcher() throws CoreException {
        return this.workspace.getContentDescriptionManager().getContentTypeMatcher(this);
    }

    public String getDefaultCharset(boolean checkImplicit) {
        if (!this.exists()) {
            return checkImplicit ? ResourcesPlugin.getEncoding() : null;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), checkImplicit);
    }

    public IProjectDescription getDescription() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        ProjectDescription description = ((ProjectInfo)info).getDescription();
        if (description == null) {
            this.checkAccessible(-1);
        }
        return (IProjectDescription)description.clone();
    }

    public IProjectNature getNature(String natureID) throws CoreException {
        ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        IProjectNature nature = info.getNature(natureID);
        if (nature == null) {
            if (!this.hasNature(natureID)) {
                return null;
            }
            nature = this.workspace.getNatureManager().createNature(this, natureID);
            info.setNature(natureID, nature);
        }
        return nature;
    }

    public IContainer getParent() {
        return this.workspace.getRoot();
    }

    public IPath getPluginWorkingLocation(IPluginDescriptor plugin) {
        if (plugin == null) {
            return null;
        }
        return this.getWorkingLocation(plugin.getUniqueIdentifier());
    }

    public IProject getProject() {
        return this;
    }

    public IPath getProjectRelativePath() {
        return Path.EMPTY;
    }

    public IPath getRawLocation() {
        ProjectDescription description = this.internalGetDescription();
        return description == null ? null : description.getLocation();
    }

    public URI getRawLocationURI() {
        ProjectDescription description = this.internalGetDescription();
        return description == null ? null : description.getLocationURI();
    }

    public IProject[] getReferencedProjects() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        ProjectDescription description = ((ProjectInfo)info).getDescription();
        if (description == null) {
            this.checkAccessible(-1);
        }
        return description.getAllReferences(true);
    }

    public IProject[] getReferencingProjects() {
        IProject[] projects = this.workspace.getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>(projects.length);
        int i = 0;
        while (i < projects.length) {
            ProjectDescription description;
            Project project = (Project)projects[i];
            if (project.isAccessible() && (description = project.internalGetDescription()) != null) {
                IProject[] references = description.getAllReferences(false);
                int j = 0;
                while (j < references.length) {
                    if (references[j].equals(this)) {
                        result.add(projects[i]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public int getType() {
        return 4;
    }

    public IPath getWorkingLocation(String id) {
        if (id == null || !this.exists()) {
            return null;
        }
        IPath result = this.workspace.getMetaArea().getWorkingLocation(this, id);
        result.toFile().mkdirs();
        return result;
    }

    public boolean hasNature(String natureID) throws CoreException {
        this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
        ProjectDescription desc = this.internalGetDescription();
        if (desc == null) {
            this.checkAccessible(-1);
        }
        return desc.hasNature(natureID);
    }

    protected void internalClose() throws CoreException {
        this.workspace.flushBuildOrder();
        this.getMarkerManager().removeMarkers(this, 2);
        IResource[] members = this.members(3);
        int i = 0;
        while (i < members.length) {
            Resource member = (Resource)members[i];
            this.workspace.deleteResource(member);
            ++i;
        }
        ResourceInfo info = this.getResourceInfo(false, true);
        info.clear(1);
        info.clearSessionProperties();
        info.clearModificationStamp();
        info.setSyncInfo(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalCopy(IProjectDescription destDesc, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = NLS.bind((String)Messages.resources_copying, (Object)this.getFullPath());
            monitor.beginTask(message, 100);
            String destName = destDesc.getName();
            IPath destPath = new Path(destName).makeAbsolute();
            Project destination = (Project)this.workspace.getRoot().getProject(destName);
            ISchedulingRule rule = this.workspace.getRuleFactory().copyRule(this, destination);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    this.assertCopyRequirements(destPath, 4, updateFlags);
                    this.checkDescription(destination, destDesc, false);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(4, this, destination, updateFlags));
                    this.workspace.beginOperation(true);
                    this.getLocalManager().refresh(this, 2, true, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
                    this.getPropertyManager().closePropertyStore(this);
                    this.getLocalManager().getHistoryStore().closeHistoryStore(this);
                    this.copyMetaArea(this, destination, Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                    this.internalCopyProjectOnly(destination, Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                    destination.internalSetDescription(destDesc, false);
                    destination.getStore().mkdir(0, Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                    message = Messages.resources_copyProblem;
                    MultiStatus problems = new MultiStatus("org.eclipse.core.resources", 566, message, null);
                    IResource[] children = this.members(2);
                    int childCount = children.length;
                    int childWork = childCount > 1 ? Policy.opWork * 50 / 100 / (childCount - 1) : 0;
                    int i = 0;
                    while (true) {
                        if (i >= childCount) {
                            try {
                                destination.writeDescription(1);
                                break;
                            }
                            catch (CoreException e) {
                                try {
                                    destination.delete((updateFlags & 1) != 0, null);
                                    throw e;
                                }
                                catch (CoreException coreException) {}
                                throw e;
                            }
                        }
                        IResource child = children[i];
                        if (!this.isProjectDescriptionFile(child)) {
                            try {
                                child.copy(destPath.append(child.getName()), updateFlags, Policy.subMonitorFor(monitor, childWork));
                            }
                            catch (CoreException e) {
                                problems.merge(e.getStatus());
                            }
                        }
                        ++i;
                    }
                    monitor.worked(Policy.opWork * 5 / 100);
                    monitor.subTask(Messages.resources_updating);
                    this.getLocalManager().refresh(destination, 2, true, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                    if (!problems.isOK()) {
                        throw new ResourceException((IStatus)problems);
                    }
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var16_20 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var18_23 = null;
        }
        monitor.done();
    }

    protected void internalCopyProjectOnly(IResource destination, IProgressMonitor monitor) throws CoreException {
        this.getPropertyManager().closePropertyStore(this);
        this.getLocalManager().getHistoryStore().closeHistoryStore(this);
        this.workspace.copyTree(this, destination.getFullPath(), 0, 0, false);
        this.getPropertyManager().copy(this, destination, 0);
        ProjectInfo info = (ProjectInfo)((Resource)destination).getResourceInfo(false, true);
        info.description = null;
        info.setMarkers(null);
        info.clearSessionProperties();
    }

    public ProjectDescription internalGetDescription() {
        ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, false);
        if (info == null) {
            return null;
        }
        return info.getDescription();
    }

    void internalSetDescription(IProjectDescription value, boolean incrementContentId) {
        ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, true);
        info.setDescription((ProjectDescription)value);
        this.getLocalManager().setLocation(this, info, value.getLocationURI());
        if (incrementContentId) {
            info.incrementContentId();
            if (info.getModificationStamp() != -1L) {
                this.workspace.updateModificationStamp(info);
            }
        }
    }

    public void internalSetLocal(boolean flag, int depth) throws CoreException {
        if (depth == 0) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(0);
        int i = 0;
        while (i < children.length) {
            ((Resource)children[i]).internalSetLocal(flag, depth);
            ++i;
        }
    }

    public boolean isAccessible() {
        return this.isOpen();
    }

    public boolean isLinked(int options) {
        return false;
    }

    public boolean isLocal(int depth) {
        return this.isLocal(-1, depth);
    }

    public boolean isLocal(int flags, int depth) {
        if (depth == 0) {
            return true;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(0);
        int i = 0;
        while (i < children.length) {
            if (!children[i].isLocal(depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isNatureEnabled(String natureId) throws CoreException {
        this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
        return this.workspace.getNatureManager().isNatureEnabled(this, natureId);
    }

    public boolean isOpen() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.isOpen(this.getFlags(info));
    }

    public boolean isOpen(int flags) {
        return flags != -1 && ResourceInfo.isSet(flags, 1);
    }

    protected boolean isProjectDescriptionFile(IResource resource) {
        return resource.getType() == 1 && resource.getFullPath().segmentCount() == 2 && resource.getName().equals(".project");
    }

    public void move(IProjectDescription destination, boolean force, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)destination);
        this.move(destination, force ? 1 : 0, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)description);
        monitor = Policy.monitorFor(monitor);
        try {
            String message = NLS.bind((String)Messages.resources_moving, (Object)this.getFullPath());
            monitor.beginTask(message, 100);
            IProject destination = this.workspace.getRoot().getProject(description.getName());
            ISchedulingRule rule = this.workspace.getRuleFactory().moveRule(this, destination);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    if (!this.getName().equals(description.getName())) {
                        IPath destPath = Path.ROOT.append(description.getName());
                        this.assertMoveRequirements(destPath, 4, updateFlags);
                    }
                    this.checkDescription(destination, description, true);
                    this.workspace.beginOperation(true);
                    message = Messages.resources_moveProblem;
                    MultiStatus status = new MultiStatus("org.eclipse.core.resources", 4, message, null);
                    WorkManager workManager = this.workspace.getWorkManager();
                    ResourceTree tree = new ResourceTree(this.getLocalManager(), workManager.getLock(), status, updateFlags);
                    IMoveDeleteHook hook = this.workspace.getMoveDeleteHook();
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(64, this, destination, updateFlags));
                    int depth = 0;
                    try {
                        depth = workManager.beginUnprotected();
                        if (!hook.moveProject(tree, this, description, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2))) {
                            tree.standardMoveProject(this, description, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        workManager.endUnprotected(depth);
                        throw throwable;
                    }
                    {
                        Object var12_15 = null;
                        workManager.endUnprotected(depth);
                        tree.makeInvalid();
                    }
                    if (!tree.getStatus().isOK()) {
                        throw new ResourceException(tree.getStatus());
                    }
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var14_18 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var16_21 = null;
        }
        monitor.done();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            boolean used;
            ProjectInfo info;
            ISchedulingRule rule;
            block17: {
                String msg = NLS.bind((String)Messages.resources_opening_1, (Object)this.getName());
                monitor.beginTask(msg, 100);
                monitor.subTask(msg);
                rule = this.workspace.getRuleFactory().modifyRule(this);
                this.workspace.prepareOperation(rule, monitor);
                info = (ProjectInfo)this.getResourceInfo(false, false);
                int flags = this.getFlags(info);
                this.checkExists(flags, true);
                if (!this.isOpen(flags)) break block17;
                Object var10_8 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                Object var12_11 = null;
                monitor.done();
                return;
            }
            this.workspace.beginOperation(true);
            this.workspace.flushBuildOrder();
            info = (ProjectInfo)this.getResourceInfo(false, true);
            info.set(1);
            boolean unknownChildren = info.isSet(0x100000);
            if (unknownChildren) {
                info.clear(0x100000);
            }
            if (used = info.isSet(16)) {
                this.workspace.getSaveManager().restore(this, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
            } else {
                info.set(16);
                IStatus result = this.reconcileLinks(info.getDescription());
                if (!result.isOK()) {
                    throw new CoreException(result);
                }
                this.workspace.updateModificationStamp(info);
                monitor.worked(Policy.opWork * 20 / 100);
            }
            this.startup();
            if (!used && unknownChildren) {
                if ((updateFlags & 0x80) != 0) {
                    this.workspace.refreshManager.refresh(this);
                    monitor.worked(Policy.opWork * 80 / 100);
                } else {
                    this.refreshLocal(2, Policy.subMonitorFor(monitor, Policy.opWork * 80 / 100));
                }
            }
            this.workspace.getAliasManager().updateAliases(this, this.getStore(), 2, monitor);
            Object var10_10 = null;
            this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            {
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                    throw throwable;
                }
            }
            Object var12_13 = null;
            monitor.done();
            return;
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            monitor.done();
            throw throwable;
        }
    }

    public void open(IProgressMonitor monitor) throws CoreException {
        this.open(0, monitor);
    }

    public IStatus reconcileLinks(ProjectDescription newDescription) {
        HashMap oldLinks;
        HashMap newLinks = newDescription.getLinks();
        String msg = Messages.links_errorLinkReconcile;
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 76, msg, null);
        ProjectDescription oldDescription = this.internalGetDescription();
        if (oldDescription != null && (oldLinks = oldDescription.getLinks()) != null) {
            Iterator it = oldLinks.values().iterator();
            while (it.hasNext()) {
                LinkDescription oldLink = (LinkDescription)it.next();
                Resource oldLinkResource = (Resource)this.findMember(oldLink.getProjectRelativePath());
                if (oldLinkResource == null || !oldLinkResource.isLinked()) continue;
                LinkDescription newLink = null;
                if (newLinks != null) {
                    newLink = (LinkDescription)newLinks.get(oldLink.getProjectRelativePath());
                }
                if (newLink != null && newLink.getLocationURI().equals(oldLinkResource.getLocationURI()) && newLink.getType() == oldLinkResource.getType()) continue;
                try {
                    oldLinkResource.delete(0, null);
                    oldLinkResource.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
        }
        if (newLinks == null) {
            return status;
        }
        Iterator it = newLinks.values().iterator();
        while (it.hasNext()) {
            LinkDescription newLink = (LinkDescription)it.next();
            try {
                Resource toLink = this.workspace.newResource(this.getFullPath().append(newLink.getProjectRelativePath()), newLink.getType());
                this.createParentFolders(toLink);
                toLink.createLink(newLink.getLocationURI(), 272, null);
            }
            catch (CoreException e) {
                status.merge(e.getStatus());
            }
        }
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDescription(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            IWorkspaceRoot rule;
            block12: {
                boolean hasPrivateChanges;
                boolean hasPublicChanges;
                ProjectDescription newDescription;
                ProjectDescription oldDescription;
                ResourceInfo info;
                block11: {
                    monitor.beginTask(Messages.resources_setDesc, 100);
                    rule = this.workspace.getRoot();
                    try {
                        this.workspace.prepareOperation(rule, monitor);
                        info = this.getResourceInfo(false, false);
                        this.checkAccessible(this.getFlags(info));
                        oldDescription = this.internalGetDescription();
                        newDescription = (ProjectDescription)description;
                        hasPublicChanges = oldDescription.hasPublicChanges(newDescription);
                        hasPrivateChanges = oldDescription.hasPrivateChanges(newDescription);
                        if (hasPublicChanges || hasPrivateChanges) break block11;
                        Object var13_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_11 = null;
                        this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                        throw throwable;
                    }
                    this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                    Object var15_13 = null;
                    monitor.done();
                    return;
                }
                this.checkDescription(this, newDescription, false);
                boolean hadSavedDescription = true;
                if ((updateFlags & 1) == 0 && (hadSavedDescription = this.getLocalManager().hasSavedDescription(this)) && !this.getLocalManager().isDescriptionSynchronized(this)) {
                    String message = NLS.bind((String)Messages.resources_projectDescSync, (Object)this.getName());
                    throw new ResourceException(274, this.getFullPath(), message, null);
                }
                if (!hadSavedDescription) {
                    hadSavedDescription = this.workspace.getMetaArea().hasSavedProject(this);
                }
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
                this.workspace.beginOperation(true);
                MultiStatus status = this.basicSetDescription(newDescription, updateFlags);
                if (hadSavedDescription && !status.isOK()) {
                    throw new CoreException((IStatus)status);
                }
                this.writeDescription(oldDescription, updateFlags, hasPublicChanges, hasPrivateChanges);
                info = this.getResourceInfo(false, true);
                info.incrementContentId();
                this.workspace.updateModificationStamp(info);
                if (!hadSavedDescription) {
                    String msg = NLS.bind((String)Messages.resources_missingProjectMetaRepaired, (Object)this.getName());
                    status.merge((IStatus)new ResourceStatus(234, this.getFullPath(), msg));
                }
                if (status.isOK()) break block12;
                throw new CoreException((IStatus)status);
            }
            Object var13_12 = null;
            this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void setDescription(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        this.setDescription(description, 2, monitor);
    }

    protected void startup() throws CoreException {
        if (!this.isOpen()) {
            return;
        }
        this.workspace.broadcastEvent(LifecycleEvent.newEvent(32, this));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void touch(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = NLS.bind((String)Messages.resources_touch, (Object)this.getFullPath());
            monitor.beginTask(message, 100);
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
                    this.workspace.beginOperation(true);
                    super.touch(Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateDescription() throws CoreException {
        if (ProjectDescription.isWriting) {
            return;
        }
        ProjectDescription.isReading = true;
        try {
            this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
            ProjectDescription description = this.getLocalManager().read(this, false);
            if (this.isOpen()) {
                this.reconcileLinks(description);
            }
            this.internalSetDescription(description, true);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ProjectDescription.isReading = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            ProjectDescription.isReading = false;
            return;
        }
    }

    public void writeDescription(int updateFlags) throws CoreException {
        this.writeDescription(this.internalGetDescription(), updateFlags, true, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeDescription(IProjectDescription description, int updateFlags, boolean hasPublicChanges, boolean hasPrivateChanges) throws CoreException {
        if (ProjectDescription.isReading) {
            return;
        }
        ProjectDescription.isWriting = true;
        try {
            this.getLocalManager().internalWrite(this, description, updateFlags, hasPublicChanges, hasPrivateChanges);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ProjectDescription.isWriting = false;
            throw throwable;
        }
        {
            Object var5_7 = null;
            ProjectDescription.isWriting = false;
            return;
        }
    }
}

