/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;

public class BreakpointRenamePackageParticipant
extends BreakpointRenameParticipant {
    protected boolean accepts(IJavaElement element) {
        return element instanceof IPackageFragment;
    }

    protected void gatherChanges(IMarker[] markers, List changes, String destPackageName) throws CoreException, OperationCanceledException {
        IPackageFragment originalPackage = (IPackageFragment)this.getOriginalElement();
        String originalPackageName = originalPackage.getElementName();
        IPackageFragmentRoot root = (IPackageFragmentRoot)originalPackage.getParent();
        int i = 0;
        while (i < markers.length) {
            IJavaBreakpoint javaBreakpoint;
            IType breakpointType;
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaBreakpoint && (breakpointType = BreakpointUtils.getType(javaBreakpoint = (IJavaBreakpoint)breakpoint)) != null) {
                String breakpointPackageName = breakpointType.getPackageFragment().getElementName();
                String destBreakpointPackageName = destPackageName;
                if (breakpointPackageName.length() > originalPackageName.length()) {
                    destBreakpointPackageName = String.valueOf(destBreakpointPackageName) + breakpointPackageName.substring(originalPackageName.length());
                }
                IPackageFragment destBreakpointPackage = root.getPackageFragment(destBreakpointPackageName);
                ICompilationUnit cu = destBreakpointPackage.getCompilationUnit(breakpointType.getCompilationUnit().getElementName());
                String[] typeNames = breakpointType.getTypeQualifiedName().split("\\$");
                IType destType = cu.getType(typeNames[0]);
                int j = 1;
                while (j < typeNames.length) {
                    destType = destType.getType(typeNames[j]);
                    ++j;
                }
                changes.add(this.createTypeChange(javaBreakpoint, destType, breakpointType));
            }
            ++i;
        }
    }
}

