/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.internal.navigator.extensions.OverridePolicy;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;

public class NavigatorContentServiceContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;

    public NavigatorContentServiceContentProvider(String aViewerId) {
        this.contentService = new NavigatorContentService(aViewerId);
        this.isContentServiceSelfManaged = true;
    }

    public NavigatorContentServiceContentProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public synchronized Object[] getElements(Object anInputElement) {
        ITreeContentProvider[] delegateProviders = this.contentService.findRootContentProviders(anInputElement);
        if (delegateProviders.length == 0) {
            return NO_CHILDREN;
        }
        ArrayList<Object> resultElements = new ArrayList<Object>();
        Object[] delegateChildren = null;
        int i = 0;
        while (i < delegateProviders.length) {
            try {
                delegateChildren = delegateProviders[i].getElements(anInputElement);
                if (delegateChildren != null && delegateChildren.length > 0) {
                    resultElements.addAll(Arrays.asList(delegateChildren));
                }
            }
            catch (RuntimeException re) {
                String msg = String.valueOf(CommonNavigatorMessages.Could_not_provide_children_for_element) + delegateProviders[i].getClass();
                NavigatorPlugin.log(msg, (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, msg, (Throwable)re));
            }
            ++i;
        }
        return resultElements.toArray();
    }

    public synchronized Object[] getChildren(Object aParentElement) {
        Set enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(aParentElement);
        if (enabledExtensions.size() == 0) {
            return NO_CHILDREN;
        }
        HashSet<Object> finalChildrenSet = new HashSet<Object>();
        Object[] contributedChildren = null;
        Iterator itr = enabledExtensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension enabledExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.shouldDeferToOverridePath(enabledExtension.getDescriptor(), enabledExtensions)) continue;
                contributedChildren = enabledExtension.getContentProvider().getChildren(aParentElement);
                NavigatorContentExtension[] overridingExtensions = enabledExtension.getOverridingExtensionsForTriggerPoint(aParentElement);
                if (overridingExtensions.length > 0) {
                    contributedChildren = this.pipelineChildren(aParentElement, overridingExtensions, new HashSet<Object>(Arrays.asList(contributedChildren))).toArray();
                }
                if (contributedChildren == null || contributedChildren.length <= 0) continue;
                finalChildrenSet.addAll(Arrays.asList(contributedChildren));
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{enabledExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{enabledExtension.getDescriptor().getId()}), e);
            }
        }
        return finalChildrenSet.toArray();
    }

    private Set pipelineChildren(Object aParent, NavigatorContentExtension[] theOverridingExtensions, Set theCurrentChildren) {
        Set pipelinedChildren = theCurrentChildren;
        int i = 0;
        while (i < theOverridingExtensions.length) {
            IPipelinedTreeContentProvider pipelinedContentProvider = (IPipelinedTreeContentProvider)theOverridingExtensions[i].getContentProvider();
            pipelinedChildren = pipelinedContentProvider.getPipelinedChildren(aParent, pipelinedChildren);
            NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(aParent);
            if (overridingExtensions.length > 0) {
                pipelinedChildren = this.pipelineChildren(aParent, overridingExtensions, pipelinedChildren);
            }
            ++i;
        }
        return pipelinedChildren;
    }

    private boolean shouldDeferToOverridePath(INavigatorContentDescriptor enabledDescriptor, Set enabledExtensions) {
        return enabledDescriptor.getSuppressedExtensionId() != null && enabledDescriptor.getOverridePolicy() == OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt && enabledExtensions.contains(this.contentService.getExtension(enabledDescriptor.getOverriddenDescriptor()));
    }

    public synchronized Object getParent(Object anElement) {
        ITreeContentProvider[] delegateProviders = this.contentService.findParentContentProviders(anElement);
        Object parent = null;
        int i = 0;
        while (i < delegateProviders.length) {
            try {
                parent = delegateProviders[i].getParent(anElement);
                if (parent != null) {
                    return parent;
                }
            }
            catch (RuntimeException re) {
                String msg = String.valueOf(CommonNavigatorMessages.Could_not_provide_parent_for_element) + delegateProviders[i].getClass();
                NavigatorPlugin.log(msg, (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, msg, (Throwable)re));
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean hasChildren(Object anElement) {
        Set resultInstances = this.contentService.findContentExtensionsByTriggerPoint(anElement);
        Iterator itr = resultInstances.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension ext = (NavigatorContentExtension)itr.next();
            if (!ext.isLoaded()) {
                return true;
            }
            if (!ext.getContentProvider().hasChildren(anElement)) continue;
            return true;
        }
        return false;
    }

    public synchronized void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    public synchronized void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.contentService.updateService(aViewer, anOldInput, aNewInput);
    }
}

