/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.SerializerDescriptor;

public class SerializerCollectionDescriptor {
    private IConfigurationElement configurationElement;
    private SerializerDescriptor[] serializerElements;
    private final String dropHandlerId;
    private Map serializerIndex;

    public SerializerCollectionDescriptor(String aDropHandlerId, IConfigurationElement aConfigurationElement, Expression theDefaultEnablement) {
        this.dropHandlerId = aDropHandlerId;
        Assert.isNotNull((Object)aConfigurationElement);
        this.configurationElement = aConfigurationElement;
        this.init(theDefaultEnablement);
    }

    private void init(Expression defaultEnablement) {
        IConfigurationElement[] elements = this.configurationElement.getChildren("serializer");
        this.serializerElements = new SerializerDescriptor[elements.length];
        if (elements != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                this.serializerElements[i] = new SerializerDescriptor(this.dropHandlerId, elements[i], defaultEnablement);
                ++i;
            }
        }
    }

    public SerializerDescriptor[] getSerializersEnabledFor(Object element) {
        ArrayList<SerializerDescriptor> results = new ArrayList<SerializerDescriptor>();
        SerializerDescriptor[] serializerArray = null;
        int i = 0;
        while (i < this.serializerElements.length) {
            try {
                if (this.serializerElements[i].enablement.evaluate((IEvaluationContext)new EvaluationContext(null, element)) == EvaluationResult.TRUE) {
                    results.add(this.serializerElements[i]);
                }
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
            }
            ++i;
        }
        if (results.size() > 0) {
            serializerArray = new SerializerDescriptor[results.size()];
            results.toArray(serializerArray);
        } else {
            serializerArray = new SerializerDescriptor[]{};
        }
        return serializerArray;
    }

    public SerializerDescriptor getSerializerById(String id) {
        return (SerializerDescriptor)this.getSerializerIndex().get(id);
    }

    protected Map getSerializerIndex() {
        if (this.serializerIndex == null) {
            this.serializerIndex = new HashMap();
            int i = 0;
            while (i < this.serializerElements.length) {
                this.serializerIndex.put(this.serializerElements[i].id, this.serializerElements[i]);
                ++i;
            }
        }
        return this.serializerIndex;
    }

    public static interface ExtensionPointElements {
        public static final String ATT_ID = "id";
        public static final String ATT_CLASS = "class";
        public static final String SERIALIZERS = "serializers";
        public static final String SERIALIZER = "serializer";
        public static final String ENABLEMENT = "enablement";
    }
}

