/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.ISerializer;

public class SerializerDescriptor {
    public final String id;
    protected final IConfigurationElement serializerElement;
    public Expression enablement;
    private ISerializer serializer;

    public SerializerDescriptor(String dropHandlerId, IConfigurationElement serializer, Expression dragEnablement) {
        Assert.isNotNull((Object)serializer, (String)CommonNavigatorMessages.SerializerDescriptor_0);
        String localId = serializer.getAttribute("id");
        Assert.isNotNull((Object)localId, (String)CommonNavigatorMessages.SerializerDescriptor_1);
        this.id = String.valueOf(dropHandlerId) + ":" + localId;
        this.serializerElement = serializer;
        IConfigurationElement[] enablementConfigElement = this.serializerElement.getChildren("enablement");
        if (enablementConfigElement.length == 0) {
            this.enablement = dragEnablement;
        } else if (enablementConfigElement.length == 1) {
            try {
                this.enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), enablementConfigElement[0]);
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
                this.enablement = dragEnablement;
            }
        } else {
            NavigatorPlugin.log(NLS.bind((String)CommonNavigatorMessages.SerializerDescriptor_3, (Object[])new Object[]{this.id}));
            this.enablement = dragEnablement;
        }
    }

    public ISerializer getSerializer() {
        if (this.serializer == null) {
            try {
                this.serializer = (ISerializer)this.serializerElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                NavigatorPlugin.log(NLS.bind((String)CommonNavigatorMessages.SerializerDescriptor_5, (Object[])new Object[]{this.id, e.toString()}));
                this.serializer = null;
            }
        }
        return this.serializer;
    }
}

