/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.progress.UIJob;

public class StructuredViewerManager {
    private Viewer viewer;
    private Object cachedOldInput;
    private Object cachedNewInput;

    public StructuredViewerManager(Viewer aViewer) {
        this.viewer = aViewer;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Object anOldInput, Object aNewInput) {
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public boolean initialize(IStructuredContentProvider aContentProvider) {
        boolean result = true;
        try {
            if (aContentProvider != null) {
                aContentProvider.inputChanged(this.viewer, this.cachedOldInput, this.cachedNewInput);
            }
        }
        catch (RuntimeException e) {
            NavigatorPlugin.log(e.toString(), (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, e.toString(), (Throwable)e));
            result = false;
        }
        return result;
    }

    public void safeRefresh() {
        UIJob refreshJob = new UIJob(CommonNavigatorMessages.StructuredViewerManager_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (StructuredViewerManager.this.viewer.getControl().isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    Display display = StructuredViewerManager.this.viewer.getControl().getDisplay();
                    if (!display.isDisposed() && StructuredViewerManager.this.viewer != null) {
                        StructuredViewerManager.this.viewer.refresh();
                    }
                }
                catch (RuntimeException e) {
                    NavigatorPlugin.log(e.toString(), (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, e.toString(), (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.schedule();
    }
}

