/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;
import org.eclipse.ui.internal.ide.registry.MarkerImageProviderRegistry;
import org.eclipse.ui.internal.ide.registry.ProjectImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class IDEWorkbenchPlugin
extends AbstractUIPlugin {
    private static IDEWorkbenchPlugin inst;
    public static boolean DEBUG;
    public static final String IDE_WORKBENCH = "org.eclipse.ui.ide";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String PL_MARKER_IMAGE_PROVIDER = "markerImageProviders";
    public static final String PL_MARKER_HELP = "markerHelp";
    public static final String PL_MARKER_RESOLUTION = "markerResolution";
    public static final String PL_CAPABILITIES = "capabilities";
    public static final String PL_PROJECT_NATURE_IMAGES = "projectNatureImages";
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private ProjectImageRegistry projectImageRegistry = null;
    private MarkerImageProviderRegistry markerImageProviderRegistry = null;
    private CapabilityRegistry capabilityRegistry;

    static {
        DEBUG = false;
    }

    public IDEWorkbenchPlugin() {
        inst = this;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle plugin = Platform.getBundle((String)element.getNamespace());
        if (plugin.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IDEWorkbenchPlugin getDefault() {
        return inst;
    }

    public static IWorkspace getPluginWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(String message) {
        IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
    }

    public static void log(String message, Throwable t) {
        IStatus status = StatusUtil.newStatus(4, message, t);
        IDEWorkbenchPlugin.log(message, status);
    }

    public static void log(Class clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format("Exception in {0}.{1}: {2}", clazz.getName(), methodName, t);
        IDEWorkbenchPlugin.log(msg, t);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        }
        IDEWorkbenchPlugin.getDefault().getLog().log(status);
    }

    protected void refreshPluginActions() {
    }

    public ProjectImageRegistry getProjectImageRegistry() {
        if (this.projectImageRegistry == null) {
            this.projectImageRegistry = new ProjectImageRegistry();
            this.projectImageRegistry.load();
        }
        return this.projectImageRegistry;
    }

    public MarkerImageProviderRegistry getMarkerImageProviderRegistry() {
        if (this.markerImageProviderRegistry == null) {
            this.markerImageProviderRegistry = new MarkerImageProviderRegistry();
        }
        return this.markerImageProviderRegistry;
    }

    public CapabilityRegistry getCapabilityRegistry() {
        if (this.capabilityRegistry == null) {
            this.capabilityRegistry = new CapabilityRegistry();
            this.capabilityRegistry.load();
        }
        return this.capabilityRegistry;
    }

    public AboutInfo[] getFeatureInfos() {
        ArrayList<AboutInfo> infos = new ArrayList<AboutInfo>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                IBundleGroup[] bundleGroups = providers[i].getBundleGroups();
                int j = 0;
                while (j < bundleGroups.length) {
                    infos.add(new AboutInfo(bundleGroups[j]));
                    ++j;
                }
                ++i;
            }
        }
        return infos.toArray(new AboutInfo[infos.size()]);
    }

    public AboutInfo getPrimaryInfo() {
        IProduct product = Platform.getProduct();
        return product == null ? null : new AboutInfo(product);
    }

    public static ImageDescriptor getIDEImageDescriptor(String relativePath) {
        return IDEWorkbenchPlugin.imageDescriptorFromPlugin((String)IDE_WORKBENCH, (String)(ICONS_PATH + relativePath));
    }
}

