/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.model.FileOpenWithEntry;
import org.eclipse.ui.internal.provisional.ide.IEditorOpenStrategy;
import org.eclipse.ui.internal.provisional.ide.OpenWithEntry;
import org.eclipse.ui.internal.provisional.ide.OpenWithInfo;
import org.eclipse.ui.part.FileEditorInput;

public class ResourceEditorOpenStrategy
implements IEditorOpenStrategy {
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();

    public OpenWithInfo getOpenWithInfo(Object element) {
        IFile file = ResourceUtil.getFile(element);
        if (file == null) {
            return null;
        }
        HashSet<IEditorDescriptor> alreadyMapped = new HashSet<IEditorDescriptor>();
        IEditorDescriptor[] editors = this.registry.getEditors(file.getName(), IDE.getContentType(file));
        IEditorDescriptor preferredEditor = IDE.getDefaultEditor(file);
        ArrayList<FileOpenWithEntry> entries = new ArrayList<FileOpenWithEntry>(editors.length);
        FileOpenWithEntry preferredEntry = null;
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                alreadyMapped.add(editor);
                FileOpenWithEntry entry = new FileOpenWithEntry(editor, file);
                entries.add(entry);
                if (editor.equals(preferredEditor)) {
                    preferredEntry = entry;
                }
            }
            ++i;
        }
        FileOpenWithEntry externalEntry = null;
        IEditorDescriptor externalEditor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        externalEntry = new FileOpenWithEntry(externalEditor, file);
        if (preferredEntry == null && externalEditor.equals(preferredEditor)) {
            preferredEntry = externalEntry;
        }
        FileOpenWithEntry inPlaceEntry = null;
        if (this.registry.isSystemInPlaceEditorAvailable(file.getName())) {
            IEditorDescriptor inPlaceEditor = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
            inPlaceEntry = new FileOpenWithEntry(inPlaceEditor, file);
            if (preferredEntry == null && inPlaceEntry.equals(preferredEditor)) {
                preferredEntry = externalEntry;
            }
        }
        OpenWithEntry defaultEntry = new OpenWithEntry(null, file){

            public void openEditor(IWorkbenchPage page, boolean activate, int matchFlags, boolean rememberEditor) throws PartInitException {
                IFile f = (IFile)this.getElement();
                IDE.setDefaultEditor(f, null);
                IEditorDescriptor desc = IDE.getEditorDescriptor(f);
                page.openEditor((IEditorInput)new FileEditorInput(f), desc.getId(), activate, matchFlags);
            }
        };
        IEditorDescriptor textEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        if (!alreadyMapped.contains(textEditor)) {
            FileOpenWithEntry textEditorEntry = new FileOpenWithEntry(textEditor, file);
            entries.add(textEditorEntry);
            if (preferredEntry == null) {
                preferredEntry = textEditorEntry;
            }
        }
        OpenWithEntry[] entryArray = entries.toArray(new OpenWithEntry[entries.size()]);
        return new OpenWithInfo(entryArray, preferredEntry, externalEntry, inPlaceEntry, defaultEntry);
    }
}

