/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.provisional.ide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.internal.provisional.ide.OpenWithEntry;

public class OpenWithInfo {
    private OpenWithEntry[] entries;
    private OpenWithEntry preferredEntry;
    private OpenWithEntry externalEntry;
    private OpenWithEntry inPlaceEntry;
    private OpenWithEntry defaultEntry;

    public OpenWithInfo() {
        this(new OpenWithEntry[0], null, null, null, null);
    }

    public OpenWithInfo(OpenWithEntry[] entries, OpenWithEntry preferredEntry, OpenWithEntry externalEntry, OpenWithEntry inPlaceEntry, OpenWithEntry defaultEntry) {
        Assert.isNotNull((Object)entries);
        this.entries = entries;
        this.preferredEntry = preferredEntry;
        this.externalEntry = externalEntry;
        this.inPlaceEntry = inPlaceEntry;
        this.defaultEntry = defaultEntry;
    }

    public OpenWithEntry getDefaultEntry() {
        return this.defaultEntry;
    }

    public OpenWithEntry[] getEntries() {
        return this.entries;
    }

    public OpenWithEntry getInPlaceEntry() {
        return this.inPlaceEntry;
    }

    public OpenWithEntry getPreferredEntry() {
        return this.preferredEntry;
    }

    public OpenWithEntry getExternalEntry() {
        return this.externalEntry;
    }

    public OpenWithInfo mergeWith(OpenWithInfo other) {
        OpenWithEntry otherPreferredEntry;
        OpenWithEntry defaultEntry;
        OpenWithEntry inPlaceEntry;
        OpenWithEntry externalEntry;
        HashSet<IEditorDescriptor> seenDescriptors = new HashSet<IEditorDescriptor>();
        OpenWithEntry[] thisEntries = this.getEntries();
        int i = 0;
        while (i < thisEntries.length) {
            OpenWithEntry entry = thisEntries[i];
            if (entry.getEditorDescriptor() != null) {
                seenDescriptors.add(entry.getEditorDescriptor());
            }
            ++i;
        }
        OpenWithEntry[] otherEntries = other.getEntries();
        ArrayList<OpenWithEntry> mergedEntries = new ArrayList<OpenWithEntry>(thisEntries.length + otherEntries.length);
        mergedEntries.addAll(Arrays.asList(thisEntries));
        int i2 = 0;
        while (i2 < otherEntries.length) {
            OpenWithEntry entry = otherEntries[i2];
            if (entry.getEditorDescriptor() != null && !seenDescriptors.contains(entry.getEditorDescriptor())) {
                seenDescriptors.add(entry.getEditorDescriptor());
                mergedEntries.add(entry);
            }
            ++i2;
        }
        HashSet<OpenWithEntry> allEntries = new HashSet<OpenWithEntry>(mergedEntries.size() + 3);
        allEntries.addAll(mergedEntries);
        OpenWithEntry openWithEntry = externalEntry = this.getExternalEntry() != null ? this.getExternalEntry() : other.getExternalEntry();
        if (externalEntry != null) {
            allEntries.add(externalEntry);
        }
        OpenWithEntry openWithEntry2 = inPlaceEntry = this.getInPlaceEntry() != null ? this.getInPlaceEntry() : other.getInPlaceEntry();
        if (inPlaceEntry != null) {
            allEntries.add(inPlaceEntry);
        }
        OpenWithEntry openWithEntry3 = defaultEntry = this.getDefaultEntry() != null ? this.getDefaultEntry() : other.getDefaultEntry();
        if (defaultEntry != null) {
            allEntries.add(defaultEntry);
        }
        OpenWithEntry thisPreferredEntry = this.getPreferredEntry() != null && allEntries.contains(this.getPreferredEntry()) ? this.getPreferredEntry() : null;
        OpenWithEntry openWithEntry4 = otherPreferredEntry = other.getPreferredEntry() != null && allEntries.contains(other.getPreferredEntry()) ? other.getPreferredEntry() : null;
        OpenWithEntry preferredEntry = thisPreferredEntry != null ? (otherPreferredEntry != null ? null : thisPreferredEntry) : otherPreferredEntry;
        OpenWithEntry[] mergedEntryArray = mergedEntries.toArray(new OpenWithEntry[mergedEntries.size()]);
        return new OpenWithInfo(mergedEntryArray, preferredEntry, externalEntry, inPlaceEntry, defaultEntry);
    }
}

