/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.markers.internal.AbstractField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class FieldPriority
extends AbstractField {
    static final String DESCRIPTION_IMAGE_PATH = "obj16/header_priority.gif";
    static final String HIGH_PRIORITY_IMAGE_PATH = "obj16/hprio_tsk.gif";
    static final String LOW_PRIORITY_IMAGE_PATH = "obj16/lprio_tsk.gif";
    private String description = MarkerMessages.priority_description;

    public String getDescription() {
        return this.description;
    }

    private Image getImage(String path) {
        return JFaceResources.getResources().createImageWithDefault(IDEWorkbenchPlugin.getIDEImageDescriptor(path));
    }

    public Image getDescriptionImage() {
        return this.getImage(DESCRIPTION_IMAGE_PATH);
    }

    public String getColumnHeaderText() {
        return "";
    }

    public Image getColumnHeaderImage() {
        return this.getDescriptionImage();
    }

    public String getValue(Object obj) {
        return "";
    }

    public Image getImage(Object obj) {
        if (obj == null || !(obj instanceof TaskMarker)) {
            return null;
        }
        try {
            int priority = ((TaskMarker)obj).getPriority();
            if (priority == 2) {
                return this.getImage(HIGH_PRIORITY_IMAGE_PATH);
            }
            if (priority == 0) {
                return this.getImage(LOW_PRIORITY_IMAGE_PATH);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return null;
    }

    public int compare(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null || !(obj1 instanceof TaskMarker) || !(obj2 instanceof TaskMarker)) {
            return 0;
        }
        int priority1 = ((TaskMarker)obj1).getPriority();
        int priority2 = ((TaskMarker)obj2).getPriority();
        return priority1 - priority2;
    }

    public int getDefaultDirection() {
        return 1;
    }

    public int getPreferredWidth() {
        return 16;
    }
}

